<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Test\Logger;

use Mnv\Models\Brands;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class BrandsAdmin
 * @package Mnv\Admin\Controllers
 */
class BrandsAdmin extends AdminMnv
{

    public function fetch()
    {
        $brand = new Brands($this->request);

        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');

        /** удаление */
         if ($this->action == 'remove') {
             try {
                 $brand->remove();
                 $status = \Mnv\Http\Response::HTTP_OK;
                 $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('brands:messages:2')
             } catch (DatabaseException|NoContentException|NotFoundException $e) {
                 $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                 $response = array('status' => $status, 'data' => $brand->status, 'message' => $e->getMessage(), 'type' => 'error');
             }
             response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             exit();
        }
         /** изменение статуса */
         elseif ($this->action == 'status') {

             try {
                 $brand->status();
                 $status = \Mnv\Http\Response::HTTP_OK;
                 $response = array('status' => $status, 'data' => $brand->status, 'message' => lang('general:restatus'), 'type' => 'success');
             } catch (NoContentException|NotFoundException $e) {
                 $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                 $response = array('status' => $status, 'data' => $brand->status, 'message' => $e->getMessage(), 'type' => 'error');
             }
             response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             exit();
         }
         /** одобрение */
         elseif ($this->action == 'approve') {

             try {
                 $brand->approve();
                 response()->make("document.getElementById('status-$brand->id ').innerHTML = 'Включено';", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
             } catch (NotFoundException $e) {

             }

        }
        // не делал еще
//        else if ($this->action == 'reorder') {
//
//            $ids = array_values($this->brandIds);
//            sort($this->brandIds);
//            //$this->brandIds = array_reverse($this->brandIds);
//            $this->reorderBrand($ids, $this->brandIds, 'brandId', $this->brandId);
//
//        }
          else {

            $brand->filter = array_filter([
                'query'         => $this->query,
                'status'        => $this->filter['status'] ?? '',
            ]);
            /** получение всех статей */
            $brands = collect($brand->all( $this->limit, $this->page))->map(function ($item) use ($brand) {
                $item['image'] = !empty($item['image']['small']) ? $item['image']['small'] : '/admin/assets/images/no_images.jpg';

                return $item;
            })->all();


            /** pagination */
            $brand->total();
            $pages = getPageNums($brand->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalBrands', $brand->total);
            $this->smarty->assign('brands', $brands);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('brands')) {
            return $this->smarty->fetch('views/brands/brands.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}