<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\Colors;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarColorsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarColorsAdmin extends AdminMnv
{

    /**
     * Вывод всех статей
     */
    public function fetch()
    {
        $colors = new Colors($this->request);

        /** модуль */
        $title = ($this->module == 'bcolors') ?'Цвет кузова' : 'Цвет салона';

        /** title */
        $this->smarty->assign('title', $title);
        /** activeItem */
        $this->smarty->assign('activeItem', $this->module);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);
        
        /** действия */
        if ($this->action == 'remove') {
            try {
                $colors->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success');
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $colors->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $colors->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $colors->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'reorder') {

            $i = 0;
            $colors->data = [];
            foreach ($colors->colorIds as $colorId) {
                $i++;
                $colors->id = $colorId;
                $colors->data['orderBy'] = $i;
                connect()->where('colorType', $this->module);

                $colors->update($colors->data);
            }
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        else {

            $colors->filter = array_filter([
                'status'        => $this->filter['status'] ?? null,
                'query'         => $this->query,
                'colorType'     => $this->module,
            ]);

            /** получение всех статей */
            $contents = collect($colors->all($this->limit, $this->page))->map(function ($item) use ($colors) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);
                $item['equipments']  =  $colors->getColorModels($item['colorId']);


                return $item;
            })->all();

            /** pagination */
            $colors->total();
            $pages = getPageNums($colors->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalColors', $colors->total);
            $this->smarty->assign('colors', $contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions($this->module)) {
            return $this->smarty->fetch('views/cars/' . $this->module . '.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}