<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Colors;
use Mnv\Models\Cars\Equipments;
use Mnv\Models\Cars\Modifications;
use Mnv\Models\Cars\PricePdf;

/**
 * Class CarEquipmentAdmin
 * @package Mnv\Admin\Controllers
 */
class CarEquipmentAdmin extends AdminMnv
{

    public function fetch()
    {

        $equipment     = new Equipments($this->request);
        $modifications  = new Modifications($this->request);

        $this->smarty->assign('activeItem', 'equipments');
        $this->smarty->assign('title', 'Комплектация');
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        $this->smarty->assign('adjustedNow', adjustTime(gmdate('Y-m-d H:i:s')));



        /** работа с галереей */
        $image        = $this->request->get('image', '');
        $gallery      = $this->request->get('gallery', '');
        $docs         = $this->request->get('docs', '');

        $imageIds     = $this->request->get('imageIds', '');

        $imageId      = (int) $this->request->get('imageId', '');
        $picture    = $this->request->get('picture', '');

//        $colors       = $this->request->get('colors', '');
//        $colorIds     = $this->request->get('bcolor', '');

//        print_r($colors);

//        print_r($colors);
        $sections = Helpers::getSectionContent(0, 'models');
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        /** получить модели */
        $models = array('0' => 'Выберите модель...');
        $models += CarModels::getModels();
        $this->smarty->assign('models', $models);

        /** существующие модификации */
        $this->smarty->assign('modifications', Modifications::getSelectModifications());

        // action добавление/редактирование
        if ($this->action == 'add' || $this->action == 'edit') {
            $equipment->edit()->getFiles()->gettingInfoAboutUsers()->getEquipmentOptions()->getModeBColors()->getModeIColors();
        }
        /** action сохранение */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($equipment->data['title'])) $this->errors['title'] = true;

            if (!empty($equipment->data['price'])) {
                $equipment->data['price'] = \trim($equipment->data['price']);
                $equipment->data['price'] = str_replace(" ", "", $equipment->data['price']);
            } else {
                $equipment->data['price'] = 0;
            }
            if (!empty($equipment->data['oldPrice'])) {
                $equipment->data['oldPrice'] = \trim($equipment->data['oldPrice']);
                $equipment->data['oldPrice'] = str_replace(" ", "", $equipment->data['oldPrice']);
            } else {
                $equipment->data['oldPrice'] = 0;
            }

            /** проверка доступных разделов */
            if (!empty($equipment->data['modificationId'])) {
                $equipment->data['modelId'] = $equipment->getModelId($equipment->data['modificationId']);
                $equipment->data['sectionId'] = $equipment->getModelSectionId($equipment->data['modelId']);
            } else {
                $this->errors['modificationId'] = true;
            }

            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;
            /** включить / отключить галерею у данного контента */
            $equipment->data['enableGallery'] = isset($equipment->data['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;
            /** файлы */
            $images['docs'] = !empty($docs) ? $docs : '';

//            print_r($equipment->data);
            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
               if ($equipment->prepare($equipment->data, $this->manager['userId'])) {

                   if (!empty($images['general'])) $equipment->addFiles($equipment->id, $images);
                   if (!empty($images['gallery'])) $equipment->addFiles($equipment->id, $images, 'gallery');
                   if (!empty($images['docs'])) $equipment->addFiles($equipment->id, $images, 'docs');

                   $equipment->updateOptions();

                    // работа с цветами комплектации
//                   if (is_array($colors)) {
//                       foreach ($colors as &$color) {
//                           $color['modelId']     = $equipment->data['modelId'];
//                           $color['equipmentId'] = $equipment->id;
//                           if (empty($color['price'])) $color['price'] = '0.00';
//                           /** если уже существует цвета модели то обновляем его в противном случае добавляем */
//                           if (isset($color['imageId']) && !empty($color['imageId'])) {
//                               /** обновляем цвет модели  */
//                               $equipment->updateColor($color['imageId'], $color);
//                           } else {
//                               /** добавление цвета модели */
//                               $equipment->addColor($color);
//                           }
//                       }
//                   }


//                   if (!empty($equipment->id)) {
//                       $generationPdf = new PricePdf($equipment->id);
//                       $generationPdf->generationHtml()->save(SITE_LANG);
//                   }

//                   if (!empty($equipment->specifications)) {
//                       $equipment->updateSpecifications($equipment->specifications, $equipment->data['modelId']);
//                   }


                    $this->messages['saved'] = true;

                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $equipment->edit()->getFiles()->gettingInfoAboutUsers()->getEquipmentOptions()->getModeBColors()->getModeIColors();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString('equipments', ['page' => $this->page]));
            }

        }
//        else if ($this->action == 'generationPricePdf') {
//            if (!empty($equipment->id)) {
//                $generationPdf = new PricePdf($equipment->id);
//                $result = $generationPdf->generationHtml()->save() ? array('status' => 200) : array('status' => 400);
//
//                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//                exit();
//            }
//        }

        /** удаление основной картинки */
        else if ($this->action == 'deleteFile') {
            $result = $equipment->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** удаление основной картинки */
        else if ($this->action == 'editPictureInfo') {
            $response = $equipment->editPicture($imageId, $picture)
                ? array('status' => 200, 'title' => $equipment->result['title'], 'alias' => $equipment->result['alias'], 'description' => $equipment->result['description'], 'link' => $equipment->result['link'], 'position' => $equipment->result['position'])
                : array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка картинок в галерее */
        else if ($this->action == 'sortPictures') {
            $result = $equipment->sortingPictures($imageIds)
                ? array('status' => 200, 'message' =>  lang('javascript:sortingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:sortingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        /** удаление картинки из галереи */
        else if ($this->action == 'deleteColors') {

            $result = $equipment->deleteColor($imageId) ? array('status' => 200, 'message' => 'Цвет удален', 'type' => 'success') :  array('status' => 400, 'message' => 'Цвет не удален, обновить страницу и повторите удаление', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка цвета (салона и кузова) */
        else if ($this->action == 'sortByColors') {
            $i = 0;
            foreach ($imageIds as  $imageId) {
                $i++;
                $equipment->sortByColors($imageId, $i);
            }

            response()->json(array('status' => 200, 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        if (!empty($equipment->id)) {
            /** цвета кузова */
            $bColors = Colors::getModelColors($equipment->data['modelId'], 'bcolors');
            $this->smarty->assign('bcolors', $bColors);

            /** цвета салона */
            $iColors = Colors::getModelColors($equipment->data['modelId'], 'icolors');
            $this->smarty->assign('icolors', $iColors);

            /** получить двигатели данной комплектации */
            $options = $equipment->getOptions($equipment->data['modelId']);
            $this->smarty->assign('options', $options);
        }


//        print_r($equipment->data);

        $this->smarty->assign('equipment', $equipment->data);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions('equipments')) {
            return $this->smarty->fetch('views/cars/equipment.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}