<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Helpers;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Equipments;
use Mnv\Models\Cars\Modifications;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarEquipmentsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarEquipmentsAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $equipment     = new Equipments($this->request);
        $modifications  = new Modifications($this->request);

        /** title */
        $this->smarty->assign('title', 'Комплектации');
        /** activeItem */
        $this->smarty->assign('activeItem', 'equipments');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);
        /** получение разделов по типу контента */
        $sections = Helpers::getSectionContent(0, 'models');


        /** удаление */
        if ($this->action == 'remove') {
            try {
                $equipment->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {

            try {
                $equipment->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $equipment->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $equipment->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        } else {
            $sectionIds = [];
            if (!empty($this->filter['section']) && !empty($SECTIONS[$this->filter['section']])) {
                $sectionIds = array($this->filter['section']);
                if (!empty($SECTIONS[$this->filter['section']]['allChildren'])) {
                    $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filter['section']]['allChildren']);
                }
            }

            /** фильтровать контента */
            $equipment->filter = array_filter([
                'status'        => $this->filter['status'] ?? '',
                'query'         => $this->query,
                'model_id'      => $this->filter['model'] ?? '',
                'section'       => $this->filter['section'] ?? '',
            ]);

            /** получение всех статей */
            $equipments = collect($equipment->all($this->limit, $this->page))->map(function ($item) use ($modifications, $equipment) {
                $item['statusName']     = lang('general:statuses:' . $item['status']);
                $item['model']          = CarModels::getModel($item['modelId']);
                $item['modification']   = Modifications::getModification($item['modificationId']);
                $item['image']    = !empty($item['image']['small']) ? $item['image']['small'] : '/admin/assets/images/no_images.jpg';

                return $item;
            })->all();

//            print_r($equipments);

            /** Получение кол-во статей */

            /** pagination */
            $equipment->total();
            $pages = getPageNums($equipment->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $equipment->total);
            $this->smarty->assign('equipments', $equipments);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);
        }

        /** получить модели */
        $models = array('0' => 'Выберите модель...');
        $result = CarModels::getModels($sectionIds);
        if (!empty($result)) $models += $result;
        $this->smarty->assign('models', $models);


//        print_r( $this->buildQueryString);

        /** Права доступа к данному шаблону */
        if ($this->permissions('equipments')) {
            return $this->smarty->fetch('views/cars/equipments.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}