<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Helpers;

use Mnv\Models\Cars\CarModelBlocks;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarModelBlocksAdmin
 * @package Mnv\Admin\Controllers
 */
class CarModelBlocksAdmin extends AdminMnv
{

    public function fetch()
    {
        $block = new CarModelBlocks($this->request);

        /** title */
        $this->smarty->assign('title', 'Инфоблоки');
        /** activeItem */
        $this->smarty->assign('activeItem', 'models');
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        $models = array('0' => 'Выберите модель...');
        $result = CarModels::getModels();
        if (!empty($result)) $models += $result;
        $this->smarty->assign('models', $models);

        /** действия */
        if ($this->action == 'remove') {
            try {
                $block->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success');
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** статус */
        else if ($this->action == 'status') {
            try {
                $block->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $block->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $block->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }  else if ($this->action == 'reorder') {
            $i = 0;
            $block->data = [];
            foreach ($block->blockIds as $blockId) {
                $i++;
                $block->id = $blockId;
                $block->data['orderBy'] = $i;
                $block->update($block->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        } else {

            /** фильтровать контента */
            $block->filter = array_filter([
                'status'        => $this->filter['status'] ?? null,
                'model_id'      => $this->filter['model'] ?? null,
                'query'         => $this->query,
            ]);

            /** получение всего контента */
            $blocks = collect($block->all($this->limit, $this->page))->map(function ($item) use ($block) {
                $item['statusName']  = lang('general:statuses:' . $item['status']);
                $item['model']       = CarModels::getModel($item['modelId']);
                $item['position']    = $block->positions[$item['position']];
                $item['typeName']    = $block->types[$item['type']];

                return $item;
            })->all();

            /** pagination */
            $block->total();
            $pages = getPageNums($block->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalBlocks', $block->total);
            $this->smarty->assign('blocks', $blocks);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }



        /** Права доступа к данному шаблону */
        if ($this->permissions('models')) {
            return $this->smarty->fetch('views/cars/blocks.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}