<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Helpers;

use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Vehicle;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotContentApproveException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarModelsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarModelsAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $dateSelector = new StatsDateSelector(false, 'contentDateSelector');

        $content = new CarModels($this->request);

        $group_action  = $this->request->get('group_action');

        /** title */
        $this->smarty->assign('title', 'Модель');
        /** activeItem */
        $this->smarty->assign('activeItem', $this->module);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);
        /** type content */
        $content->typeContent = $this->request->get('typeContent', $this->module);

        /** получение разделов по типу контента */
        $sections = Helpers::getSectionSelect(0, $content->typeContent);

        /** действия */
        if ($this->action === 'remove') {
            try {
                $content->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action === 'status') {
            try {
                $content->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $content->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** одобрение */
        else if ($this->action === 'approve') {
            try {
                $content->approve();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status,'message' => 'Запись была опубликована без предварительной модерации.', 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        /** Групповые действия  */
        else if ($this->action === 'group') {
            if (!empty($group_action)) {
                if (!empty($content->contentIds)) {
                    foreach ($content->contentIds as $contentId) {
                        $content->id = $contentId;
                        $content->group($group_action);
                    }
                    $response = array('status' => 200, 'message' => 'Успешно выполнено', 'type' => 'success');
                } else {
                    $response =  array('status' => 500, 'message' => 'Необходимо выбрать контент', 'type' => 'error');
                }
            } else {
                $response =  array('status' => 500, 'message' => 'Необходимо выбрать действие', 'type' => 'error');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        else {

            /** фильтровать контента */
            $content->filter = array_filter([
                'dateStart'     => $dateSelector->dateStart,
                'dateEnd'       => $dateSelector->dateEnd,
                'typeContent'   => $content->typeContent,
                'query'         => $this->query,
                'status'        => $this->filter['status'] ?? '',
                'section'       => $this->filter['section'] ?? '',
            ]);


            /** получение всего контента */
            $contents = collect($content->all($this->limit, $this->page))->map(function ($item) use ($content, $SECTIONS) {
                $item['statusName']     = lang('general:statuses:' . $item['status']);
                $item['publishedOn']    = langDate(adjustTime($item['publishedOn'], false, 'd.m.Y'));
                $item['image']    = !empty($item['image']['small']) ? $item['image']['small'] : '/admin/assets/images/no_images.jpg';
                $item['section']        = isset($SECTIONS[$item['sectionId']]) ? $SECTIONS[$item['sectionId']]['name'] : '';

                return $item;
            })->all();

//            print_r($contents);

            /** pagination */
            $content->total();
            $pages = getPageNums($content->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $content->total);
            $this->smarty->assign('models', $contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);

        }


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->permissions($this->module)) {
            try {
                return $this->smarty->fetch('views/cars/'.$this->module.'.tpl');
            } catch (\SmartyException | \Exception $e) {
                print $e->getMessage();
            }
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

//        if ($this->permissions($this->module)) {
//            return $this->smarty->fetch('views/cars/'.$this->module.'.tpl');
//        }
//
//        $this->smarty->assign('title', lang('general:accessIsDenied'));
//        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}