<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;
use Mnv\Models\Cars\CarEngine;
use Mnv\Models\Cars\CarGear;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\CarTransmission;
use Mnv\Models\Cars\Equipments;
use Mnv\Models\Cars\Modifications;

/**
 * Class CarModificationAdmin
 * @package Mnv\Admin\Controllers
 */
class CarModificationAdmin extends AdminMnv
{

    public function fetch()
    {
        $modifications  = new Modifications($this->request);
        $equipments = new Equipments($this->request);

        $this->smarty->assign('activeItem', 'modifications');
        $this->smarty->assign('title', 'Модификация');

        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

        $models = array('0' => 'Выберите модель...');
        $models += CarModels::getModels();
        $this->smarty->assign('models', $models);

        $this->smarty->assign('equipments', $equipments->getEquipments());

//        $this->smarty->assign('engines',  $modifications->engines);
        $this->smarty->assign('engines', CarEngine::getEngines());
        $this->smarty->assign('transmissions', CarTransmission::getTransmissions());
        $this->smarty->assign('gear_type',  CarGear::getGears());

        $sections = Helpers::getSectionContent(0, 'models');
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);

        if ($this->action == 'add' || $this->action == 'edit') {

            $modifications->edit();
        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($modifications->data['name'])) $this->errors['title'] = true;
            if (empty($modifications->data['modelId'])) $this->errors['modelId'] = true;
            if (empty($modifications->data['engine'])) $this->errors['engine'] = true;
            if (empty($modifications->data['transmission'])) $this->errors['transmission'] = true;
            if (empty($modifications->data['gear'])) $this->errors['gear'] = true;

//            if (empty($modifications->equipmentIds)) {
//                $this->errors['equipmentIds'] = true;
//            } else {
//                $modifications->data['modelId']  = $equipments->getModelId();
//            }

//            print_r($modifications->data);
            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($modifications->prepare($modifications->data, $this->manager['userId'])) {
                    // спецификации
                    if (!empty($modifications->specifications)) {
                        $modifications->updateSpecifications($modifications->specifications);
                    }

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $modifications->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString($this->module . "s", ['page' => $this->page]));
            }
        }

        /** спецификация */
        $specifications = $modifications->getFeaturesSpecificationsValues();
        $this->smarty->assign('features', $specifications);

        $this->smarty->assign('modification', $modifications->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }

        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('modifications')) {
            return $this->smarty->fetch('views/cars/modification.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}