<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\Options;
use Mnv\Models\Cars\Equipments;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarOptionsAdmin
 * @package Mnv\Admin\Controllers
 */
class CarOptionsAdmin extends AdminMnv
{

    public function fetch()
    {
        $option = new Options($this->request);
        $equipments = new Equipments($this->request);

        /** title */
        $this->smarty->assign('title', 'Свойства опций');
        /** activeItem */
        $this->smarty->assign('activeItem', 'options');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        /** Получение всех комплектации */
        $this->smarty->assign('equipments', $equipments->getEquipments());

        
        /** действия */
        if ($this->action == 'remove') {
            try {
                $option->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $option->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $option->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $option->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $option->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'reorder') {
            $i = 0;
            $option->data = [];
            foreach ($option->optionIds as $optionId) {
                $i++;
                $option->id = $optionId;
                $option->data['orderBy'] = $i;
                $option->update($option->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        else {

            /** фильтровать контента */
            $option->filter = array_filter([
                'status'        => $this->filter['status'] ?? '',
                'query'         => $this->query,
            ]);

            $options = collect($option->all($this->limit, $this->page))->map(function ($item) use ($option) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);
                $item['models'] = $option->getOptionModels($item['optionId']);

                return $item;
            })->all();

            /** Получение кол-во статей */

            /** pagination */
            $option->total();
            $pages = getPageNums($option->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $option->total);
            $this->smarty->assign('options', $options);
            $this->smarty->assign('pageNums', $pages);

            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('options')) {
            return $this->smarty->fetch('views/cars/options.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}