<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Models\Cars\CarModels;
use Mnv\Models\Cars\Specifications;

/**
 * Class CarSpecificationAdmin
 * @package Mnv\Admin\Controllers
 */
class CarSpecificationAdmin extends AdminMnv
{

    public function fetch()
    {
        $specification = new Specifications($this->request);

        $this->smarty->assign('title', 'Свойство спецификаций');
        $this->smarty->assign('activeItem', 'specifications');

        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

//        /** получить модели */
//        $models = array('0' => 'Выберите модель...');
//        $models += CarModels::getModels();
//        $this->smarty->assign('models', $models);

        if ($this->action == 'add' || $this->action == 'edit') {
            $specification->edit();
        }

        else if ($this->action == 'save' || $this->action == 'apply') {
            /** проверка полей */
            if (empty($specification->data['name'])) $this->errors['title'] = true;
//            if (empty($specification->modelIds)) $this->errors['modelIds'] = true;

//            print_r($specification->data);

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($specification->prepare($specification->data, $this->manager['userId'])) {
//                    $specification->updateFeatureModels();

                    if (is_array($specification->params)) {
                        $paramIds = array();

                        foreach($specification->params as &$param) {
                            if (isset($param['specificationId']) && !empty($param['specificationId'])) {
                                $specification->updateSpecification($param['specificationId'], $param, $this->manager['userId']);
                            } else {
                                $param['specificationId'] = $specification->addSpecification($param, $this->manager['userId']);
                            }

                            $param = $specification->specification($param['specificationId']); // ОШИБКА
                            if (!empty($param['specificationId'])) {
                                $paramIds[] = $param['specificationId'];
                            }
                        }

                        /** возвращает specifications  */
                        $currentSpecifications = $specification->specifications();
                        /** Удаляем непереданные */
                        foreach($currentSpecifications as $currentSpecification) {
                            if (!in_array($currentSpecification['specificationId'], $paramIds, true)) {
                                $specification->removeSpecification($currentSpecification['specificationId']);
                            }
                        }

                        /** Отсортировать */
                        asort($paramIds);
                        $i = 0;
                        foreach($paramIds as $paramId) {
                            /** обновляем */
                            $specification->updateSpecification($paramIds[$i], ['orderBy' => $paramId], $this->manager['userId']);
                            $i++;
                        }
                    } else {
                        $currentSpecifications = $specification->specifications();
                        /** Удаляем непереданные */
                        foreach($currentSpecifications as $currentSpecification) {
                            $specification->removeSpecification($currentSpecification['specificationId']);
                        }
                    }

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }


            }

            $specification->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString($this->module . "s", ['page' => $this->page]));
            }

        }

        $specifications = [];
        if (!empty($specification->id)) {
            $specifications = $specification->specifications();
//            $specification->data['models'] = $specification->getModelsFeature();
        }

        $this->smarty->assign('specifications', $specifications);

        $this->smarty->assign('specification', $specification->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }

        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('specifications')) {
            return $this->smarty->fetch('views/cars/specification.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}