<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Cars\CarTypes;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class CarTypesAdmin
 * @package Mnv\Admin\Controllers
 */
class CarTypesAdmin extends AdminMnv
{

    public function fetch()
    {
        $vehicle = new CarTypes($this->request);

        /** title */
        $this->smarty->assign('title', 'Тип автотранспорта');
        /** activeItem */
        $this->smarty->assign('activeItem', 'types');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $vehicle->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success');
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();

        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $vehicle->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $vehicle->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $vehicle->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        else if ($this->action == 'reorder') {

            $i = 0;
            $vehicle->data = [];
            foreach ($vehicle->typeIds as $typeId) {
                $i++;
                $vehicle->id = $typeId;
                $vehicle->data['orderBy'] = $i;
                $vehicle->update($vehicle->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }
        else {

            /** фильтровать контента */
            $vehicle->filter = array_filter([
                'status'        => $this->filter['status'] ?? null,
                'query'         => $this->query,
            ]);

            $vehicles = collect($vehicle->all($this->limit, $this->page))->map(function ($item) use ($vehicle) {
                $item['statusName'] = lang('general:statuses:' . $item['status']);
                $item['types'] = $vehicle->bodyTypes($item['typeId']);

                return $item;
            })->all();

//            print_r($vehicles);

            /** pagination */
            $vehicle->total();
            $pages = getPageNums($vehicle->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $vehicle->total);
            $this->smarty->assign('vehicles', $vehicles);
            $this->smarty->assign('pageNums', $pages);

            $this->smarty->assign('page', $this->page);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('types')) {
            return $this->smarty->fetch('views/cars/types.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}