<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\ContentType;
use Mnv\Models\ContentTypeCustomField;
use Mnv\Models\UserGroups;

/**
 * Class ContentTypeAdmin
 */
class ContentTypeAdmin extends AdminMnv
{

    public function fetch()
    {

        $content = new ContentType($this->request);

        $this->smarty->assign('activeItem','articles');
        $this->smarty->assign('title', 'Настройка контента');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));

        /** получить дополнительные поля по типу контента */
        $fields = collect(ContentTypeCustomField::contentTypeFields($content->id, ''))->map(function ($item) {
            $item['typeName'] = ContentTypeCustomField::getNameTypeField($item['type']);
            $item['statusName'] = lang('general:statuses:' . $item['status']);

            if ($item['type'] == 'R' || $item['type'] == 'S') {
                $item['properties'] = ContentTypeCustomField::contentTypeFieldProperty('propertyId ASC', $item['fieldId']);
            }

            return $item;
        })->all();

        $this->smarty->assign('fields', $fields);

        $this->smarty->assign('typeFields', ContentTypeCustomField::getTypeFields());
        $this->smarty->assign('groups', UserGroups::selectGroup($this->manager['userType']));

        /** создание и редактирование */
        if ($this->action == 'edit' || $this->action == 'add') {

            $content->edit()->gettingInfoAboutUsers();
            if (!empty($content->id)) $content->getPrivileges();

        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($content->data['name'])) $this->errors['name'] = true;

            if (empty($content->data['fileName'])) $this->errors['fileName'] = true;
            if (preg_match('/^(type\d+|contents|content)$/i', $content->data['fileName'])) $this->errors['fileNameProhibited'] = true;
            if (preg_match("/[^a-z\s]/iu", $content->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            $content->data['fileName'] = strtolower($content->data['fileName']);

            if ($fileName = $content->checkFileName($content->data['fileName'])) {
                if ($fileName == $content->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->data['fileName'] = $fileName;
                }
            }

            $data = [];

            $modules = ['image', 'gallery', 'document', 'seo', 'publishEnd'];
            foreach ($modules as $module) {
                $data[$module] = !empty($content->modules[$module]) ? 1 : 0;
            }

            $content->data['modules'] = json_encode($data, JSON_UNESCAPED_UNICODE);

            if (empty($this->errors)) {
                if ($content->prepare($content->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $content->edit()->gettingInfoAboutUsers();
            if (!empty($content->id)) {
                $content->getPrivileges();
            }

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("contenttypes", ['page' => $this->page]));
            }

        }

        $content->data['modules'] = !empty($content->data['modules'])
            ? json_decode($content->data['modules'], true)
            : [];

        $this->smarty->assign('type', $content->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserGroups::DEVELOPER) {
            return $this->smarty->fetch('views/contents/type.tpl');
        }


        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



