<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\SerializationManager;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Shop\Currencies;

/**
 * Class CurrenciesAdmin
 * @package Mnv\Admin\Controllers
 */
class CurrenciesAdmin extends AdminMnv
{

    public function fetch()
    {
        $build = new SerializationManager();
        $currency = new Currencies($this->request);

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $currency->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success');  //  lang('currency:messages:deleted')
                if (!$build->saveSerializations()) {
                    $this->errors['serializations'] = true;
                }
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $currency->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $currency->data = [];
            foreach ($currency->currencyIds as $currencyId) {
                $i++;
                $currency->id = $currencyId;
                $currency->data['orderBy'] = $i;
                $currency->update($currency->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }
        else if (($this->action == 'setDefaultCurrency') && $currency->setDefaultCurrency() && !$build->saveSerializations()) {
            $this->errors['serializations'] = true;
        }


        $currencies = $currency->all($this->limit, $this->page);

        /** pagination */
        $currency->total();
        $pages = getPageNums($currency->total, $this->page, $this->limit, 0, 4, 4, 0);

        /** вывод в шаблон результатов */
        $this->smarty->assign('currencySelectList', $currency->currencySelectList());
        $this->smarty->assign('totalCurrencies', $currency->total);
        $this->smarty->assign('currencyList', $currencies);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('currencies')) {
            return $this->smarty->fetch('views/currencies/currencies.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


    



