<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\AdminMnv;
use Mnv\Models\Countries;
use Mnv\Models\Dealers;
use Mnv\Models\GeoCities;

/**
 * Class DealerAdmin
 * @package Mnv\Admin\Controllers
 */
class DealerAdmin extends AdminMnv
{
    /**
     * Вывод всего контента
     */
    public function fetch()
    {

        $block = new Dealers($this->request);

        $image    = $this->request->get('image', '');
        $imageId  = (int) $this->request->get('imageId', '');

        /** title */
        $this->smarty->assign('title', 'Дилеры');
        /** activeItem */
        $this->smarty->assign('activeItem', 'dealers');
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        $this->smarty->assign('cities', GeoCities::getSelectCities());

        if ($this->action == 'add' || $this->action == 'edit') {
            $block->edit()->getFiles()->gettingInfoAboutUsers();
        }

        else if ($this->action == 'save' || $this->action == 'apply') {
            /** проверка полей */
            if (empty($block->data['title'])) $this->errors['title'] = true;
            if (empty($block->data['cityId'])) $this->errors['cityId'] = true;
            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($block->prepare($block->data, $this->manager['userId'])) {

                    if (!empty($images['general'])) $block->addFiles($block->id, $images);
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $block->edit()->getFiles()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("dealers", ['page' => $this->page]));
            }
        }

        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {
            $result = $block->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


//        print_r($block->data);
        $this->smarty->assign('dealer', $block->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions($this->module .'s')) {
            try {
                return $this->smarty->fetch('views/contents/'.$this->module.'.tpl');
            } catch (\SmartyException | \Exception $e) {
                print $e->getMessage();
            }
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}