<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\GeoCities;
use Mnv\Models\GeoRegions;

/**
 * Class GeoCityAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoCityAdmin extends AdminMnv
{
    public function fetch()
    {

        $country = new GeoCities($this->request);

        $this->smarty->assign('activeItem', 'cities');
        $this->smarty->assign('title', 'Город');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('regions', GeoRegions::getSelectRegions());

        if ($this->action == 'add' || $this->action == 'edit') {

            $country->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($country->data['name'])) $this->errors['name'] = true;
//            if (empty($country->data['region_id'])) $this->errors['region_id'] = true;

            if (empty($this->errors)) {
                if ($country->prepare($country->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $country->edit()->gettingInfoAboutUsers();
            /** сохранение данных */
            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString("cities", ['page' => $this->page]));

            }
        }

        $this->smarty->assign('city', $country->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('cities')) {
            return $this->smarty->fetch('views/geo/geo.city.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


