<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Countries;
use Mnv\Models\GeoCountries;

/**
 * Class GeoCountryAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoCountryAdmin extends AdminMnv
{
    public function fetch()
    {

        $country = new GeoCountries($this->request);

        $this->smarty->assign('activeItem', 'countries');
        $this->smarty->assign('title', 'Города');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        if ($this->action == 'add' || $this->action == 'edit') {

            $country->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($country->data['name'])) $this->errors['name'] = true;

            if (empty($this->errors)) {
                if ($country->prepare($country->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $country->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString("countries", ['page' => $this->page]));
            }
        }

        $this->smarty->assign('country', $country->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('countries')) {
            return $this->smarty->fetch('views/geo/geo.country.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


