<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\GeoRegions;

/**
 * Class GeoRegionAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoRegionAdmin extends AdminMnv
{
    public function fetch()
    {

        $country = new GeoRegions($this->request);

        $this->smarty->assign('activeItem', 'regions');
        $this->smarty->assign('title', 'Регионы');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        if ($this->action == 'add' || $this->action == 'edit') {

            $country->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($country->data['name'])) $this->errors['name'] = true;

            if (empty($this->errors)) {
                if ($country->prepare($country->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $country->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString("regions", ['page' => $this->page]));
            }
        }

        $this->smarty->assign('region', $country->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('regions')) {
            return $this->smarty->fetch('views/geo/geo.region.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


