<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\GeoRegions;

/**
 * Class GeoRegionsAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoRegionsAdmin extends AdminMnv
{

    public function fetch()
    {

        $region = new GeoRegions($this->request);

        $this->smarty->assign('activeItem','regions');
        $this->smarty->assign('title', 'Регионы');

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $region->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Город удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $region->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action === 'status') {

            try {
                $region->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $region->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $region->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировать при перемещение */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $region->data = [];
            foreach ($region->ids as $id) {
                $i++;
                $region->id = $id;
                $region->data['orderBy'] = $i;
                $region->update($region->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $regions = collect($region->all($this->limit, $this->page))->map(function ($item) {
//            $item['statusName']  = lang('general:statuses:' . $item['status']);

            return $item;
        })->all();

        /** pagination */
        $region->total();
        $pages = getPageNums($region->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('regions', $regions);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        /** Права доступа к данному шаблону */
        if ($this->permissions('regions')) {
            return $this->smarty->fetch('views/geo/geo.regions.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}



