<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\User;
use Mnv\Models\UserGroups;

/**
 * Class ManagersAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagersAdmin extends AdminMnv
{

    public function fetch()
    {
        $adminUser = new User($this->request);

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem', 'managers');
        $this->smarty->assign('title', lang('managers:title'));

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $adminUser->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Пользователь удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $adminUser->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $adminUser->filter = array_filter([
            'status'        => $this->filter['status'] ?? '',
            'query'         => $this->query,
            'userType'      => UserGroups::ADMIN,
        ]);

        /** получение всех менеджеров с картинками */
        $users = $adminUser->all($this->limit, $this->page);
        $users = collect($users)->map(function ($item) {
            $item['statusName'] = lang('managers:statuses:' . $item['status']);
            $item['groupName'] = UserGroups::groupName($item['groupId']);
            $item['registered'] = langDate(adjustTime(gmdate('Y-m-d H:i', $item['registered']), false, 'Y-m-d H:i'));
            $item['last_login'] = langDate(adjustTime(gmdate('Y-m-d H:i', $item['last_login']), false, 'Y-m-d H:i'));

            return $item;
        })->all();


        /** получение кол-во менеджеров */
        $adminUser->total();
        $pages = getPageNums($adminUser->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('managers', $users);
        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('managers')) {
            return $this->smarty->fetch('views/users/managers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}









