<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Payments;

/**
 * Class PaymentAdmin
 * @package Mnv\Admin\Controllers
 */
class PaymentAdmin extends AdminMnv
{

    public function fetch()
    {

        $payment = new Payments($this->request);
        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));


        if ($this->action == 'edit' || $this->action == 'add') {

            $payment->edit()->gettingInfoAboutUsers();
            if (isset($payment->data['settings']) && !empty($payment->data['settings'])) {
                $payment->data['settings'] = json_decode($payment->data['settings'], true);
            }

        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {
            /* проверка полей */
            if (empty($payment->data['name'])) $this->errors['name'] = true;
            if (empty($payment->data['fileName'])) $this->errors['name'] = true;

            if ($fileName = $payment->checkFileName($payment->data['fileName'])) {
                if ($fileName == $payment->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $payment->data['fileName'] = $fileName;
                }
            }

            if (isset($payment->data['settings']) && !empty($payment->data['settings'])) {
                $payment->data['settings'] = json_encode($payment->data['settings'], JSON_THROW_ON_ERROR);
            }

            if (empty($this->errors)) {
                if ($payment->prepare($payment->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $payment->edit()->gettingInfoAboutUsers();
            if (isset($payment->data['settings']) && !empty($payment->data['settings'])) {
                $payment->data['settings'] = json_decode($payment->data['settings'], true);
            }

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("payments", ['page' => $this->page]));
            }
        }

        $payment_modules = $payment->getPaymentModules();
        $this->smarty->assign('payment_modules', $payment_modules);

        $this->smarty->assign('payment', $payment->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('payments')) {
            return $this->smarty->fetch('views/payments/payment.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }



}