<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Payments;

/**
 * Class PaymentsAdmin
 * @package Mnv\Admin\Controllers
 */
class PaymentsAdmin extends AdminMnv
{

    public function fetch()
    {

        $payment = new Payments($this->request);

        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $payment->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Пользователь удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $payment->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action == 'status') {
            try {
                $payment->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $payment->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $payment->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $payment->data = [];
            foreach ($payment->paymentIds as $paymentId) {
                $i++;
                $payment->id = $paymentId;
                $payment->data['orderBy'] = $i;
                $payment->update($payment->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }

        $payments = collect($payment->all($this->limit, $this->page))->map(function ($item) {
            $item['statusName']  = lang('general:statuses:' . $item['status']);

            return $item;
        })->all();

        $payment->total();
        $pageNums = getPageNums($payment->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalPayments', $payment->total);
        $this->smarty->assign('payments', $payments);
        $this->smarty->assign('pageNums', $pageNums);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('payments')) {
            return $this->smarty->fetch('views/payments/payments.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}