<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Stats;

/**
 * Class StatsBotAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsBotAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector = new StatsDateSelector(false, 'botDateSelector');
        $typeSelector = new StatsTypeSelector();
        $this->smarty->assign('filterTypeOptions', $typeSelector->get());
        $this->smarty->assign('filterTypeId', $typeSelector->filterTypeId);

        $sortVisits = false;

        $this->smarty->assign('activeItem','bots');
        $this->smarty->assign('title', lang('stats:botsTitle'));

        $visitorId  = $this->request->get('visitorId');


        /** получить информацию о посетителе */
        $visitor = $stats->getStatsVisitor($visitorId);
        if (empty($visitor))
            die('Visitor Not Found');

        $visitor['firstVisitOn'] = adjustTime($visitor['firstVisitOn']);

        if (!$visitor['isBot']) {
            header("HTTP/1.0 301 Moved Permanently");
            header("Location: " . $this->adminUrl . "/visitor?visitorId=$visitorId".(!empty($typeSelector->filterTypeId) ? "&filterTypeId=$typeSelector->filterTypeId" : ''));
            exit;
        }

        $visits = $stats->getStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId, $this->limit, $this->page);
        if (!empty($visits)) {
            foreach ($visits as $visitId => $visit) {
                $visits[$visitId]['typeName'] = lang('visitTypes:' . $visit['typeId']);
                $visits[$visitId]['visitDate'] = langDate(adjustTime($visit['visitDate'], false, 'd.m.Y H:i'));
                $visitTypes[$visit['typeId']] = $visit['typeId'];

            }

            /** section visits */
            if(!empty($visitTypes[2])) $visits =  $stats->sectionVisits($visits);
            /** article visits */
            if (!empty($visitTypes[3])) $visits = $stats->articleVisits($visits);
            /** search visits */
            if (!empty($visitTypes[4])) $visits = $stats->searchVisits($visits);
            /** error visits */
            if (!empty($visitTypes[6])) $visits = $stats->errorVisits($visits);
            /** RSS visits */
            if (!empty($visitTypes[7])) $visits = $stats->rssVisits($visits);
        }

        /** page numbering */
        $totalItems  = $stats->getTotalStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 1, 1, 2);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);
        $this->smarty->assign('page', $this->page);

        /** получить больше информации о посетителе */
        if(!empty($visitor['visitId'])) $visitor['firstVisit'] = $stats->getVisitInfo($visits, $visitor['visitId']);
        $this->smarty->assign('visitor', $visitor);

        /** сортировка посещений, потому что добавлены скрытые посещения */
        if ($sortVisits) {
            usort($visits, array($stats, 'sortByVisitDate'));
        }
        $this->smarty->assign('visits', $visits);
        $this->smarty->assign('visitorId', $visitorId);

        if ($this->permissions('bots')) {
            return $this->smarty->fetch('views/stats/bot.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}
