<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\AdminMnv;
use Mnv\Core\Table\TableFactory;

use DateTime;
use Mnv\Core\YaMetrika\Services\ReportService;
use Mnv\Core\YaMetrika\Transformers\ReportDataTransformer;

/**
 * Class StatsYandexAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsYandexAdmin extends AdminMnv
{

    public function fetch()
    {
        $configUrlFile = GLOBAL_ROOT . '/includes/yandex.config.json';
        $jsonFile = new TableFactory('JSON');
        $jsonFile->parser->loadFile($configUrlFile);

        $this->smarty->assign('activeItem', 'yandex');
        $this->smarty->assign('title', 'Яндекс метрика');

        $view   = $this->request->get('view', '');

        /** сохранение данных */
        if ($this->action == 'save') {
            $counterId = $this->request->get('counterId');
            $token = $this->request->get('token');
            $days = $this->request->get('days');
            $code = $this->request->get('code');

            $jsonFile->writer->deleteRow(0);
            $jsonFile->writer->addRow([
                'counterId' => $counterId,
                'token' => $token,
                'days' => $days,
                'code' => $code
            ], false);

            $jsonFile->writer->saveFile('yandex', $configUrlFile);
//

            $response = array('status' => 200, 'message' => 'Настройки сохранены', 'counterId' => $counterId, 'token' =>$token, 'days' => $days, 'code' => $code, 'type' => 'success');

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        } else {

            try {
                $getFile = $jsonFile->parser->getField();
                $params = collect($getFile)->first();

                if (!empty($params['token']) && !empty($params['counterId'])) {
                    $days = $params['days'];

                    $statistics = new ReportService([
                        'token' => $params['token'], //  'y0_AgAEA7qhcbEEAAkGuQAAAADaNHZT6j0iANpcSomMh-F7O70EtUA9NE4';
                        'counterId' => $params['counterId'], //'90824259';
                        'resultTransformer' => new ReportDataTransformer(),
                    ]);

                    // Самые просматриваемые страницы
                    if ($view == 'viewed') {
                        $pages = $statistics->getMostViewedPages($days, 100);
                        $this->smarty->assign('pages', $pages);
                    }
                    // Пользователи по странам и регионам
                    elseif ($view == 'geo') {
                        $periods = $statistics->getGeo($days, 100);
                        $this->smarty->assign('periods', $periods);
                    }
                    // Поисковые фразы
                    elseif ($view == 'phrases') {
                        $phrases = $statistics->getSearchPhrases($days, 100);
                        $this->smarty->assign('phrases', $phrases);
                    }
                    // Пользователи из поисковых систем
                    elseif ($view == 'search') {
                        $usersSearchEngine = $statistics->getUsersSearchEngine($days, 100);
                        $this->smarty->assign('usersSearchEngine', $usersSearchEngine);
                    }
                    //Браузеры пользователей
                    elseif ($view == 'browsers') {
                        $browsers = $statistics->getBrowsers($days, 100);
                        $this->smarty->assign('browsers', $browsers);
                    }
                    // Пол и возраст пользователей
                    elseif ($view == 'ages') {
                        $ages = $statistics->getAgeGender($days, 100);
                        $this->smarty->assign('ages', $ages);
                    }
                    // Данные по посещаемости
                    else {
                        $attendance = $statistics->getVisitors($days);
                        if (!empty($attendance['data'])) {
                            $attendance['data'] = collect($attendance['data'])->reverse()->values()->groupBy(function ($entry) {
                                return substr($entry['dimensions']['date']['name'], 0, 7);
                            })->all();
                        }
                        $this->smarty->assign('attendance', $attendance);
                    }

                    $this->smarty->assign('days', $days);
                    $this->smarty->assign('yandex', $params);

                } else {
                    $this->messages['token_counter'] = true;
                }
            }
            catch (\Exception $e) {
                $this->smarty->assign('message', $e->getMessage());
            }
        }

        $this->smarty->assign('view', $view);
        $this->smarty->assign('message', $this->messages);

        if ($this->permissions('yandex')) {
            return $this->smarty->fetch('views/stats/yandex.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}

