<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Validations\Exceptions\InvalidEmailException;
use Mnv\Core\Validations\ValidateEmail;
use Mnv\Models\User;
use Mnv\Models\UserGroups;

/**
 * Class UserAdmin
 * @package Mnv\Admin\Controllers
 */
class UserAdmin extends AdminMnv
{

    public function fetch()
    {
        $siteUser = new User($this->request);

        /* Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','users');
        $this->smarty->assign('title', lang('users:title'));

        $this->smarty->assign('subscribes', lang('users:subscribes'));
        $this->smarty->assign('genders', lang('users:genders'));
        /** statuses */
        $this->smarty->assign('statuses', lang('users:statuses'));
        $this->smarty->assign('subscribes', array_slice(lang('users:subscribes'), 0));

        /** Получаемые параметры $_GET / $_POST */

        $image     = $this->request->get('image', '');
        $imageId   = (int) $this->request->get('imageId', '');


        if ($this->action == 'add' || $this->action == 'edit') {
            $siteUser->edit();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            $siteUser->data['userType'] = UserGroups::CUSTOMER;
            $siteUser->data['verified'] = ($siteUser->data['status'] == 3) ? 0 : 1;
//            if (empty($siteUser->data['loginName'])) $this->errors['login'] = true;
//            if (!empty($siteUser->data['loginName']) && @!preg_match('^[0-9A-Za-z_]+$^', $siteUser->data['loginName'])) $this->errors['login_correct'] = true;

//            if ($loginName = $siteUser->checkLogin($siteUser->data['loginName'])) {
//                if ($loginName == $siteUser->data['loginName']) {
//                    $this->errors['loginName'] = true;
//                } else {
//                    $siteUser->data['loginName'] = $loginName;
//                }
//            }

//                if (empty($users->user['fullName'])) $this->errors['firstName'] = true;
            if (empty($siteUser->data['firstName'])) $this->errors['firstName'] = true;
            if (empty($siteUser->data['lastName'])) $this->errors['lastName'] = true;

//            if (empty($siteUser->data['phone'])) $this->errors['phone'] = true;
            // if (!empty($siteUser->data['phone']) && @!preg_match('/^[0-9]{7,15}+$/', $siteUser->data['phone'])) $this->errors['phone_correct'] = true;

//            if (!empty($siteUser->data['phone']) && (
//                preg_match( '/\d?(\s?|-?|\+?|\.?)((\(\d{1,4}\))|(\d{1,3})|\s?)(\s?|-?|\.?)((\(\d{1,3}\))|(\d{1,3})|\s?)(\s?|-?|\.?)((\(\d{1,3}\))|(\d{1,3})|\s?)(\s?|-?|\.?)\d{3}(-|\.|\s)\d{4}/', $siteUser->data['phone'] )
//                || preg_match('/([0-9]{8,13})/', str_replace(' ', '', $siteUser->data->phone))
//                || ( preg_match('/^\+?\d+$/', $siteUser->data['phone']) && strlen($siteUser->data['phone']) >= 8 && strlen($siteUser->data['phone']) <= 13 ) )) $this->errors['phone_correct'] = true;
//

            if (empty($siteUser->data['email'])) $this->errors['email1'] = true;
            try {
                ValidateEmail::fromString($siteUser->data['email']);
                if ($email = $siteUser->checkEmailUser($siteUser->data['email'])) {
                    if ($email == $siteUser->data['email']) {
                        $this->errors['email2'] = true;
                    } else {
                        $siteUser->data['email'] = $email;
                    }
                }

            } catch (InvalidEmailException $e) {
                $this->errors['email_correct'] = true;
            }


            if (empty($siteUser->id) && empty($siteUser->data['password'])) $this->errors['password'] = true;

            if (!empty($image['fileId'])) $images['fileId'] = $image['fileId'];

            if (empty($this->errors)) {
                if ($siteUser->prepare($siteUser->data, $this->manager['userId'])) {
                    if (!empty($images['fileId'])) $siteUser->addFiles($siteUser->id, $images);

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $siteUser->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("users", ['page' => $this->page]));
            }
        }
        /** удаление основной картинки */
        elseif ($this->action == 'deleteFile') {
            $result = $siteUser->removeUserImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $this->smarty->assign('user', $siteUser->data);

        /* Вывод сообщений или ошибок */
        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('users')) {
            return $this->smarty->fetch('views/users/user.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}




