(function () {
    ((localStorage.getItem('theme') == 'auto' && window.matchMedia('(prefers-color-scheme: dark)').matches) || localStorage.getItem('theme') == 'dark')
    && document.documentElement.setAttribute('data-color-theme', 'dark');
})();

const themeSwitcher = function() {

    const layoutTheme = function() {
        let primaryTheme = 'light';
        let secondaryTheme = 'dark';
        let storageKey = 'theme';
        let colorscheme = document.getElementsByName('main-theme');
        let mql = window.matchMedia('(prefers-color-scheme: ' + primaryTheme + ')');


        function indicateTheme(mode) {
            for (let i = colorscheme.length; i--; ) {
                if(colorscheme[i].value == mode) {
                    colorscheme[i].checked = true;
                    colorscheme[i].closest('.theme-group-item').classList.add('btn-outline-teal');
                    colorscheme[i].closest('.theme-group-item').classList.remove('btn-teal');
                } else {
                    colorscheme[i].closest('.theme-group-item').classList.add('btn-teal');
                    colorscheme[i].closest('.theme-group-item').classList.remove('btn-outline-teal');
                }
            }
        };

        // Turns alt stylesheet on/off
        function applyTheme(mode) {
            let st = document.documentElement;
            if (mode == primaryTheme) {
                st.removeAttribute('data-color-theme');
            } else if (mode == secondaryTheme) {
                st.setAttribute('data-color-theme', 'dark');
            } else {
                if (!mql.matches) {
                    st.setAttribute('data-color-theme', 'dark');
                } else {
                    st.removeAttribute('data-color-theme');
                }
            }
        }

        // Handles radiobutton clicks
        function setTheme(e) {
            let mode = e.target.value;
            document.documentElement.classList.add('no-transitions');
            if ((mode == primaryTheme)) {
                localStorage.removeItem(storageKey);
            } else {
                localStorage.setItem(storageKey, mode);
            }
            // When the auto button was clicked the auto-switcher needs to kick in
            autoTheme(mql);
        }

        // Handles the media query evaluation, so it expects a media query as parameter
        function autoTheme(e) {
            let current = localStorage.getItem(storageKey);
            let mode = primaryTheme;
            let indicate = primaryTheme;
            // User set preference has priority
            if ( current != null) {
                indicate = mode = current;
            } else if (e != null && e.matches) {
                mode = primaryTheme;
            }
            applyTheme(mode);
            indicateTheme(indicate);
            setTimeout(function() {
                document.documentElement.classList.remove('no-transitions');
            }, 100);
        }

        // Create an event listener for media query matches and run it immediately
        autoTheme(mql);
        mql.addListener(autoTheme);

        // Set up listeners for radio button clicks */
        for(let i = colorscheme.length; i--; ) {
            colorscheme[i].onchange = setTheme;
        }
    };

    const sidebarControl = () => {

        const sidebarMainElement = document.querySelector('.sidebar-main'),
            sidebarMainToggle = document.querySelectorAll('.sidebar-main-resize'),
            resizeClass = 'sidebar-main-resized',
            unfoldClass = 'sidebar-main-unfold';


        // Config
        if (sidebarMainElement) {

            // Define variables
            const unfoldDelay = 150;
            let timerStart, timerFinish;

            // Toggle classes on click
            sidebarMainToggle.forEach(function(element) {
                element.addEventListener('click', function(e) {
                    e.preventDefault();

                    let miniSidebar = document.cookie.split('; ').find(row => row.startsWith('sidebar='));
                    if (!miniSidebar) {
                        document.cookie = 'sidebar=true; expires=' + new Date(new Date().getTime() + 24 * 60 * 60 * 1000).toUTCString() + '; path=/';
                    } else {
                        document.cookie = 'sidebar=false; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/';
                    }

                    sidebarMainElement.classList.toggle(resizeClass);
                    !sidebarMainElement.classList.contains(resizeClass) && sidebarMainElement.classList.remove(unfoldClass);
                });
            });

            // Add class on mouse enter
            sidebarMainElement.addEventListener('mouseenter', function() {
                clearTimeout(timerFinish);
                timerStart = setTimeout(function() {
                    sidebarMainElement.classList.contains(resizeClass) && sidebarMainElement.classList.add(unfoldClass);
                }, unfoldDelay);
            });

            // Remove class on mouse leave
            sidebarMainElement.addEventListener('mouseleave', function() {
                clearTimeout(timerStart);
                timerFinish = setTimeout(function() {
                    sidebarMainElement.classList.remove(unfoldClass);
                }, unfoldDelay);
            });
        }

    }

    return {
        init: function() {
            layoutTheme();
            sidebarControl();
        }
    }
}();

document.addEventListener('DOMContentLoaded', function() {
    themeSwitcher.init();
});
