/* Call an ajax entity update */
const currentUrl = document.documentElement.getAttribute("data-url");
document.addEventListener('click', async function (e) {
    // изменение статуса
    if (e.target && e.target.closest('.ajax_action')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                target.closest("tr").classList.toggle('table-warning');
                target.innerHTML = result.data === 'V'
                    ? '<i class="ph-eye me-2"></i> ' + lang['status']
                    : '<i class="ph-eye-slash me-2"></i> ' + lang['status'];
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }

    // одобрение без модерации
    if (e.target && e.target.closest('.ajax_approve')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                if (module === 'users') {
                    target.remove();
                    const statusIndicator = document.querySelector(`#status_indicator_${id}`);
                    if (statusIndicator) {
                        statusIndicator.classList.replace('bg-danger', 'bg-success');
                    }
                } else {
                    target.classList.remove('ajax_approve', 'text-danger');
                    target.classList.add('ajax_action');
                    target.closest("tr").classList.remove('table-danger');
                    target.innerHTML = '<i class="ph-eye me-2"></i> ' + lang['status'];
                    target.setAttribute("data-action", "status");
                }
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }

    // добавление в избранное
    if (e.target && e.target.closest('.ajax_favorites')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                const isSuccess = result.data === 1;
                target.closest("tr").classList.toggle('table-success', isSuccess);
                target.classList.toggle('text-success', isSuccess);
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }
});


// function auto_keywords() {
//     const adminUrl = document.querySelector('html').getAttribute("data-url")
//     tinyMCE.triggerSave();
//     let txt = document.getElementsByClassName('description')[0].value;
//     $.post(adminUrl + "/handlers/keywords.php", { content: txt }, function(data) {
//         console.log(data.keywords);
//         $('#keywords').tokenfield('setTokens', data.keywords);
//     });
//     return false;
// }


// TODO не забыть заметь imageId на id во все пуктах добавление контента

// добавление информации к картинке в галереи
function editPictureInfo(imageId, confirm, module) {
    let $this = $('#edit_image_' + imageId);
    let title = $this.attr('data-title'),
        alias = $this.attr('data-alias'),
        description = $this.attr('data-description'),
        link = $this.attr('data-link'),
        position = $this.attr('data-position');

    bootbox.prompt({
        title: confirm,
        message: '<div class="form-group mb-3">' +
            '   <label class="form-group-float-label is-visible">Заголовок</label>' +
            '   <input type="text" class="form-control" id="image_title" value="' + title + '" />' +
            '</div>' +
            '<div class="form-group mb-3">' +
            '   <label class="form-group-float-label is-visible">Альтернативный заголовок</label>' +
            '   <input type="text" class="form-control" id="image_alias" value="' + alias + '" />' +
            '</div>' +
            '<div class="form-group mb-3">' +
            '   <label class="form-group-float-label is-visible">Описание</label>' +
            '   <textarea rows="3" cols="3" class="form-control" placeholder="" id="image_description">' + description + '</textarea>' +
            '</div>' +
            '<div class="form-group mb-3">' +
            '   <label class="form-group-float-label is-visible">Ссылка</label>' +
            '   <input type="text" class="form-control" id="image_link" value="' + link + '" />' +
            '</div>',
        inputType: 'select',
        value: position,
        inputOptions: [
            {text: 'По умолчанию', value: 'default'},
            {text: 'Банер', value: 'banner'},
            {text: 'Галерея', value: 'gallery'},
            {text: 'Карусель', value: 'carousel'},
            {text: 'Коллекция', value: 'collection'},
            {text: 'Блок', value: 'block'},
            {text: 'Логотип', value: 'logo'},
        ],
        buttons: {
            cancel: {label: 'Отмена', className: 'btn-sm btn-light'},
            confirm: {label: 'Сохранить', className: 'btn-sm  btn-primary'}
        },
        callback: function (result) {
            var link = $('#image_link').val(), title = $('#image_title').val(), alias = $('#image_alias').val(),
                description = $('#image_description').val();
            console.log(result);
            if (result !== null) {
                $.post('index.php?mod=' + module + '&action=editPictureInfo', {
                    imageId: imageId,
                    'picture[title]': title,
                    'picture[alias]': alias,
                    'picture[description]': description,
                    'picture[link]': link,
                    'picture[position]': result
                }, function (response) {
                    console.log(response);
                    if (response.status === 200) {
                        $('#edit_image_' + imageId).attr('data-title', response.title).attr('data-alias', response.alias).attr('data-description', response.description).attr('data-link', response.link).attr('data-position', response.position);
                        $('#meta_image_' + imageId + ' #im_title').text(response.title);
                        $('#meta_image_' + imageId + ' #im_alias').text(response.alias);
                        $('#meta_image_' + imageId + ' #im_description').text(response.description);
                        $('#meta_image_' + imageId + ' #im_link').text(response.link);
                        $('#meta_image_' + imageId + ' #im_position').text(response.position);
                    }
                }, 'json');
            }
        }
    });
}


function confirmLanguageChange(sbmButton) {
    // bootbox.confirm({
    //     message: lang['sureToChangeLang'] + ' "'+sbmButton.form.defaultLang.options[sbmButton.form.defaultLang.selectedIndex].label+'"?',
    //     callback: function(result) {
    //         console.log(result);
    //         if (result === true) {
    //             sbmButton.form.submit();
    //         }
    //     }
    // });

    if (window.confirm(lang['sureToChangeLang'] + ' "' + sbmButton.form.defaultLang.options[sbmButton.form.defaultLang.selectedIndex].label + '"?') == false) return false;
    sbmButton.form.submit();
}

function languageOptionChange(thisSelect) {
    document.getElementById('codename').value = thisSelect.value;
    document.getElementById('languageName').value = thisSelect.options[thisSelect.selectedIndex].text
    if (typeof lang2charset != 'undefined') {
        if (lang2charset[thisSelect.value]) {
            var charsetOptions = document.getElementById('charsetOptions').options;
            for (i = 0; i < charsetOptions.length; i++) {
                if (charsetOptions[i].value == lang2charset[thisSelect.value]) {
                    charsetOptions[i].selected = true;
                    break;
                }
            }

            // var adminLanguageOptions = document.getElementById('adminLanguageOptions').options;
            // for (i = 0; i < adminLanguageOptions.length; i++) {
            //     if (adminLanguageOptions[i].value == thisSelect.value) {
            //         adminLanguageOptions[i].selected = true;
            //         break;
            //     }
            // }
        }
    }
}

function deleteStats() {

    if (!ajaxIsFree())
        return false;

    var settingsForm = document.getElementById('settings');
    var date = settingsForm['date'].value;

    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDeleteStats'] + ' ' + date + '?',
        callback: function (result) {
            console.log(result);
            if (result === true) {
                postData("index.php?mod=settings&action=delete_stats&date=" + date);
                deleteStatsMessage();
            }
        }
    });

    return false;
}

function clearCache() {
    if (!ajaxIsFree()) return false;
    postData("index.php?mod=settings&action=clear_cache");
    clearCacheMessage();

    return false;
}


// рабочее удаление id, заголовок, ссылка
function remove(id, title, module) {
    if (!ajaxIsFree()) return false;
    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDelete'] + ' "' + title + '"?',
        callback: function (result) {
            if (result === true) {
                $.post('index.php?mod=' + module + "&action=remove", {id: id}, function (response) {
                    if (response.status === 200) {
                        removeElement(id, module.slice(0, -1));
                    }
                    new Noty({text: response.message, type: response.type}).show();
                }, 'json');

            }
        }
    });
    return false;
}

function deleteColorNew(id, module, type, row)
{
    let element = document.getElementById(type + "-" + row);
    $.post('index.php?mod='+module+"&action=deleteColors", { imageId: id }, function(response) {
        if (response.status === 200) element.parentNode.removeChild(element);
        new Noty({ text: response.message, type: response.type }).show();
    }, 'json');
}

// remove preview - если предпоказ
function removePreviewImage() {

    // удалить кноку удаления
    const buttonRemove = document.getElementById('content-image-preview-remove');
    buttonRemove.parentNode.removeChild(buttonRemove);

    // удаляем картинку
    const preview = document.getElementById('content-image-preview');
    if (preview.hasChildNodes()) {
        preview.removeChild(preview.children[0]);
    }
    document.getElementById('content-image-preview-add').innerHTML = '<i class="ph-image me-2"></i>Загрузить файл';

    return false;

}

// удаление картинки из галереи - если предпоказ
function removePicture(imageId) {
    const item = document.getElementById('item-' + imageId);
    if (!item) {
        showNotification('Item not found.', 'error');
        return;
    }
    item.parentNode.removeChild(item);
    return false;
}


async function removeFile(imageId, module) {
    // Show loading indicator (optional)
    //showLoadingIndicator(); // Uncomment if implementing loading indicator

    const formData = new FormData();
    formData.append('imageId', imageId);

    try {
        const response = await fetch(`index.php?mod=${module}&action=deleteFile`, {
            method: 'POST',
            body: formData
        });

        if (!response.ok) {
            throw new Error('Network response was not ok');
        }

        const {status, message, type} = await response.json();

        if (status === 200) {
            removePicture(imageId)
        }

        showNotification(message, type);

    } catch (error) {
        console.error('Error:', error);
        showNotification(`An error occurred while deleting the image: ${error.message}`, 'error');
    } finally {
        // Hide loading indicator (optional)
        ///hideLoadingIndicator(); // Uncomment if implementing loading indicator
    }
}

// Function to show notifications
function showNotification(message, type) {
    new Noty({text: message, type: type}).show();
}

// // Function to show a loading indicator (optional)
// function showLoadingIndicator() {
//     // Implement loading indicator logic here (e.g., show a spinner)
// }
//
// // Function to hide a loading indicator (optional)
// function hideLoadingIndicator() {
//     // Implement loading indicator hiding logic here
// }

function deleteImage(imageId, module) {
    if (!ajaxIsFree()) return false;
    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDeleteImage'] + '?',
        callback: function (result) {
            if (result === true) {
                $.post('index.php?mod=' + module + "&action=deleteFile", {imageId: imageId,}, function (response) {
                    if (response.status === 200) {
                        removePreviewImage()
                    }
                    new Noty({text: response.message, type: response.type}).show();
                }, 'json');
            }
        }
    });
    return false;
}

function deleteFile(path, file, module) {
    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDelete'] + ' "' + file + '"?',
        callback: function (res) {
            if (res === true) {
                document.location = 'index.php?mod=' + module + '&path=' + path + '&action=remove&file[name]=' + file;
            }
        }
    });
    return false;
}


// сортировка таблицы
function tableSort(element, module) {
    if (!ajaxIsFree()) return false;

    let sortBy = element.getAttribute('data-sort-by')
    let sortOrder = element.getAttribute('data-sort-order')

    $.post('index.php?mod=' + module + "&action=sort_table", {
        sortBy: sortBy,
        sortOrder: sortOrder
    }, function (response) {
        console.log(response)
        window.location.reload();
    }, 'json');
}

// очистка сортировка таблицы
function clearTableSort(element, module) {

    if (!ajaxIsFree()) return false;

    $.post('index.php?mod=' + module + "&action=clear_sort_table", function (response) {
        console.log(response)
        window.location.reload();
    }, 'json');
}

function removeElement(elementId, elementPrefix) {
    let node = document.getElementById(elementPrefix + '-' + elementId);
    node.parentNode.removeChild(node);
}

function proposeFileName(srcName, destName, formName, separator, convertToLowerCase) {
    let form = document.getElementById(formName);
    if (form[destName].value == '') {
        let re = new RegExp('(^\\' + separator + '|\\' + separator + '$)', 'gi');
        form[destName].value = form[srcName].value.replace(/[^0-9a-zA-Z\-_\.]+/gi, separator).replace(re, '');
        if (convertToLowerCase == '1') form[destName].value = form[destName].value.toLowerCase();
    }
}

function ajaxIsFree() {
    if (typeof waitingResponse != 'undefined' && waitingResponse == true) {
        bootbox.alert(lang['processingRequest']);
        return false;
    }
    return true;
}

function handleHttpResponse() {
    if (XMLHttp.readyState === 4) {
        if (XMLHttp.status === 200) {
            try {
                eval(XMLHttp.responseText);
            } catch (e) {
                if (typeof httpResponseEvalOnError != 'undefined' && httpResponseEvalOnError != '') {
                    httpResponseText = XMLHttp.responseText;
                    eval(httpResponseEvalOnError);
                } else {
                    bootbox.alert(lang['operationError'] + ": " + XMLHttp.responseText);
                    document.location = document.location.pathname;
                }
            }
            waitingResponse = false;
        } else {
            bootbox.alert(lang['operationError'] + ": " + XMLHttp.responseText);
            document.location = document.location.pathname;
        }
    }
}

function postData(destination, data) {
    if (window.XMLHttpRequest) {
        XMLHttp = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
        XMLHttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    method = 'POST';
    if (typeof data == 'undefined') method = 'GET';
    XMLHttp.open(method, destination, true);
    if (method === 'POST') XMLHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
    XMLHttp.onreadystatechange = handleHttpResponse;
    XMLHttp.send(data);
    waitingResponse = true;
}

// Autocomplete */
(function ($) {
    $.fn.autocomplete = function (option) {
        return this.each(function () {
            var $this = $(this);
            var $dropdown = $('<ul class="dropdown-menu" />');

            this.timer = null;
            this.items = [];

            $.extend(this, option);

            $this.attr('autocomplete', 'off');
            // Focus
            $this.on('focus', function () {
                this.request();
            });
            // Blur
            $this.on('blur', function () {
                setTimeout(function (object) {
                    object.hide();
                }, 200, this);
            });
            // Keydown
            $this.on('keydown', function (event) {
                switch (event.keyCode) {
                    case 27: // escape
                        this.hide();
                        break;
                    default:
                        this.request();
                        break;
                }
            });

            // Click
            this.click = function (event) {
                event.preventDefault();

                var value = $(event.target).parent().attr('data-value');
                if (value && this.items[value]) {
                    this.select(this.items[value]);
                }
            }

            // Show
            this.show = function () {
                var pos = $this.position();
                $dropdown.css({
                    top: pos.top + $this.outerHeight(),
                    left: pos.left
                });
                $dropdown.show();
            }

            // Hide
            this.hide = function () {
                $dropdown.hide();
            }

            // Request
            this.request = function () {
                clearTimeout(this.timer);

                this.timer = setTimeout(function (object) {
                    object.source($(object).val(), $.proxy(object.response, object));
                }, 200, this);
            }

            // Response
            this.response = function (json) {

                console.log(json);

                var html = '';
                var category = {};
                var name;
                var i = 0, j = 0;

                if (json.length) {
                    for (i = 0; i < json.length; i++) {
                        // update element items
                        this.items[json[i]['value']] = json[i];

                        if (!json[i]['category']) {
                            // ungrouped items
                            html += '<li data-value="' + json[i]['value'] + '"><a class="dropdown-item" href="#">' + json[i]['label'] + '</a></li>';
                        } else {
                            // grouped items
                            name = json[i]['category'];
                            if (!category[name]) {
                                category[name] = [];
                            }

                            category[name].push(json[i]);
                        }
                    }

                    for (name in category) {
                        html += '<li class="dropdown-header">' + name + '</li>';

                        for (j = 0; j < category[name].length; j++) {
                            if (category[name][j]['image'] == undefined || category[name][j]['image'] == null) {
                                html += '<li data-value="' + category[name][j]['value'] + '"><a class="dropdown-item" href="#">&nbsp;&nbsp;&nbsp;' + category[name][j]['label'] + '</a></li>';
                            } else {
                                html += '<li data-value="' + category[name][j]['value'] + '"><a class="dropdown-item" href="#"><span class="input-group-text"><img src="' + category[name][j]['image'] + '" width="30"/></span>' + category[name][j]['label'] + '</a></li>';
                            }
                        }
                    }
                }

                if (html) {
                    this.show();
                } else {
                    this.hide();
                }

                $dropdown.html(html);
            }

            $dropdown.on('click', '> li > a', $.proxy(this.click, this));
            $this.after($dropdown);
        });
    }
})(window.jQuery);




