<?php


include('../../includes/overall.inc.php');
include('../../includes/admin-functions.inc.php');

use Mnv\Core\ConfigManager;
use Mnv\Core\Uploads\Uploader;
use Mnv\Core\Filesystem\FilesystemManager;
use Mnv\Core\Utilities\GUID;
use Symfony\Component\HttpFoundation\Response as ResponseAlias;

/**
 * Загрузка изображений на сервер через редактор tinymce
 * uploading-file-to-content
 */
if (request()->ajax()) {

    $path = request()->get('path', '');

    loadLanguage(ConfigManager::getValue('admin_language'));

    $uuid = GUID::Format(GUID::Create(), false, '-');
    $filesystem = new FilesystemManager('/uploads', $path);

    if (!$filesystem->isDirectory($filesystem->realPath . 'large')) {
        /** directory large */
        $filesystem->makeDirectory($filesystem->realPath . 'large');
    }
    if (!$filesystem->isDirectory($filesystem->realPath . 'medium')) {
        /** directory medium */
        $filesystem->makeDirectory($filesystem->realPath . 'medium');
    }
    if (!$filesystem->isDirectory($filesystem->realPath . 'small')) {
        /** directory small */
        $filesystem->makeDirectory($filesystem->realPath . 'small');
    }

    $upload = new Uploader([], $filesystem->realPath, $filesystem->path, $uuid, 0);
    if ($upload->validate()) {
        $upload->upload();
    }

    response()->json($upload->response, $upload->response_status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
    exit();

} else {

     die('Hacking attempt!');
}
