<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/blocks?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/blocks" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
                                        {html_options options=$sections name="block[sectionId]" id="sectionId" selected=$block.sectionId|default:'' class="form-control select-search select"}
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="block[title]" value="{$block.title|default:''}">
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">{general:alias}</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="block[alias]" value="{$block.alias|default:''}">
									</div>
								</div>
                                {*                            <div class="col-md-12">*}
                                {*                                <div class="form-group form-group-float">*}
                                {*                                    <label class="form-group-float-label is-visible">{general:filename}</label>*}
                                {*                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="block[fileName]" value="{$block.fileName|default:''}" />*}
                                {*                                </div>*}
                                {*            			    </div>*}
							</div>
						</div>
					</div>
				</div>

				{* фото галерея *}
				{include file="cards/card-gallery.tpl" galleries=$block.gallery|default:[] enable=$block.enableGallery|default:0 module='block'}
				{* /фото галерея *}


				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="content">
									<textarea id="description" name="block[content]" class="description">{$block.content|default:''}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="block[status]" array=$statuses selected=$block.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}

                            {* field positions *}
                            {include file="components/fields/select.tpl" id="positions" title="Расположение изображения" field="block[position]" array=$positions selected=$block.position|default:'L'  class="form-group mb-3"}
                            {* /field imageSize *}

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="block[enableGallery]" value="1" {if isset($block.enableGallery) and $block.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

						</div>

                        {if isset($block.addedOn) && isset($block.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{general:created}</li>
	                                    <li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{$block.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$block.addedBy.loginName|default:"{general:unknownUser}"})</li>
	                                    <li>{$block.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$block.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>

                {* image preview *}
                {include file="cards/card-image.tpl"
                image="{if isset($block.image)}{$block.image.original}{/if}"
                id="{if isset($block.image)}{$block.image.imageId}{/if}"
                module='block'}
                {* /image preview *}

			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($block.blockId)}<input type="hidden" class="form-control" id="id" name="id" value="{$block.blockId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Блок сохранен', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.sectionId)} new Noty({ text: '{articles:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Блок не сохранен', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: 'Нет ни одного раздела', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.position)} new Noty({ text: 'Необходимо выбрать номер позиции', type: 'error', timeout: 2500 }).show(); ;{/if}


		// сортировать фотогалерею
		$(document).on('click', '.sortable_save_button', function () {
			var ids = new Array();
			$('#fileList figure.gallery-item').each(function () {
				console.log($(this).attr('data-id'))

				ids.push($(this).attr('data-id'));
			})
			$.post( "{$generate_url|substr:0:-1}?action=sortPictures", { imageIds : ids }, function(response) {
				$('.sortable_footer_navbar').removeClass('show');
				$("#fileList").load(location.href + " figure.gallery-item");
				new Noty({ text: response.message, type: response.type }).show();
			});
		})
		$(document).on('click', '.sortable_cancel_button', function () {
			$('.sortable_footer_navbar').removeClass('show');
			$("#fileList").load(location.href + " figure.gallery-item");
		})


	});

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }

    function successSortImageMessage() {
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }


</script>
