
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/brand?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/brands" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/brands"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card">
			        {include file="components/selectors.tpl" isFilter=true url="{$adminUrl}/brands" filterDate=false}
				</div>
				<div class="card">
					<div class="">
						<table class="table table-xs table-togglable table-striped table-hover" id="brands">
							<thead>
								<tr>
									<th class="text-center" width="50">{general:table:image}</th>
									<th class="text-start">{general:table:product}</th>
									<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
								</tr>
							</thead>

				            {if !empty($brands)}
								<tbody class="selectable-demo-list brands_list" id="brand_list">

				                {foreach item=brand from=$brands name=brands}
									<tr id="brand-{$brand.brandId}" data-id="{$brand.brandId}" class="{if $brand.status eq 'H'}table-warning{/if}">
										<td class="text-center"><div class="preview preview-md"><img src="{$brand.image}" class="img-thumbnail w-80px" alt="{$brand.name}"/></div></td>
										<td class="text-start"><b>{$brand.name}</b></td>
										<td class="text-center">
											<div class="d-inline-flex">
												<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/brand?action=edit&id={$brand.brandId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
												<div class="dropdown">
													<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/brand?action=edit&id={$brand.brandId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>

														{include file="components/actions/dropdown-status.tpl" module="brands" id=$brand.brandId status=$brand.status scope=parent}
														{include file="components/actions/dropdown-delete.tpl" id=$brand.brandId title="{$brand.name|escape|default:''}" module="brands" scope=parent}
													</div>
												</div>
											</div>
										</td>
									</tr>
				                {/foreach}

								</tbody>
				            {else}
								<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
				            {/if}
						</table>
					</div>
			        {include file="module/pagination.tpl" url="{$adminUrl}/brands" params="{$buildQueryString}"}
				</div>
			</div>
		</div>
	</div>

	<style>
	    table.fixedHeader-floating{
	        position:fixed !important;
	        background-color:white
	    }
	    table.fixedHeader-floating.no-footer{
	        border-bottom-width:0
	    }
	    table.fixedHeader-locked {
	        position:absolute !important;
	        background-color:white
	    }
	    @media print{
	        table.fixedHeader-floating{
	            display:none
	        }
	    }
	</style>
	<script>

	    $(document).ready(function () {

	        {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

	        {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
	        {if isset($errors.not_saved)}   new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
	        {if isset($errors.no_sections)} new Noty({ text: '{brands:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
	        {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

	    });


	    function successImageMessage() {
	        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
	    }


	</script>




