<form method="post" enctype="multipart/form-data" class="form-content-wrapper">


	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">

        <div class="row"> 
            <div class="col-md-8">

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:general}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body">
				            <div class="row">
					            <div class="col-md-12">
						            <div class="form-group mb-3">
							            <label class="form-label {if isset($errors.equipmentIds)}text-danger{/if}">Комплектация</label>
                                        {html_options options=$models name="modelIds[]" id="equipmentIds" selected=$color.modelIds|default:'' class="form-control select" multiple=""}
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title}</label>
							            <input type="text" class="form-control" id="title" autocomplete="off" name="color[colorName]" value="{if isset($color.colorName)}{$color.colorName}{/if}">
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Код цвета <code>пример: #000000</code></label>
							            <div class="input-group">
								            <input type="text" class="form-control" id="move-result" autocomplete="off" name="color[colorCode]" value="{if isset($color.colorCode)}{$color.colorCode}{/if}">
								            <input type="text" class="form-control colorpicker-event-move" value="#45818e">
							            </div>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Название цвета на анг.</label>
							            <input  type="text" class="form-control" id="fileName" autocomplete="off" name="color[fileName]" value="{if isset($color.fileName)}{$color.fileName}{/if}" />
						            </div>
					            </div>
				            </div>
			            </div>
		            </div>
	            </div>

            </div>


	        <div class="col-md-4">
		        <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="color[status]" array=$statuses selected=$color.status|default:'V' class="form-group mb-3"}
                            {* /field status *}
				        </div>
			        </div>
		        </div>
	        </div>

	        <div class="col-md-12 text-center">
                {if isset($color.colorId)}<input type="hidden" name="id" value="{$color.colorId}" />{/if}
                {$smarty.capture.buttons nofilter}
	        </div>


        </div>
    </div>
</form>

<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Цвет сохранен', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Цвет не сохранен', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.equipmentIds)} new Noty({ text: 'Выберите комплектации ', type: 'error', timeout: 2500 }).show(); {/if}

    });

    const demoPalette = [
        ["#000","#444","#666","#999","#ccc","#eee","#f3f3f3","#fff"],
        ["#f00","#f90","#ff0","#0f0","#0ff","#00f","#90f","#f0f"],
        ["#f4cccc","#fce5cd","#fff2cc","#d9ead3","#d0e0e3","#cfe2f3","#d9d2e9","#ead1dc"],
        ["#ea9999","#f9cb9c","#ffe599","#b6d7a8","#a2c4c9","#9fc5e8","#b4a7d6","#d5a6bd"],
        ["#e06666","#f6b26b","#ffd966","#93c47d","#76a5af","#6fa8dc","#8e7cc3","#c27ba0"],
        ["#c00","#e69138","#f1c232","#6aa84f","#45818e","#3d85c6","#674ea7","#a64d79"],
        ["#900","#b45f06","#bf9000","#38761d","#134f5c","#0b5394","#351c75","#741b47"],
        ["#600","#783f04","#7f6000","#274e13","#0c343d","#073763","#20124d","#4c1130"]
    ];

    const currColor = "{if isset($color.colorCode)}{$color.colorCode}{/if}";
    $('.colorpicker-event-move').spectrum({
        showPalette: true,
        palette: demoPalette,
        // showAlpha: true,
        color: currColor.substring(1),
        move: function(c) {
            const label = $('#move-result');
            label.val(c.toHexString());
        }
    });
</script>
