<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->
    
    <!-- Content area -->
    <div class="content">

        <div class="row"> 
            <div class="col-md-8">

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:general}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body">
	                        <div class="row">
		                        <div class="col-md-6">
			                        <div class="form-group mb-3">
				                        <label class="form-label {if isset($errors.modificationId)}text-danger{/if}">Модификация</label>
                                        {html_options options=$modifications name="equipment[modificationId]" id="modificationId" selected=$equipment.modificationId|default:0 class="form-control select"}
			                        </div>
		                        </div>

	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label {if isset($errors.title)}text-danger{/if}">Название комплектации</label>
	                                    <input type="text" class="form-control" id="title" autocomplete="off" name="equipment[title]" value="{$equipment.title|default:''}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
	                                </div>
	                            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Старая цена</label>
							            <input type="text" class="form-control" id="oldPrice" autocomplete="off" name="equipment[oldPrice]" value="{$equipment.oldPrice|default:''}">
						            </div>
					            </div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">Цена</label>
										<input type="text" class="form-control" id="price" autocomplete="off" name="equipment[price]" value="{$equipment.price|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">Ежемесячный платеж</label>
										<input type="text" class="form-control" id="monthPay" autocomplete="off" name="equipment[monthPay]" value="{$equipment.monthPay|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label">Авто в наличии</label>
										<input type="text" class="form-control" id="inStock" autocomplete="off" name="equipment[inStock]" value="{$equipment.inStock|default:''}">
									</div>
								</div>


{*					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Процентная ставка (процент)</label>
								        <input class="form-control" type="text" name="equipment[interestRate]" value="{if isset($equipment.interestRate)}{$equipment.interestRate}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Скидка (сум)</label>
							            <input class="form-control" type="text" name="equipment[discount]" value="{if isset($equipment.discount)}{$equipment.discount}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Разовая комиссия с учетом НДС (процент)</label>
							            <input class="form-control" type="text" name="equipment[commission]" value="{if isset($equipment.commission)}{$equipment.commission}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>

					            <div class="col-md-4">
						            <div class="form-group mb-3">
							            <label class="form-label">Минимальная предоплата (процент)</label>
							            <input class="form-control" type="text" name="equipment[minPrepayment]" value="{if isset($equipment.minPrepayment)}{$equipment.minPrepayment}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group">
							            <label class="form-label">Минимальный срок погашения</label>
							            <input class="form-control" type="text" name="equipment[minRepayment]" value="{if isset($equipment.minRepayment)}{$equipment.minRepayment}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group">
							            <label class="form-label">ГАИ пошлина (сум)</label>
							            <input class="form-control" type="text" name="equipment[toll]" value="{if isset($equipment.toll)}{$equipment.toll}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>

					            <div class="col-md-4">
						            <div class="form-group">
							            <label class="form-label is-visible">Оформление техпаспорта (сум)</label>
							            <input class="form-control" type="text" name="equipment[registrationPassport]" value="{if isset($equipment.registrationPassport)}{$equipment.registrationPassport}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group">
							            <label class="form-label is-visible">Отчисления в дор.фонд (процент)</label>
							            <input class="form-control" type="text" name="equipment[roadFund]" value="{if isset($equipment.roadFund)}{$equipment.roadFund}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
					            <div class="col-md-4">
						            <div class="form-group">
							            <label class="form-label is-visible">Страхование (процент)</label>
							            <input class="form-control" type="text" name="equipment[insurance]" value="{if isset($equipment.insurance)}{$equipment.insurance}{/if}" autocomplete="off" placeholder=""/>
						            </div>
					            </div>
*}


				            </div>
			            </div>
		            </div>
	            </div>

                {* фото галерея *}
	            <div class="collapse {if isset($equipment.enableGallery) and $equipment.enableGallery eq 1}show{/if}" id="gallery-card">
		            <div class="card border shadow-sm">
			            <div class="card-header d-flex flex-wrap">
				            <h6 class="mb-0">{general:card:imageLibrary}</h6>
				            <div class="d-inline-flex ms-auto">
					            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				            </div>
			            </div>

			            <div class="card-body">
				            <div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
                                {if isset($equipment.gallery)}
                                    {foreach item=file from=$equipment.gallery}
							            <figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
								            <div class="move_zone image">
									            <img src="{$file.medium}" alt="{$file.title|default:''}"/>
									            <ul class="gallery-item-controls">
										            <li><span>{$file.orderBy}</span></li>
										            <li>
	                                                    <span class="edit_image" id="edit_image_{$file.imageId}"
	                                                          data-title="{$file.title}"
	                                                          data-alias="{$file.alias}"
	                                                          data-description="{$file.description}"
	                                                          data-link="{$file.link}"
	                                                          data-position="{$file.position}"
	                                                          onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'equipment');"><i class="ph-note-pencil"></i></span>
										            </li>
										            <li>
											            <span onclick="deletePicture({$file.imageId}, 'equipment');"><i class="ph-trash"></i></span>
										            </li>
									            </ul>
								            </div>
								            <div class="meta" id="meta_image_{$file.imageId}">
									            <span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
									            <span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
									            <span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
									            <span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
									            <span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
								            </div>
							            </figure>
                                    {/foreach}
                                {/if}
				            </div>
			            </div>

			            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
				            <button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="gallery" data-path="/" data-action="read_more"><i class="ph-image me-2"></i> {general:uploadFiles} </button>
{*				            <button type="button" class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="article"><i class="ph-check me-2"></i> {general:apply}</button>*}
			            </div>

		            </div>
	            </div>
                {* /фото галерея *}

				{* summary / content *}
	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
{*			            <ul class="nav nav-tabs nav-tabs-overline mb-0">*}
{*				            <li class="nav-item" role="presentation">*}
{*					            <a href="#summary" class="nav-link active" data-bs-toggle="tab" role="tab">{general:tabs:summary}</a>*}
{*				            </li>*}
{*				            <li class="nav-item" role="presentation">*}
{*					            <a href="#content" class="nav-link" data-bs-toggle="tab" role="tab" tabindex="-1">{general:tabs:content}*}
{*					            </a>*}
{*				            </li>*}
{*			            </ul>*}
			            <h6 class="mb-0">{general:card:description}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body {*m-2*}" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body flex-column flex-md-row m-0 p-0">
				            <ul class="nav nav-tabs nav-tabs-overline border-top-0">
					            <li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
					            <li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
				            </ul>

				            <div class="tab-content border-top-0 rounded-top-0 mb-0">
	                            <div class="tab-pane fade show active" id="summary">
	                                <textarea name="equipment[summary]" class="description">{$equipment.summary|default:''}</textarea>
	                            </div>

	                            <div class="tab-pane fade" id="content">
	                                <textarea name="equipment[content]" class="description">{$equipment.content|default:''}</textarea>
	                            </div>
				            </div>
        				</div>
    			    </div>
    		    </div>

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">Опции</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body p-0">
                            {if !empty($options)}
{*	                            <div class="table-responsive">*}
						            <table class="table">
							            <tbody class="specification">
		                                {foreach from=$options name=options item=option}{if !empty($option.properties)}
								            <tr>
									            <td class="text-start" width="40%">{$option.name}</td>
									            <td>
										            <input type="hidden" name="options[{$option.optionId}][parentId]" value="{$option.optionId}">
										            <select class="form-control multiselect" name="options[{$option.optionId}][optionIds][]" multiple="multiple" data-include-select-all-option="true">
				                                        {foreach from=$option.properties item=property}
					                                    <option value="{$property.optionId}" {if !empty($equipment.optionIds) && in_array($property.optionId, $equipment.optionIds)}selected{/if}>{$property.name}</option>
				                                        {/foreach}
			                                        </select>
					                            </td>
								            </tr>
		                                    {/if}{/foreach}
							            </tbody>
						            </table>
{*	                            </div>*}
	                        {else}
	                            <p class="mb-3 text-center"><code>Необходимо добавить или прикрепить уже существующий двигатель, свойства и спецификации</code></p>
                            {/if}
			            </div>
			            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center"></div>
		            </div>
	            </div>

            </div>
    
    
            <div class="col-md-4">
	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body border-top-0">
	                        {* field status *}
	                        {include file="components/fields/select.tpl" id="status" title="{general:status}" field="equipment[status]" array=$statuses selected=$equipment.status|default:'V' class="form-group mb-3"}
	                        {* /field status *}
						    <div class="form-group mb-3">
							    <label class="form-label is-visible">{general:misc:publishDate}</label>
							    <div class="input-group">
								    <span class="input-group-text"><i class="ph-calendar"></i></span>
								    <input type="text" class="form-control date-range-single" name="equipment[publishedOn]" value="{$equipment.publishedOn|default:$adjustedNow}" readonly>
							    </div>
						    </div>
				            <div class="form-check mb-3">
					            <input type="checkbox" class="form-check-input" id="enableGallery" name="equipment[enableGallery]" value="1" {if isset($equipment.enableGallery) and $equipment.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
					            <label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
				            </div>
			            </div>
                        {if isset($equipment.addedOn) && isset($equipment.modifiedOn)}
				            <div class="card-footer hstack gap-3 justify-content-between">
					            <div class="text-muted">
						            <ul class="list list-unstyled mb-0 fs-sm">
							            <li>{general:created}</li>
							            <li>{general:modified}</li>
						            </ul>
					            </div>
					            <div class="hstack gap-1">
						            <ul class="list list-unstyled mb-0 fs-sm">
							            <li>{$equipment.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$equipment.addedBy.loginName|default:"{general:unknownUser}"})</li>
							            <li>{$equipment.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$equipment.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
						            </ul>
					            </div>
				            </div>
                        {/if}
    				</div>
    			</div>

                {* image preview *}
				{include file="cards/card-image.tpl" image="{if isset($equipment.image)}{$equipment.image.original}{/if}" id="{if isset($equipment.image)}{$equipment.image.imageId}{/if}" module='equipment'}
                {* /image preview *}

                {* FILE *}
	            <div class="card">
		            <div class="card-header bg-transparent header-elements-inline">
			            <h6 class="card-title">Брошюра (pdf, word)</h6>
			            <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
		            </div>

		            <div class="card-body">
			            <div class="form-group" id="pdf_docs">
                            {if isset($equipment.docs)}
                                {foreach item=file from=$equipment.docs}
						            <figure class="docs mb-0" id="docs-item-{$file.imageId}">
                                        {if $file.fileFormat eq 'pdf'}
								            <embed src="{$file.original}" width="100%" height="100%" class="mb-2" type="application/pdf"/>
                                        {/if}
							            <div class="input-group">
								            <span class="input-group-text"><img src="/admin/assets/ico/{$file.fileFormat}.svg" width="20"/></span>
								            <input type="text" class="form-control" value="{$file.fileName}" placeholder="" readonly>
								            <button type="button" class="btn btn-danger remove-docs text-white" onclick="deleteDocs({$file.imageId}, 'equipment');"><i class="ph-trash"></i></button>
							            </div>
						            </figure>
                                {/foreach}
                            {/if}
			            </div>
		            </div>
		            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
			            <a class="btn btn-sm btn-primary btn-upload btn-docs read-more" href="javascript:void('')"
			               data-type="docs"
			               data-path="/"
			               data-action="read_more"
			               data-module="files"
			            ><i class="ph-image me-2"></i> {general:uploadFile} </a>
		            </div>
	            </div>

                {* PDF *}
{*	            <div class="card border shadow-sm">*}
{*		            <div class="card-header d-flex flex-wrap">*}
{*			            <h6 class="mb-0">Комплектации и цены (pdf)</h6>*}
{*			            <div class="d-inline-flex ms-auto">*}
{*				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>*}
{*			            </div>*}
{*		            </div>*}
{*		            <div class="collapse show">*}
{*			            <div class="card-body">*}
{*				            <p><code class="p-0">Для генерации файла (Комплектации и цены) можно двумя способами*}
{*						            <br/ > 1) Нажать на кнопку " <i class="icon-file-pdf mr-2"></i>Сгенерировать файл" и сохраните модель*}
{*						            <br/ > 2) Просто сохраните модель<br/ >*}
{*						            <br/ > Если нужно обновить данные в файле*}
{*						            <br/ > 1) Удалите ранее сгенерированный файл или нажать на кнопку " <i class="icon-file-pdf mr-2"></i>Сгенерировать файл" и файл обновится<br/ ><br/ >*}
{*						            НЕ ЗАБЫВАЕМ СОХРАНИТЬ МОДЕЛЬ<br/ ><br/ >*}
{*					            </code></p>*}
{*				            <div class="form-group" id="pdf_price">*}
{*	                            {if !empty($section->pricePdf)}*}
{*						            <input type="hidden" class="form-control" id="pricePdf" name="section[pricePdf]" value="{if isset($section->pricePdf)}{$section->pricePdf}{/if}"/>*}
{*						            <embed src="{$section->pricePdf}" width="100%" height="100%" class="mb-2" type="application/pdf"/>*}
{*						            <div class="input-group">*}
{*							            <span class="input-group-prepend" data-placement="top" data-popup="tooltip" data-original-title="Top tooltip">*}
{*								            <a href="{$section->pricePdf}" target="_blank"><img src="/admin/assets/ico/pdf.svg"/></a>*}
{*							            </span>*}
{*							            <input type="text" class="form-control" value="{$section->name|replace:' ':'_'}_price.pdf" placeholder="" readonly>*}
{*							            <span class="input-group-append remove-docs" style="margin-top: 15px;margin-left: -1px;cursor: pointer" onclick="deletePricePdf({$section->sectionId});"><i class="icon-cross2"></i></span>*}
{*						            </div>*}
{*	                            {/if}*}
{*				            </div>*}
{*			            </div>*}
{*			            <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">*}
{*				            <a class="btn btn-sm btn-primary btn-upload generate-pdf" href="javascript:void('')"><i class="icon-file-pdf me-2"></i>Сгенерировать файл</a>*}
{*			            </div>*}
{*		            </div>*}
{*	            </div>*}

            </div>

	        <div class="col-md-12 text-center">
                {if isset($equipment.equipmentId)}<input type="hidden" name="id" value="{$equipment.equipmentId}" />{/if}
                {$smarty.capture.buttons nofilter}
	        </div>
        </div>

    </div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    	
    $(document).ready(function () {
      
        {if isset($errors.access_denied)}       new Noty({ text: '{products:errors:0}',  type: 'error', timeout: 1500 }).show();     {/if}
        {if isset($errors.title)}               new Noty({ text: 'Введите название комплектации ',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.sectionId)}           new Noty({ text: '{products:errors:2}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.not_saved)}           new Noty({ text: '{products:errors:3}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.no_sections)}         new Noty({ text: '{products:errors:4}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.image_not_saved)}     new Noty({ text: 'Картинка не сохранена',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.article_not_found)}   new Noty({ text: 'Нет такой комплектации',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileName)}            new Noty({ text: 'Такая комплектация уже существует',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameExists)}      new Noty({ text: '{products:errors:8}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameProhibited)}  new Noty({ text: '{products:errors:11}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.fileNameCharacters)}  new Noty({ text: '{products:errors:12}', type: 'error', timeout: 2500 }).show();    {/if}


        {if isset($messages.saved)}             new Noty({ text: 'Комплектация сохранена', type: 'success', timeout: 1500 }).show();  {/if}
    });

    function deleteMessage(){
        new Noty({ text: 'Комплектация удалена', type: 'success', timeout: 1500 }).show();
    }
    function deleteImageError(){
        new Noty({ text: '{sections:errors:14}', type: 'error', timeout: 1500 }).show();
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', type: 'success', timeout: 1500 }).show();
    }
    function successSortImageMessage(){
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }

    function deleteImageSuccess(){
        new Noty({ text: 'Картинка удалена', type: 'success', timeout: 1500 }).show();
        document.getElementById('image_general').style.display = 'none';
    }

    // сортировать фотогалерею
    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('#fileList figure.gallery-item').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortPictures", { imageIds : ids }, function() {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
            new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        $("#fileList").load(location.href + " figure.gallery-item");
    })

    {if isset($equipment.equipmentId)}
    $(document).on("click", ".generate-pdf" , function() {
        $('.generate-pdf').html('<i class="icon-spinner spinner me-2"></i> Генерируется');
        $.ajax({
            url: "{$generate_url|substr:0:-1}?action=generationPricePdf&id={$equipment.equipmentId}",
            method: "POST",
            success: function (response) {
                console.log(response)
                $('#pdf_price').replaceWith('<div class="form-group" id="pdf_price">' +
                    '<embed src="{$GLOBAL_URL}/pdf/{$equipment.title|replace:' ':'_'}_price.pdf" width="100%" height="100%" class="mb-2" type="application/pdf"/>'+
                    '<div class="input-group">'+
                    '<span class="input-group-prepend" data-placement="top" data-popup="tooltip" data-original-title="Top tooltip"><a href="{$SITE_URL}/pdf/{$equipment.title|replace:' ':'_'}_price.pdf" target="_blank"><img src="/admin/assets/ico/pdf.svg"/></a></span>'+
                    '<input type="text" class="form-control" value="{$equipment.title|replace:' ':'_'}_price.pdf" placeholder="" readonly>'+
                    '<span class="input-group-append remove-docs" style="margin-top: 15px;margin-left: -1px;cursor: pointer" onclick="deletePricePdf({$equipment.equipmentId});"><i class="icon-cross2"></i></span>' +
                    '</div>'+
                    '</div>');
                $('.generate-pdf').html('<i class="icon-file-pdf me-2"></i> Файл сгенерирован');

            },
            error: function (error) {
                console.log('error; ' + eval(error));
            }
        });
    });
    {/if}

    // удаление Price Pdf
    function deletePricePdf(id) {
        $.post('{$generate_url|substr:0:-1}?action=deletePricePdf', { id: id }, function(response) {
            if (response.status === 200) {
                $('#pdf_price').children().remove();
                new Noty({ text: 'Файл удален', type: 'success' }).show();
            } else {
                new Noty({ text: 'Файл не удален', type: 'error' }).show();
            }
        }, 'json');
    }

    // цвета салона
    var icolor_row = {$icolor_row|default:0};
    dragula(Array.from(document.querySelectorAll('.sortable_icolor')), {
        direction: 'vertical',
        slideFactorY: 100,
        mirrorContainer: document.querySelector('.sortable_icolor')
    }).on('drop', function (el) {
        $('.btn-sorting-icolor').addClass('show');
    });

    function addIColors() {
        html  = '<tr id="icolor-' + icolor_row + '">';
        html += '<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>';
        html += '<td class="text-start text-nowrap">' +
            '<select name="colors[' + icolor_row + '_i][colorId]" class="form-control select" data-width="200">' +
            '<option value="0">Выбрать цвет...</option>';
        {foreach from=$icolors item=ic}
        html +=         '<option value="{$ic.colorId}">{$ic.colorName}</option>';
        {/foreach}
        html +=      '</select>';
        html += '</td>';
        html += '<td><select name="colors[' + icolor_row + '_i][status]" class="form-control select" data-width="120"><option value="V" selected="selected">Включено</option><option value="H">Скрыто</option></select></td>';
        // html += '<td class="text-center text-nowrap"><input type="text" name="colors[' + icolor_row + '_i][price]" value="" placeholder="Цена" class="form-control" /></td>';
        html += '<td class="text-center text-nowrap"><div class="preview preview-md"><img src="/admin/assets/img/no_images.jpg" class="img-thumbnail w-80px"/></div></td>';
        html += '<td class="text-center text-nowrap"><button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="icolors" data-path="/" data-action="read_more" data-module="files" data-color="' + icolor_row + '"><i class="ph-image me-2"></i>Добавить</button></td>';
        html += '<td>' +
            '<input type="hidden" name="colors[' + icolor_row + '_i][type]" value="icolors">' +
            '<input class="file_id" type="hidden" name="colors[' + icolor_row + '_i][fileId]" value="">' +
            '<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#icolor-' + icolor_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
            '</td>';
        html += '</tr>';

        $('.icolors tbody').append(html);
        $('.select').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Выберите...'
        });

		icolor_row++;
    }


    // сортировать цвета салона
    $(document).on('click', '.btn-sorting-icolor', function () {
        var ids = new Array();
        $('.sortable_icolor tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortByColors", { imageIds : ids }, function() {
            $('.btn-sorting-icolor').removeClass('show');
            new Noty({ text: 'Цвета салона отсортированы', type: 'success' }).show();
        });
    })

    // цвета кузова

    var bcolor_row = {$bcolor_row|default:0};
    dragula(Array.from(document.querySelectorAll('.sortable_bcolor')), {
        direction: 'vertical',
        copy: false,
        copySortSource: false,
        revertOnSpill: false,
        removeOnSpill: false,
        ignoreInputTextSelection: true,
        mirrorContainer: document.querySelector('.sortable_bcolor')
    }).on('drop', function (el) {
        $('.btn-sorting-bcolor').addClass('show');
    });


    function addBColors() {
        html  = '<tr id="bcolor-' + bcolor_row + '">';
        html += '<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>';
        html += '<td class="text-start text-nowrap">' +
            '<select name="colors[' + bcolor_row + '_b][colorId]" class="form-control select" data-width="200">' +
            '<option value="0">Выбрать цвет...</option>';
        {foreach from=$bcolors item=bc}
        html +=         '<option value="{$bc.colorId}">{$bc.colorName}</option>';
        {/foreach}
        html +=     '</select>';
        html += '</td>';
        html += '<td><select name="colors[' + bcolor_row + '_b][status]" class="form-control select" data-width="120"><option value="V" selected="selected">Включено</option><option value="H">Скрыто</option></select></td>';
        // html += '<td class="text-center text-nowrap"><input type="text" name="colors[' + bcolor_row + '_b][price]" value="" placeholder="Цена" class="form-control" /></td>';
        html += '<td class="text-center text-nowrap"><div class="preview preview-md"><img src="/admin/assets/img/no_images.jpg" class="img-thumbnail w-80px"/></div></td>';
        html += '<td class="text-center text-nowrap"><button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="bcolors" data-path="/" data-action="read_more" data-module="files" data-color="' + bcolor_row + '"><i class="ph-image me-2"></i>Добавить</button></td>';
        html += '<td class="text-center p-0">' +
            '<input type="hidden" name="colors[' + bcolor_row + '_b][type]" value="bcolors">' +
            '<input class="file_id" type="hidden" name="colors[' + bcolor_row + '_b][fileId]" value="">' +
            '<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#bcolor-' + bcolor_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
            '</td>';
        html += '</tr>';

        $('.bcolors tbody').append(html);
        $('.select').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Выберите...'
        });

		bcolor_row++;
    }

    // сортировать цвета кузова
    $(document).on('click', '.btn-sorting-bcolor', function () {
        var ids = new Array();
        $('.sortable_bcolor tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortByColors", { imageIds : ids }, function() {
            $('.btn-sorting-bcolor').removeClass('show');
            new Noty({ text: 'Цвета кузова отсортированы', type: 'success' }).show();
        });
    })


</script>
