<!-- Page header -->
{capture name="buttons"}
    {if !empty($sections)}
		<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
    {/if}
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">

		    <div class="card border shadow-sm">
			    <form action="{$generate_url}" method="post">
				    <div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
					    <div class="mb-0">
						    <div class="input-group">
							    <input type="text" class="form-control" name="query" value="{if isset($query)}{$query}{/if}" autocomplete="off" placeholder="{products:general:searchByName}">
							    <button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
						    </div>
					    </div>

					    <div class="ms-sm-auto">
						    <ul class="list-inline list-inline-condensed mb-0">
							    <li class="list-inline-item">
								    <div class="input-group">
                                        {if isset($sections) && !empty($sections)}
                                            {html_options options=$sections selected=$filter.section|default:'' name="filter[section]" class="form-control select" onchange="this.form.submit()" data-width="250"}
                                        {/if}
                                        {if isset($models) && !empty($models)}
                                            {html_options options=$models selected=$filter.model|default:'' name="filter[model]" class="form-control select" onchange="this.form.submit()" data-width="250"}
                                        {/if}

                                        {if isset($statuses) && !empty($statuses)}
                                            {html_options options=$statuses selected=$filter.status|default:'' name="filter[status]" class="form-control select" onchange="this.form.submit()" data-width="160"}
                                        {/if}
								    </div>
							    </li>
						    </ul>
					    </div>
				    </div>
			    </form>
		    </div>

		    <div class="card border shadow-sm">
                {include file="views/cars/components/tab.tpl"}
			    <div class="">
                    <table class="table  table-togglable table-striped table-hover" id="equipments">
                    <thead id="header">
                        <tr>
                            <th class="text-center" width="120">{general:table:image}</th>
                            <th class="text-start">Название комплектации</th>
	                        <th class="text-end">{general:table:price}</th>
	                        <th class="text-end">Старая цена</th>
	                        <th class="text-end">Ежемесячный платеж</th>
	                        <th class="text-start">Кол-во</th>
	                        <th class="text-center">Модель</th>
                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if $equipments}
	                    <tbody class="selectable-demo-list articles_list" id="article_list">
	                        {foreach item=equipment from=$equipments name=equipments}
	                        <tr id="equipment-{$equipment.equipmentId}" data-id="{$equipment.equipmentId}" class="{if $equipment.status eq 'H'}table-warning{/if}">
	                            <td  class="text-center"><img src="{$equipment.image}" class="img-preview" alt="{$equipment.title}"/></td>
	                            <td class="text-start">
		                            <b>{$equipment.title|truncate:75}</b>
		                            <div class="d-flex align-items-center text-muted fs-sm">
			                            <span class="badge bg-warning">{$equipment.modification}</span>
		                            </div>
	                            </td>
		                        <td class="text-end"><span class="fw-semibold">{if $equipment.price > 0}{$equipment.price|number_format:0:".":" "} {else}-{/if}</span></td>
		                        <td class="text-end"><span class="fw-semibold">{if $equipment.oldPrice > 0}{$equipment.oldPrice|number_format:0:".":" "} {else}-{/if}</span></td>
		                        <td class="text-end"><span class="fw-semibold">{if $equipment.monthPay > 0}{$equipment.monthPay|number_format:0:".":" "} {else}-{/if}</span></td>
		                        <td class="text-left"><span class="fw-semibold">{$equipment.inStock|number_format:0:".":" "}</span></td>
		                        <td class="text-center"><span class="badge bg-secondary">{$equipment.model}</span></td>
	                            <td class="text-center">
		                            <div class="d-inline-flex">
			                            <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$equipment.equipmentId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>

			                            <div class="dropdown">
				                            <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
				                            <div class="dropdown-menu dropdown-menu-end">
	                                            <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$equipment.equipmentId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i>  {general:edit}</a>
{*					                            <button class="dropdown-item ajax_action" data-module="equipments" data-action="status" data-id="{$equipment.equipmentId}"><i class="{if $equipment.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>*}
                                                {include file="components/actions/dropdown-{if $equipment.status ne 'P'}status{else}approve{/if}.tpl" module="equipments" id=$equipment.equipmentId status=$equipment.status scope=parent}
	                                            <div class="dropdown-divider"></div>
					                            <button class="dropdown-item text-danger" onclick="remove({$equipment.equipmentId}, '{$equipment.title|escape}', 'equipments');"><i class="ph-trash me-2"></i> {general:delete}</button>
	                                        </div>
	                                    </div>
	                                </div>
	                            </td>
	                        </tr>
	                        {/foreach}

	                    </tbody>
                    {else}
	                    <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
			    </div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
            </div>
    	</div>
    </div>
</div>

	<script>
    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{products:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        {if isset($errors.access_denied)} new Noty({ text: '{products:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{products:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{products:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{products:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
    });
    
    function deleteMessage(){
        new Noty({ text: '{products:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    function deleteError(){
        new Noty({ text: 'ошибка при удаление контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'article');
    }

    function notFound(){
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError(){
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


      $("#article_list").sortable({
            items: "> tr",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            axis: 'y',
            cursor: "move",
            cancel: '#header',
            connectWith: '.articles_list',
            placeholder	: "ui-sortable-handle",

            update		: function(event, ui){
                
			    var equipmentIds = new Array();
			    
                $('#article_list tr').each(function() {
                    equipmentIds.push($(this).attr("data-id"));
			    });
			    
                console.log(equipmentIds);
                $.ajax({
				    url:"index.php?mod=equipments",
                    method:"POST",
                    data:{ equipmentIds: equipmentIds, action: 'reorder' },
                    success:function(data) {
                        location.reload();
					    //alert(data);
				    }
			    });
		    }
	    }).disableSelection();

    // Показать вариант
    $(document).on('click', 'a.expand_variant', function() {
        $(this).closest("td.cell").find("li.variant").fadeIn('fast');
        $(this).closest("td.cell").find("a.expand_variant").hide();
        $(this).closest("td.cell").find("a.roll_up_variant").show();
        return false;
    });

    // Свернуть вариант

    $(document).on('click', 'a.roll_up_variant', function() {
        $(this).closest("td.cell").find("li.variant").fadeOut('fast');
        $(this).closest("td.cell").find("a.roll_up_variant").hide();
        $(this).closest("td.cell").find("a.expand_variant").show();
        return false;
    });
</script>



