<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$generate_url}" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}
        {if isset($model.modelId)}
	    <a href="/admin/blockmodels?model_id={$model.modelId}" class="d-flex align-items-center text-body py-2">
		    <span class="flex-1">Инфоблоки</span>
	    </a>
	    {/if}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">
                {* основные поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
                                        {html_options options=$sections name="model[sectionId]" id="sectionId" selected=$model.sectionId|default:0 class="form-control select"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label animatу is-visible {if isset($errors.title)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="model[title]" value="{$model.title|default:''}" onblur="proposeFileName('title', 'fileName', 'model', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label animatу is-visible">{general:alias}</label>
										<input type="text" class="form-control" id="alias" autocomplete="off" name="model[alias]" value="{$model.alias|default:''}">
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="model[fileName]" value="{$model.fileName|default:''}" />
									</div>
								</div>

{*								<div class="col-md-12">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label animatу is-visible">Видео url</label>*}
{*										<input type="text" class="form-control" id="alias" autocomplete="off" name="model[video]" value="{$model.video|default:''}">*}
{*									</div>*}
{*								</div>*}
							</div>
						</div>
					</div>
				</div>
                {* /основные поля *}

                {* фото галерея *}
				{include file="cards/card-gallery.tpl" galleries=$model.gallery|default:[] enable=$model.enableGallery|default:0 module='model'}
                {* /фото галерея *}

                {* текст summary/content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea id="description" name="model[summary]" class="description">{$model.summary|default:''}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea id="description" name="model[content]" class="description">{$model.content|default:''}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /текст описание *}

                {* Цвета кузова *}
{*				<div class="card border shadow-sm">*}
{*					<div class="card-header d-flex flex-wrap">*}
{*						<h6 class="mb-0">Цвета кузова</h6>*}
{*						<div class="d-inline-flex ms-auto">*}
{*							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>*}
{*						</div>*}
{*					</div>*}
{*					<div class="collapse table_js show" data-count="0">*}
{*						<div class="card-body p-0">*}
{*							<table class="table table-xs bcolors" id="bcolors">*}
{*								<thead id="header">*}
{*								<tr>*}
{*									<th class="text-center w-24px">#</th>*}
{*									<th class="text-start">Название цвета</th>*}
{*									<th class="text-start">Статус</th>*}
{*									<th class="text-start">Меню</th>*}
{*									<th class="text-center">Цена</th>*}
{*									<th class="text-center">Картинка</th>*}
{*									<th class="text-center">Загрузить</th>*}
{*									<th class="text-center" width="30"><i class="ph-check"></i></th>*}
{*								</tr>*}
{*								</thead>*}

{*								<tbody class="sortable_bcolor">*}
{*								{assign var=bcolor_row value=0}*}
{*                                {if isset($model.bcolors)}*}
{*                                    {foreach item=bcolor from=$model.bcolors key=key}*}
{*										<tr id="bcolor-{$key}" data-id="{$bcolor.imageId}">*}
{*											<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>*}
{*											<td class="text-start text-nowrap">*}
{*												<select name="colors[{$bcolor_row}_b][colorId]" class="form-control select" data-width="200">*}
{*													<option value="0">Выбрать цвет...</option>*}
{*                                                    {foreach from=$bcolors item=bc}*}
{*														<option value="{$bc.colorId}" {if isset($bcolor.colorId) AND $bcolor.colorId eq $bc.colorId}selected{/if}>{$bc.colorName}</option>*}
{*                                                    {/foreach}*}
{*												</select>*}
{*											</td>*}
{*											<td class="text-start text-nowrap">*}
{*                                                {html_options options=$statuses selected=$bcolor.status|default:'' name="colors[{$bcolor_row}_b][status]" class="form-control select" data-width="160"}*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*                                                {html_options options=$menus selected=$bcolor.menu|default:'' name="colors[{$bcolor_row}_b][menu]" class="form-control select" data-width="100"}*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<input type="text" name="colors[{$bcolor_row}_b][price]" value="{$bcolor.price}" placeholder="Цена" class="form-control" />*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<div class="preview preview-md">*}
{*													<img src="{$bcolor.medium|default:"/admin/assets/img/no_images.jpg"}" class="img-thumbnail w-80px"/>*}
{*												</div>*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="bcolors" data-path="/" data-action="read_more" data-module="files" data-color="{$bcolor_row}"><i class="ph-image me-2"></i>Заменить</button>*}
{*											</td>*}
{*											<td class="text-center">*}
{*												<input type="hidden" name="colors[{$bcolor_row}_b][imageId]" value="{$bcolor.imageId}">*}
{*												<input class="file_id" type="hidden" name="colors[{$bcolor_row}_b][fileId]" value="{$bcolor.fileId}">*}
{*												<input type="hidden" name="colors[{$bcolor_row}_b][type]" value="bcolors">*}
{*												<button type="button" class="btn btn-link text-danger p-0" onclick="confirm('Данное действие необратимо. Вы уверены?') ? deleteColorNew({$bcolor.imageId}, 'model', 'bcolor', {$bcolor_row}): false;"><i class="ph-trash"></i></button>*}
{*											</td>*}
{*										</tr>*}
{*										{assign var=bcolor_row value=$bcolor_row+1}*}
{*                                    {/foreach}*}
{*                                {/if}*}

{*								</tbody>*}

{*							</table>*}


{*						</div>*}
{*						<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">*}
{*							<button type="button" class="btn btn-outline-primary" onclick="addBColors();">Добавить цвет кузова</button>*}
{*							<button type="button" class="btn btn-sm btn-primary btn-sorting-bcolor collapse"><i class="ph-check me-2"></i>{general:apply}</button>*}
{*						</div>*}
{*					</div>*}
{*				</div> *}

                {* Цвета салона *}
{*				<div class="card border shadow-sm">*}
{*					<div class="card-header d-flex flex-wrap">*}
{*						<h6 class="mb-0">Цвета салона</h6>*}
{*						<div class="d-inline-flex ms-auto">*}
{*							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>*}
{*						</div>*}
{*					</div>*}
{*					<div class="collapse show">*}
{*						<div class="card-body p-0">*}
{*							<table class="table table-xs icolors" id="icolors">*}
{*								<thead id="header">*}
{*								<tr>*}
{*									<th class="text-center w-24px">#</th>*}
{*									<th class="text-start">Название цвета</th>*}
{*									<th class="text-start">Статус</th>*}
{*									<th class="text-center">Цена</th>*}
{*									<th class="text-center">Картинка</th>*}
{*									<th class="text-center">Загрузить</th>*}
{*									<th class="text-center" width="30"><i class="ph-check"></i></th>*}
{*								</tr>*}
{*								</thead>*}

{*								<tbody class="sortable_icolor">*}
{*								{assign var=icolor_row value=0}*}
{*                                {if isset($model.icolors)}*}
{*                                    {foreach from=$model.icolors item=iColor key=key}*}
{*										<tr id="icolor-{$key}" data-id="{$iColor.imageId}">*}
{*											<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>*}
{*											<td class="text-start text-nowrap">*}
{*												<select name="colors[{$icolor_row}_i][colorId]" class="form-control select" data-width="200">*}
{*													<option value="0">Выбрать цвет...</option>*}
{*                                                    {foreach from=$icolors item=ic}*}
{*														<option value="{$ic.colorId}" {if isset($iColor.colorId) AND $iColor.colorId eq $ic.colorId}selected{/if}>{$ic.colorName}</option>*}
{*                                                    {/foreach}*}
{*												</select>*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*                                                {html_options options=$statuses selected=$iColor.status|default:'' name="colors[{$icolor_row}_i][status]" class="form-control select" data-width="160"}*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<input type="text" name="colors[{$icolor_row}_i][price]" value="{$iColor.price}" placeholder="Цена" class="form-control" />*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<div class="preview preview-md"><img src="{$iColor.medium|default:"/admin/assets/img/no_images.jpg"}" class="img-thumbnail w-80px"/></div>*}
{*											</td>*}
{*											<td class="text-center text-nowrap">*}
{*												<button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="icolors" data-path="/" data-action="read_more" data-module="files" data-color="{$icolor_row}"><i class="ph-image me-2"></i>Заменить</button>*}
{*											</td>*}
{*											<td>*}
{*												<input type="hidden" name="colors[{$icolor_row}_i][imageId]" value="{$iColor.imageId}">*}
{*												<input class="file_id" type="hidden" name="colors[{$icolor_row}_i][fileId]" value="{$iColor.fileId}">*}
{*												<input type="hidden" name="colors[{$icolor_row}_i][type]" value="icolors">*}
{*												<button type="button" class="btn btn-link text-danger p-0" onclick="confirm('Данное действие необратимо. Вы уверены?') ? deleteColorNew({$iColor.imageId}, 'model', 'icolor', {$icolor_row}): false;"><i class="ph-trash"></i></button>*}
{*											</td>*}
{*										</tr>*}
{*										{assign var=icolor_row value=$icolor_row+1}*}
{*                                    {/foreach}*}
{*                                {/if}*}
{*								</tbody>*}
{*							</table>*}
{*						</div>*}
{*						<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">*}
{*							<button type="button" class="btn btn-outline-primary" onclick="addIColors();">Добавить цвет салона</button>*}
{*							<button type="button" class="btn btn-sm btn-primary btn-sorting-icolor collapse"><i class="ph-check me-2"></i>{general:apply}</button>*}
{*						</div>*}
{*					</div>*}
{*				</div> *}

			</div>

			<div class="col-md-4">

                {* статус и видимость *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="model[status]" array=$statuses selected=$model.status|default:'V' class="form-group mb-3"}
                            {* /field status *}

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="model[enableGallery]" value="1" {if isset($model.enableGallery) and $model.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

{*							<div class="form-check mb-3">*}
{*								<input type="checkbox" class="form-check-input" id="test_drive" name="model[test_drive]" value="1" {if isset($model.test_drive) and $model.test_drive eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">*}
{*								<label class="form-check-label" for="enableGallery">Модель на тест драйве</label>*}
{*							</div>*}

							<div class="form-group mb-3">
								<label class="form-label is-visible">Сортировка</label>
								<input type="number" class="form-control" id="alias"  name="model[orderBy]" value="{$model.orderBy|default:0}">
							</div>

							<div class="form-group mb-3">
								<label class="form-label is-visible">{models:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="model[publishedOn]" value="{$model.publishedOn|default:$adjustedNow}" readonly>
								</div>
							</div>

                            {* field isFeatured *}
                            {include "components/fields/select.tpl" id="isFeatured" title="{models:misc:featured}" field="model[isFeatured]" array=$paramIsFeatured selected=$model.isFeatured|default:0 class="form-group mb-3"}
                            {* /field isFeatured *}

							{* field isFeatured *}
{*                            {include "components/fields/select.tpl" id="test_drive" title="Показать модель в тест драйве" field="model[test_drive]" array=$test_drives selected=$model.test_drive|default:0 class="form-group mb-3"}*}
                            {* /field isFeatured *}

                            {* field status *}
{*                            {include file="components/fields/select.tpl" id="specials" title="Особенность" field="model[special]" array=$specials selected=$model.special|default:''  class="form-group mb-3"}*}
                            {* /field status *}

							{if !empty($dealTypes)}
							<div class="form-group mb-3">
								<label class="form-label is-visible">Варианты оплаты</label>
								{foreach from=$dealTypes item=dealType}
									<div class="form-check mb-1">
										<input type="checkbox" class="form-check-input" id="{$dealType.fileName}" name="payments[{$dealType.fileName}]" value="1" {if isset($model.paymentMethods[$dealType.fileName]) and $model.paymentMethods[$dealType.fileName] eq 1}checked{/if}>
										<label class="form-check-label" for="{$dealType.fileName}">{$dealType.name}</label>
									</div>
								{/foreach}
							</div>
							{/if}
						</div>
                        {if isset($model.addedOn) && isset($model.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{general:created}</li>
										<li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{$model.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$model.addedBy.loginName|default:"{general:unknownUser}"})</li>
										<li>{$model.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$model.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>
                {* /статус и видимость *}

                {* image preview *}
				{include file="cards/card-image.tpl"
                image="{if isset($model.image)}{$model.image.original}{/if}"
                id="{if isset($model.image)}{$model.image.imageId}{/if}"
                module='model'}
                {* /image preview *}

                {* FILE *}
				{include file="cards/card-documents.tpl"
				cardName="Файлы (pdf, word)"
				docs=$model.docs|default:[]
				module='model'}

{*				<div class="card border shadow-sm">*}
{*					<div class="card-header d-flex flex-wrap">*}
{*						<h6 class="mb-0">Брошюра (pdf, word)</h6>*}
{*						<div class="d-inline-flex ms-auto">*}
{*							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>*}
{*						</div>*}
{*					</div>*}
{*					<div class="collapse show">*}
{*						<div class="card-body">*}
{*							<div class="form-group" id="pdf_docs">*}
{*	                            {if isset($model.docs)}*}
{*	                                {foreach item=file from=$model.docs}*}
{*										<figure class="docs mb-2" id="docs-item-{$file.imageId}">*}
{*	                                        {if $file.fileFormat eq 'pdf'}*}
{*												<embed src="{$file.original}" width="100%" height="100%" class="mb-2" type="application/pdf"/>*}
{*	                                        {/if}*}
{*											<div class="input-group">*}
{*												<span class="input-group-text"><img src="/admin/assets/ico/{$file.fileFormat}.svg" width="20"/></span>*}
{*												<input type="text" class="form-control" value="{$file.fileName}" placeholder="" readonly>*}
{*												<input type="text" class="form-control" name="docs[{$file.imageId}][position]" value="{$file.position}">*}
{*												<input type="hidden" name="docs[{$file.imageId}][imageId]" value="{$file.imageId}" />*}
{*												<input type="hidden" name="docs[{$file.imageId}][fileId]" value="{$file.fileId}" />*}
{*												<button type="button" class="btn btn-danger remove-docs text-white" onclick="deleteDocs({$file.imageId}, 'model');"><i class="ph-trash"></i></button>*}
{*											</div>*}
{*										</figure>*}
{*	                                {/foreach}*}
{*	                            {/if}*}
{*							</div>*}
{*						</div>*}
{*						<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">*}
{*							<a class="btn btn-sm btn-primary btn-upload btn-docs read-more" href="javascript:void('')"*}
{*							   data-type="docs"*}
{*							   data-path="/"*}
{*							   data-action="read_more"*}
{*							   data-module="files"*}
{*							><i class="ph-image me-2"></i> {general:uploadFile} </a>*}
{*						</div>*}
{*					</div>*}
{*				</div>*}

                {* Модификации *}

					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">Модификации</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body flex-column flex-md-row m-0">
								<p class="mb-3">Модификация (<code>после создания модели, прикрепить или создать новую модификацию <a href="modifications">здесь</a>, после отобразится здесь в списке</code>)</p>
                                {if isset($model.modelId) && isset($modifications)}
								<div class="modification_list" id="modifications">
                                    {foreach from=$modifications item=modification}
	                                    {include file="views/cars/items/modification.tpl"}
                                    {/foreach}
								</div>
                                {/if}
							</div>

				            <div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">
					            <button type="button" class="btn btn-sm btn-primary btn-upload add-modification"  {if !isset($model.modelId)}disabled{/if} data-bs-toggle="offcanvas" data-bs-target="#add-modification"><i class="ph-gear me-2"></i> Добавить модификацию </button>
					            <a href="modifications?model_id={$model.modelId|default:""}" class="btn link-primary border-primary"><i class="ph-gear me-2"></i> Все модификации </a>
				            </div>

						</div>
					</div>


                {* SEO *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:seo}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0">
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:keywords}</label>
								<textarea id="keywords" name="model[keywords]" class="form-control" rows="3">{$model.keywords|default:''}</textarea>
							</div>
							<div class="form-group">
								<label class="form-label is-visible">{general:description}</label>
								<textarea id="description" name="model[description]" class="form-control" rows="3">{$model.description|default:''}</textarea>
							</div>
						</div>
					</div>
				</div>
                {* /SEO *}
			</div>

			<div class="col-md-12 text-center">
                {if isset($model.modelId)}<input type="hidden" class="form-control" id="id" name="id" value="{$model.modelId}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}
{if isset($model.modelId)}
<div class="offcanvas offcanvas-end offcanvas-size-lg" tabindex="-1" id="add-modification">
	<div class="offcanvas-header bg-light py-0">
		<h5 class="offcanvas-title py-3">Добавить модификацию</h5>
		<button type="button" class="btn btn-light btn-sm btn-icon close_modification border-transparent rounded-pill" data-bs-dismiss="offcanvas">
			<i class="ph-x"></i>
		</button>
	</div>

	<div class="offcanvas-body p-0">
		<form class="client-validation p-3" action="{$generate_url|substr:0:-1}?action=add_modification&id={$model.modelId}" method="post" enctype="multipart/form-data">

			<div class="form-group mb-3">
				<label class="form-label">Название модификации <span class="text-danger">*</span></label>
				<input  type="text" class="form-control required" autocomplete="off" name="modification[name]" value="" placeholder="1.5 AT 4WD (393 л.с.)" />
			</div>
			<div class="form-group mb-3">
				<label class="form-label">Мощность двигателя (л.с.)</label>
				<input class="form-control required" autocomplete="off" type="text" name="modification[power]" value="" placeholder="393" />
			</div>

			<div class="form-group mb-3">
				<label class="form-label">Привод</label>
				<select name="modification[gear]" class="form-control select form-control-select2" required>
					{foreach from=$gear_type item=gear key=key}
						<option value="{$key}">{$gear}</option>
					{/foreach}
				</select>
			</div>
			<div class="form-group mb-3">
				<label class="form-label">{general:status}</label>
                {html_options options=$statuses name="modification[status]" class="form-control select" }
			</div>

			<div class="d-flex align-items-start mb-3">
				<div class="flex-fill">
					<div class="d-flex my-2">
						<button type="submit" class="btn btn-outline-primary">Добавить модификацию</button>
					</div>
				</div>
			</div>
		</form>

	</div>
</div>
{/if}


<script>


    $(document).ready(function () {

        {if isset($messages.saved)} new Noty({ text: '{models:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{models:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.access_denied)} new Noty({ text: '{models:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.sectionId)} new Noty({ text: '{models:errors:2}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{models:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{models:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{models:errors:5}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{models:errors:7}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{models:errors:8}', type: 'error', timeout: 2500 }).show(); {/if}

        // сортировать фотогалею
        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('#fileList figure.gallery-item').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post( "{$generate_url|substr:0:-1}?action=sortPictures", { imageIds : ids }, function() {
                $('.sortable_footer_navbar').removeClass('show');
                $("#fileList").load(location.href + " figure.gallery-item");
                new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
            });
        })
        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
        })


    });


    $(function () {
        function e() {
            keywords_touched || $("#keywords").val(i()),
            description_touched || $("#description").val(t()),
            fileName_touched || $("#fileName").val(n())
        }
        function i() {
            return name = $("#title").val()
        }
        function t() {
            return name = $("#title").val()
        }
        function n() {
            return fileName = $("#title").val(),
                fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"),
                fileName = l(fileName),
                fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase()
        }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"),
                     i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"),
                     t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        keywords_touched = !0, description_touched = !0, fileName_touched = !0,
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#keywords").change(function () {
                keywords_touched = !0
            }),
            $("#description").change(function () {
                description_touched = !0
            }),
            $("#fileName").change(function () {
                fileName_touched = !0
            }),
            $("#title").keyup(function () {
                e()
            })
    });


    // цвета салона
	var icolor_row = {$icolor_row|default:0};
	dragula(Array.from(document.querySelectorAll('.sortable_icolor')), {
		direction: 'vertical',
		slideFactorY: 100,
		mirrorContainer: document.querySelector('.sortable_icolor')
	}).on('drop', function (el) {
		$('.btn-sorting-icolor').addClass('show');
	});



    function addIColors() {
        html  = '<tr id="icolor-' + icolor_row + '">';
        html += '<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>';
        html += '<td class="text-start text-nowrap">' +
		            '<select name="colors[' + icolor_row + '_i][colorId]" class="form-control select" data-width="200">' +
		                '<option value="0">Выбрать цвет...</option>';
                        {foreach from=$icolors item=ic}
        html +=         '<option value="{$ic.colorId}">{$ic.colorName}</option>';
                        {/foreach}
        html +=      '</select>';
        html += '</td>';
        html += '<td><select name="colors[' + icolor_row + '_i][status]" class="form-control select" data-width="160"><option value="V" selected="selected">Включено</option><option value="H">Скрыто</option></select></td>';
     //   html += '<td class="text-center text-nowrap"><input type="text" name="colors[' + icolor_row + '_i][price]" value="" placeholder="Цена" class="form-control" /></td>';
        html += '<td class="text-center text-nowrap"><div class="preview preview-md"><img src="/admin/assets/img/no_images.jpg" class="img-thumbnail w-80px"/></div></td>';
        html += '<td class="text-center text-nowrap"><button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="icolors" data-path="/" data-action="read_more" data-module="files" data-color="' + icolor_row + '"><i class="ph-image me-2"></i>Добавить</button></td>';
        html += '<td>' +
	                '<input type="hidden" name="colors[' + icolor_row + '_i][type]" value="icolors">' +
	                '<input class="file_id" type="hidden" name="colors[' + icolor_row + '_i][fileId]" value="">' +
	                '<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#icolor-' + icolor_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
	            '</td>';
        html += '</tr>';

        $('.icolors tbody').append(html);
        $('.select').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Выберите...'
        });

		icolor_row++;
    }


    // сортировать цвета салона
    $(document).on('click', '.btn-sorting-icolor', function () {
        var ids = new Array();
        $('.sortable_icolor tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortByColors", { imageIds : ids }, function() {
            $('.btn-sorting-icolor').removeClass('show');
            new Noty({ text: 'Цвета салона отсортированы', type: 'success' }).show();
        });
    })

    // цвета кузова
	var bcolor_row = {$bcolor_row|default:0};
	dragula(Array.from(document.querySelectorAll('.sortable_bcolor')), {
		direction: 'vertical',
		copy: false,
		copySortSource: false,
		revertOnSpill: false,
		removeOnSpill: false,
		ignoreInputTextSelection: true,
		mirrorContainer: document.querySelector('.sortable_bcolor')
	}).on('drop', function (el) {
		$('.btn-sorting-bcolor').addClass('show');
	});


    function addBColors() {
        html  = '<tr id="bcolor-' + bcolor_row + '">';
        html += '<td class="text-center text-nowrap p-0 w-24px"><i class="ph-dots-six text-muted"></i></td>';
        html += '<td class="text-start text-nowrap">' +
		            '<select name="colors[' + bcolor_row + '_b][colorId]" class="form-control select" data-width="200">' +
			            '<option value="0">Выбрать цвет...</option>';
			            {foreach from=$bcolors item=bc}
        html +=         '<option value="{$bc.colorId}">{$bc.colorName}</option>';
                        {/foreach}
        html +=     '</select>';
        html += '</td>';
        html += '<td><select name="colors[' + bcolor_row + '_b][status]" class="form-control select" data-width="160"><option value="V" selected="selected">Включено</option><option value="H">Скрыто</option></select></td>';
       // html += '<td><select name="colors[' + bcolor_row + '_b][menu]" class="form-control select" data-width="100"><option value="N" selected="selected">Нет</option><option value="Y">Да</option></select></td>';
       // html += '<td class="text-center text-nowrap"><input type="text" name="colors[' + bcolor_row + '_b][price]" value="" placeholder="Цена" class="form-control" /></td>';
        html += '<td class="text-center text-nowrap"><div class="preview preview-md"><img src="/admin/assets/img/no_images.jpg" class="img-thumbnail w-80px"/></div></td>';
        html += '<td class="text-center text-nowrap"><button type="button" class="btn btn-sm btn-primary btn-upload read-more" data-type="bcolors" data-path="/" data-action="read_more" data-module="files" data-color="' + bcolor_row + '"><i class="ph-image me-2"></i>Добавить</button></td>';
        html += '<td class="text-center p-0">' +
		            '<input type="hidden" name="colors[' + bcolor_row + '_b][type]" value="bcolors">' +
                    '<input class="file_id" type="hidden" name="colors[' + bcolor_row + '_b][fileId]" value="">' +
			        '<button type="button" class="btn btn-link text-danger p-0" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#bcolor-' + bcolor_row + '\').remove() : false;"><i class="ph-trash"></i></button>' +
	            '</td>';
        html += '</tr>';

        $('.bcolors tbody').append(html);
        $('.select').select2({
            minimumResultsForSearch: Infinity,
            placeholder: 'Выберите...'
        });

		bcolor_row++;
    }



    // сортировать цвета кузова
    $(document).on('click', '.btn-sorting-bcolor', function () {
        var ids = new Array();
        $('.sortable_bcolor tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$generate_url|substr:0:-1}?action=sortByColors", { imageIds : ids }, function() {
            $('.btn-sorting-bcolor').removeClass('show');
            new Noty({ text: 'Цвета кузова отсортированы', type: 'success' }).show();
        });
    })

    const Form = function() {

        const _componentFormValidate = function() {
            if (!$().validate) {
                console.warn('Warning - validate.min.js is not loaded.');
                return;
            }

            // Initialize
            const $select = $('.form-control-select2').select2({
                minimumResultsForSearch: Infinity
            });

            $select.on('change', function() {
                $(this).trigger('blur');
            });

            const validationElement = $('.client-validation');
            validationElement.validate({
                ignore: 'input[type=hidden], .select2-search__field', // игнорировать скрытые поля
                errorClass: 'validation-invalid-label',
                successClass: 'validation-valid-label',
                validClass: 'validation-valid-label',
                highlight: function(element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                unhighlight: function(element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                success: function(label) {
                    label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
                },
                // Различные компоненты требуют правильного размещения меток ошибок
                errorPlacement: function(error, element) {
                    console.log(element.hasClass('select2-hidden-accessible'))
                    if (element.hasClass('select2-hidden-accessible')) {

                        error.appendTo(element.parent());
                    }
                    else if (element.parents().hasClass('form-control-feedback') || element.parents().hasClass('form-check') || element.parents().hasClass('input-group')) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: form.action,
                        type: form.method,
                        data: $(form).serialize(),
                        success: function(response) {
                            console.log(response)
                            new Noty({ text: response.message, type: response.type }).show();
                            if (response.status == 200) {
                                $('.close_modification').click();
                                setTimeout(function() {
                                    $('.modification_list').append(response.modification);
                                    $('form.client-validation').trigger('reset');
                                }, 1000);
                            }
                        }
                    });
                }
            });
        };

        return {
            init: function() {
                _componentFormValidate();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        Form.init();
    });

</script>
