<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->



<!-- Content area -->
<div class="content">

    <div class="row">
    	<div class="col-md-12">

		    <div class="card border shadow-sm">
			    <form action="{$generate_url}" method="post">
				    <div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
					    <div class="mb-0">
						    <div class="input-group">
							    <input type="text" class="form-control" name="query" value="{if isset($query)}{$query}{/if}" autocomplete="off" placeholder="{products:general:searchByName}">
							    <button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
						    </div>
					    </div>

					    <div class="ms-sm-auto">
						    <ul class="list-inline list-inline-condensed mb-0">
							    <li class="list-inline-item">
								    <div class="input-group">
									    {if isset($models) && !empty($models)}
                                            {html_options options=$models selected=$filter.model|default:'' name="filter[model]" class="form-control select" onchange="this.form.submit()" data-width="250"}
                                        {/if}

                                        {if isset($statuses) && !empty($statuses)}
                                            {html_options options=$statuses selected=$filter.status|default:'' name="filter[status]" class="form-control select" onchange="this.form.submit()" data-width="160"}
                                        {/if}
								    </div>
							    </li>
						    </ul>
					    </div>
				    </div>
			    </form>
		    </div>

            <div class="card border shadow-sm">
                {include file="views/cars/components/tab.tpl"}
	            <div class="">
	                <table class="table table-togglable table-striped table-hover" id="modifications">
                    <thead>
                        <tr>
	                        <th width="30">#</th>
                            <th >Модификация</th>
	                        <th >Тип двигателя</th>
	                        <th >Коробка передач</th>
	                        <th >Привод</th>
	                        <th >Модель</th>
	                        <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if !empty($modifications)}
	                    <tbody class="sortable">

	                        {foreach item=modification from=$modifications name=modifications}
	                        <tr id="modification-{$modification.modificationId}" data-id="{$modification.modificationId}">
		                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
	                            <td><b>{$modification.name}</b></td>
{*		                        <td><span class="badge bg-light border-start border-width-3 text-body rounded-start-0 border-warning">{$modification.engine}</span></td>*}
{*		                        <td><span class="badge bg-light border-start border-width-3 text-body rounded-start-0 border-success">{$modification.transmissions}</span></td>*}
		                        <td>{if !empty($modification.engine)}<span class="badge bg-light text-body"><img class="img-fluid w-24px me-2" src="/admin/assets/img/{$modification.engine}.svg"> {$modification.engineName}</span>{/if}
		                        <td>{if !empty($modification.transmission)}<span class="badge bg-light text-body"><img class="img-fluid w-24px me-2" src="/admin/assets/img/{$modification.transmission}.svg"> {$modification.transmissionName}</span>{/if}
		                        <td>{if !empty($modification.gear)}<span class="badge bg-light text-body"><img class="img-fluid w-24px me-2" src="/admin/assets/img/{$modification.gear}.svg"> {$modification.gearName}</span>{/if}
					            </td>
		                        <td><span class="badge bg-secondary">{$modification.model}</span></td>
		                        <td class="text-center">
		                            <div class="d-inline-flex">
			                            <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$modification.modificationId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
			                            <div class="dropdown">
				                            <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
				                            <div class="dropdown-menu dropdown-menu-end">
	                                            <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$modification.modificationId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
					                            <button class="dropdown-item ajax_action" data-module="modifications" data-action="status" data-id="{$modification.modificationId}"><i class="{if $modification.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
	                                            <div class="dropdown-divider"></div>
	                                            <button class="dropdown-item text-danger" onclick="remove({$modification.modificationId}, '{$modification.name|escape}', 'modifications');"><i class="ph-trash me-2"></i> {general:delete}</button>
	                                        </div>
	                                    </div>
	                                </div>
	                            </td>
	                        </tr>
	                        {/foreach}

	                    </tbody>
                    {else}
                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
            </div>
    	</div>
    
    </div>
</div>

	<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: 'Модификация сохранена', type: 'success', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: 'Модификация не сохранена', type: 'error', timeout: 2500 }).show(); {/if}
    });

    function deleteError(){
        new Noty({ text: 'ошибка при удаление модификации', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: 'Модификация не удален, обновите страницу и повторите удаление', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'modification');
    }


    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/modifications?action=reorder", { modificationIds : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>



