<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$generate_url}" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url=$generate_url}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">
    <div class="row">
    	<div class="col-md-12">
		    <div class="card">
{*			    {include file="views/cars/components/tab.tpl"}*}
			    <div class="">
	                <table class="table table-togglable table-striped table-hover" id="options">
	                    <thead>
	                        <tr>
	                            <th class="text-center" width="30">#</th>
	                            <th class="text-start">Название опции</th>
	                            <th class="text-start">Модель</th>
	                            <th class="text-center">{general:table:status}</th>
	                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
	                        </tr>
	                    </thead>
	                    {if isset($options)}
		                    <tbody class="sortable">
		                        {foreach item=option from=$options name=options}
		                        <tr id="option-{$option.optionId}" data-id="{$option.optionId}" class="{if $option.status eq 'H'}table-warning{/if}">
			                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
		                            <td class="text-start"><b>{$option.name|truncate:75}</b></td>
                                    <td class="text-start">{foreach from=$option.models item=model}<span class="badge bg-secondary me-2">{$model}</span>{/foreach}</td>
		                             <td class="text-center" id="status-{$option.optionId}">{$option.statusName nofilter}</td>
		                            <td class="text-center">
			                            <div class="d-inline-flex">
				                            <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$generate_url|substr:0:-1}?action=edit&id={$option.optionId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
				                            <div class="dropdown">
					                            <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
					                            <div class="dropdown-menu dropdown-menu-end">
		                                            <a class="dropdown-item" href="{$generate_url|substr:0:-1}?action=edit&id={$option.optionId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
						                            <button class="dropdown-item ajax_action" data-module="options" data-action="status" data-id="{$option.optionId}"><i class="{if $option.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
						                            <div class="dropdown-divider"></div>
		                                            <button class="dropdown-item text-danger" onclick="remove({$option.optionId}, '{$option.name nofilter}', 'options');"><i class="ph-trash me-2"></i> {general:delete}</button>
		                                        </div>
		                                    </div>
		                                </div>
		                            </td>
		                        </tr>
		                        {/foreach}
		                    </tbody>
	                    {else}
	                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
	                    {/if}
	                </table>
			    </div>
                {include file="module/pagination.tpl" url="{$generate_url}" params="{$buildQueryString}"}
            </div>
    	</div>
    
    </div>
</div>

	<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{articles:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function deleteError(){
        new Noty({ text: 'ошибка при удаление контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id){
        new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'feature');
    }

    function notFound(){
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError(){
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }
    function statusError(){
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    $(document).on('click', '.sortable_save_button', function () {
        var optionIds = new Array();
        $('.sortable tr').each(function () {
            optionIds.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/options?action=reorder", { optionIds : optionIds }, function() {
            $('.sortable_footer_navbar').removeClass('show');
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

</script>



