<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/dealers?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/dealers" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

		<div class="row">
			<div class="col-md-8">

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
{*								<div class="col-md-12">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label {if isset($errors.cityId)}text-danger{/if}">{general:section}</label>*}
{*                                        {html_options options=$cities name="dealer[cityId]" id="cityId" selected=$dealer.cityId|default:'' class="form-control select-search select"}*}
{*									</div>*}
{*								</div>*}

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.cityId)}text-danger{/if}">Город</label>
                                        {html_options options=$cities name="dealer[cityId]" id="cityId" selected=$dealer.cityId|default:'' class="form-control select-search select"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.title)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="dealer[title]" value="{$dealer.title|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Адрес</label>
										<input type="text" class="form-control" id="address" autocomplete="off" name="dealer[address]" value="{$dealer.address|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Координаты</label>
										<input type="text" class="form-control" id="coordinates" autocomplete="off" name="dealer[coordinates]" value="{$dealer.coordinates|default:''}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Ориентир</label>
										<input type="text" class="form-control" id="landmark" autocomplete="off" name="dealer[landmark]" value="{$dealer.landmark|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Телефон</label>
										<input type="text" class="form-control" id="phone" autocomplete="off" name="dealer[phone]" value="{$dealer.phone|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Часы работы</label>
										<input type="text" class="form-control" autocomplete="off" name="dealer[office_hours]" value="{$dealer.office_hours|default:''}">
									</div>
								</div>
{*								<div class="col-md-6">*}
{*									<div class="form-group mb-3">*}
{*										<label class="form-label">Ссылка на сайт</label>*}
{*										<input type="text" class="form-control" autocomplete="off" name="dealer[website]" value="{$dealer.website|default:''}">*}
{*									</div>*}
{*								</div>*}
							</div>
						</div>
					</div>
				</div>

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="content">
									<textarea id="description" name="dealer[content]" class="description">{$dealer.content|default:''}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="dealer[status]" array=$statuses selected=$dealer.status|default:'V'  class="form-group mb-3"}
                            {* /field status *}
						</div>

                        {if isset($dealer.addedOn) && isset($dealer.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{general:created}</li>
	                                    <li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
	                                    <li>{$dealer.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$dealer.addedBy.loginName|default:"{general:unknownUser}"})</li>
	                                    <li>{$dealer.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$dealer.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
                        {/if}
					</div>
				</div>

				{* image preview *}
				{include file="cards/card-image.tpl"
				image="{if isset($dealer.image)}{$dealer.image.original}{/if}"
				id="{if isset($dealer.image)}{$dealer.image.imageId}{/if}"
				module='dealer'}
				{* /image preview *}
			</div>

			<div class="col-md-12 main main_buttons text-center">
                {if isset($dealer.dealerId)}<input type="hidden" class="form-control" id="id" name="id" value="{$dealer.dealerId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>


    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Дилер сохранен', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{articles:errors:1}', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.countryId)} new Noty({ text: 'Укажите город', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Дилер не сохранен', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function notFound() {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }

    function successSortImageMessage() {
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }


</script>
