<!-- Inner content -->
<div class="content-inner" data-bs-spy="scroll" data-bs-target="#page_nav">

	<!-- Page header -->
    {capture name="buttons"}{/capture}

    {capture name="breadcrumb"}
		<span class="breadcrumb-item active">{$title}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->
	<!-- Content area -->
	<div class="content">

		<!-- Inner container -->
		<div class="d-flex align-items-stretch align-items-lg-start flex-column flex-lg-row">

			<!-- Left content -->
			<div class="flex-1 order-2 order-lg-1">

				<!-- Scrollspy -->
				<div class="card">
					<div class="card-header"><h5 class="mb-0">Smarty</h5></div>

					<div class="card-body">
						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction">Доступные fetch</h6>

							<div class="mb-3">
								<ul class="list-inline mb-0">
									<li class="list-inline-item"><a href="#fetch_sections">fetch_sections</a></li>
									<li class="list-inline-item"><a href="#fetch_section">fetch_section</a></li>
									<li class="list-inline-item"><a href="#section_banner">section_banner</a></li>
									<li class="list-inline-item"><a href="#fetch_articles">fetch_articles</a></li>
									<li class="list-inline-item"><a href="#fetch_article">fetch_article</a></li>
									<li class="list-inline-item"><a href="#fetch_comments">fetch_comments</a></li>
									<li class="list-inline-item"><a href="#fetch_banners">fetch_banners</a></li>
									<li class="list-inline-item"><a href="#fetch_banner">fetch_banner</a></li>
									<li class="list-inline-item"><a href="#fetch_faqs">fetch_faqs</a></li>
									<li class="list-inline-item"><a href="#fetch_socials">fetch_socials</a></li>

									<li class="list-inline-item"><a href="#SECTION">SECTION</a></li>
									<li class="list-inline-item"><a href="#SECTIONS">SECTIONS</a></li>
									<li class="list-inline-item"><a href="#TREE">TREE</a></li>
									<li class="list-inline-item"><a href="#ARTICLE">ARTICLE</a></li>
								</ul>
							</div>
						</div>
						<div class="mb-4">
							{* fetch_sections *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_sections">fetch_sections</h6>
								<p>Метод <code>fetch_sections</code> :</p>
								<pre class="language-php">
									<code>
{ldelim}fetch_sections assign=sections level=1 status="V" type=tree{rdelim}
{ldelim}if $sections{rdelim}
	{ldelim}foreach from=$sections item=section{rdelim}
		{ldelim}$section.url{rdelim}
		{ldelim}$section.name{rdelim}
		{ldelim}if !empty($section.gallery){rdelim}
        	{ldelim}foreach item=gallery from=$section.gallery name=galleries{rdelim}
            	&lt;img src="{ldelim}$gallery.original{rdelim}" alt="{ldelim}$gallery.title{rdelim}">
			{ldelim}/foreach{rdelim}
		{ldelim}/if{rdelim}
	{ldelim}foreachelse{rdelim}
  		<p>- Ничего не найдено -</p>
	{ldelim}/foreach{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<div class="table-responsive">
									<table class="table table-xs table-striped">
										<tbody>
										<tr>
											<td>assign</td>
											<td>variable name</td>
										</tr>
										<tr>
											<td>status</td>
											<td>V | H</td>
										</tr>
										<tr>
											<td>from</td>
											<td>parent ID | name</td>
										</tr>
										<tr>
											<td>level</td>
											<td>hierarchy level</td>
										</tr>
										<tr>
											<td>type</td>
											<td>plain | tree</td>
										</tr>
										<tr>
											<td>limit</td>
											<td>max # of sections to return</td>
										</tr>
										<tr>
											<td>sections</td>
											<td>section IDs | names</td>
										</tr>

										<tr>
											<td>getContent</td>
											<td>true | false</td>
										</tr>

										<tr>
											<td>getImage</td>
											<td>true | false</td>
										</tr>
										<tr>
											<td>imageType</td>
											<td>general (default) | gallery | docs || ['general', 'gallery', 'docs']</td>
										</tr>

										<tr>
											<td>headerMenu</td>
											<td>true | false</td>
										</tr>
										<tr>
											<td>footerMenu</td>
											<td>true | false</td>
										</tr>
										</tbody>
									</table>
								</div>
							</div>
							{* /fetch_sections *}

							{* fetch_section *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_section">fetch_section</h6>
								<p>Метод <code>fetch_section</code>  :</p>
								<pre class="language-php">
									<code>
{ldelim}fetch_section assign=section section=2 status="V"{rdelim}
{ldelim}if $section{rdelim}
	{ldelim}$section.url{rdelim}
	{ldelim}$section.name{rdelim}
	{ldelim}if !empty($section.gallery){rdelim}
       	{ldelim}foreach item=gallery from=$section.gallery name=galleries{rdelim}
       		&lt;img src="{ldelim}$gallery.original{rdelim}" alt="{ldelim}$gallery.title{rdelim}">
		{ldelim}/foreach{rdelim}
	{ldelim}/if{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
										<tr>
											<td>assign</td>
											<td>variable name</td>
										</tr>
										<tr>
											<td>status</td>
											<td>V | H</td>
										</tr>
										<tr>
											<td>from</td>
											<td>parent ID | name</td>
										</tr>
										<tr>
											<td>level</td>
											<td>hierarchy level</td>
										</tr>
										<tr>
											<td>type</td>
											<td>plain | tree</td>
										</tr>
										<tr>
											<td>section</td>
											<td>section IDs | names</td>
										</tr>
										<tr>
											<td>getContent</td>
											<td>true | false</td>
										</tr>
									</tbody>
								</table>
							</div>
							{* fetch_article *}

							{* fetch_section *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="section_banner">section_banner</h6>
								<p>Метод <code>section_banner</code> :</p>
								<pre class="language-php">
									<code>
{ldelim}if !empty($section.gallery){rdelim}
	{ldelim}assign var=banner value=$section.gallery|element:'position':'banner'{rdelim}
	{ldelim}if !empty($banner){rdelim}
		{ldelim}$banner.original{rdelim}
		{ldelim}$banner.title{rdelim}
	{ldelim}/if{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
							</div>
							{* fetch_article *}

							{* fetch_articles *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_articles">fetch_articles</h6>
								<p>Метод <code>fetch_articles</code> :</p>
								<pre class="language-php">
									<code>
{ldelim}fetch_articles perPage=10 assign=sectionArticles section=$section.sectionId assignPagination=pagination page=$page path=$section.path seFriendly=true getImage=true imageType="general"{rdelim}
{ldelim}foreach item=article from=$sectionArticles name=sectionArticles{rdelim}
	{ldelim}if $article.images{rdelim}
		{ldelim}$article.image.original{rdelim}
	{ldelim}/if{rdelim}
	{ldelim}$article.url{rdelim}
	{ldelim}$article.title{rdelim}
	{ldelim}$article.summary|strip_tags|truncate:400 nofilter{rdelim}
	{ldelim}$article.publishedOn|date_format:$config.date_format_custom{rdelim}
{ldelim}foreachelse{rdelim}
	<p>- Ничего не найдено -</p>
{ldelim}/foreach{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>V | H | P</td>
									</tr>
									<tr>
										<td>limit</td>
										<td>max # of sections to return</td>
									</tr>
									<tr>
										<td>perPage</td>
										<td>the same as limit</td>
									</tr>
									<tr>
										<td>isFeatured</td>
										<td>true | false</td>
									</tr>
									<tr>
										<td>query</td>
										<td>search phrase</td>
									</tr>
									<tr>
										<td>match</td>
										<td>like | all | exact | advanced | any</td>
									</tr>

									<tr>
										<td>order</td>
										<td>column name [ASC | DESC]</td>
									</tr>

									<tr>
										<td>orderBy</td>
										<td>the same as order</td>
									</tr>

									<tr>
										<td>section</td>
										<td>section ID | name</td>
									</tr>
									<tr>
										<td>article</td>
										<td>article ID </td>
									</tr>
									<tr>
										<td>contentType</td>
										<td>articles | news | products</td>
									</tr>
									<tr>
										<td>getImage</td>
										<td>true | false</td>
									</tr>
									<tr>
										<td>imageType</td>
										<td>general (default) | gallery | docs || ['general', 'gallery', 'docs']</td>
									</tr>

									<tr>
										<td>page</td>
										<td>current page #</td>
									</tr>
									<tr>
										<td>skip</td>
										<td>allPrevious | hiddenSections | section ID</td>
									</tr>
									<tr>
										<td>noSubsections</td>
										<td>true | false</td>
									</tr>
									<tr><td>assignPagination</td><td>variable name</td></tr>
									<tr><td>path</td><td>URI of a section</td></tr>
									<tr><td>seFriendly</td><td>true | false</td></tr>
									<tr><td>pnFirst</td><td># of pages from the beginning</td></tr>
									<tr><td>pnBefore</td><td># of pages before the current page</td></tr>
									<tr><td>pnAfter</td><td># of pages after the current page</td></tr>
									<tr><td>pnLast</td><td># <of></of> pages before end</td></tr>

									</tbody>
								</table>
							</div>
							{* /fetch_articles *}

							{* fetch_article *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_article">fetch_article</h6>
								<p>Метод <code>fetch_article</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_article assign=article section=$section.sectionId status="V"{rdelim}
{ldelim}if $article{rdelim}
	{ldelim}if $article.images{rdelim}
		{ldelim}$article.image.original{rdelim}
	{ldelim}/if{rdelim}
	{ldelim}$article.url{rdelim}
	{ldelim}$article.title{rdelim}
	{ldelim}$article.summary|strip_tags|truncate:400 nofilter{rdelim}
	{ldelim}$article.publishedOn|date_format:$config.date_format_custom{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>assign</td><td>variable name</td></tr>
									<tr><td>fields</td><td>list of fields</td></tr>
									<tr><td>status</td><td>V | H | P</td></tr>
									<tr><td>isFeatured</td><td>true | false</td></tr>
									<tr><td>query</td><td>search phrase</td></tr>
									<tr><td>match</td><td>like | all | exact | advanced | any</td></tr>
									<tr><td>order</td><td>column name [ASC | DESC]</td></tr>
									<tr><td>orderBy</td><td>the same as order</td></tr>
									<tr><td>section</td><td>section ID | name</td></tr>
									<tr><td>contentType</td><td>articles | news | products</td></tr>
									<tr><td>noSubsections</td><td>true | false</td></tr>
									</tbody>
								</table>
							</div>
							{* /fetch_article *}

							{* fetch_comments *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_comments">fetch_comments</h6>
								<p>Метод <code>fetch_comments</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_comments assign="comments" articleId=$article.articleId{rdelim}
{ldelim}if $comments{rdelim}
	{ldelim}foreach from=$comments item=comment{rdelim}
		{ldelim}$comment.commentId{rdelim}
		{ldelim}$comment.authorName{rdelim}
		{ldelim}$comment.addedOn|format_date:'F jS, Y \a\t H:i'{rdelim}
		{ldelim}if $config.comments_convert_links{rdelim}
			{ldelim}$comment.content|url2link|nl2br{rdelim}
		{ldelim}else{rdelim}
			{ldelim}$comment.content|nl2br{rdelim}
		{ldelim}/if{rdelim}
	{ldelim}foreachelse{rdelim}
		<p>- Комментариев нет -</p>
	{ldelim}/foreach{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>pending | approved | spam | unconfirmed</td>
									</tr>
									<tr>
										<td>order</td>
										<td>column name [ASC | DESC]</td>
									</tr>

									<tr>
										<td>orderBy</td>
										<td>the same as order</td>
									</tr>

									<tr>
										<td>articleId</td>
										<td>article ID</td>
									</tr>

									<tr>
										<td>limit</td>
										<td>max # of comments to return</td>
									</tr>


									</tbody>
								</table>

							</div>
							{* /fetch_comments *}

							{* fetch_banners *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_banners">fetch_banners</h6>
								<p>Метод <code>fetch_banners</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_banners assign=banners limit=10 section=$section.sectionId{rdelim}
{ldelim}if !empty($banners){rdelim}
	{ldelim}foreach item=banner from=$banners name=banners{rdelim}
		{ldelim}$banner.title nofilter{rdelim}
		{ldelim}$banner.alias nofilter{rdelim}
		{ldelim}$banner.url{rdelim}
	{ldelim}/foreach{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>V | H</td>
									</tr>
									<tr>
										<td>order</td>
										<td>column name [ASC | DESC]</td>
									</tr>

									<tr>
										<td>orderBy</td>
										<td>the same as order</td>
									</tr>

									<tr>
										<td>section</td>
										<td>section ID</td>
									</tr>

									<tr>
										<td>limit</td>
										<td>max # of comments to return</td>
									</tr>
									</tbody>
								</table>
							</div>
							{* /fetch_banners *}

							{* fetch_banner *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_banner">fetch_banner</h6>
								<p>Метод <code>fetch_banner</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_banner assign=banner section=$section.sectionId{rdelim}
{ldelim}if !empty($banner){rdelim}
	{ldelim}$banner.title nofilter{rdelim}
	{ldelim}$banner.alias nofilter{rdelim}
	{ldelim}$banner.url{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>V | H</td>
									</tr>
									<tr>
										<td>section</td>
										<td>section ID</td>
									</tr>
									</tbody>
								</table>

							</div>
							{* /fetch_banner *}

							{* fetch_faqs *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_faqs">fetch_faqs</h6>
								<p>Метод <code>fetch_faqs</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_faqs assign=faqs status='V'{rdelim}
{ldelim}if !empty($faqs){rdelim}
	{ldelim}foreach from=$faqs item=faq{rdelim}
		{ldelim}$faq.faqId{rdelim}
		{ldelim}$faq.question{rdelim}
		{ldelim}$faq.answer nofilter{rdelim}
	{ldelim}/foreach{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>V | H</td>
									</tr>
									<tr>
										<td>limit</td>
										<td>max # of comments to return</td>
									</tr>
									</tbody>
								</table>
							</div>
							{* fetch_faqs *}

							{* fetch_socials *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="fetch_socials">fetch_socials</h6>
								<p>Метод <code>fetch_socials</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}fetch_socials assign=socials status='V'{rdelim}
{ldelim}if !empty($socials){rdelim}
    {ldelim}foreach from=$socials item=social{rdelim}
		{ldelim}$social.url{rdelim}
		{ldelim}$social.fileName{rdelim}
	{ldelim}/foreach{rdelim}
{ldelim}/if{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>assign</td>
										<td>variable name</td>
									</tr>
									<tr>
										<td>fields</td>
										<td>list of fields</td>
									</tr>
									<tr>
										<td>status</td>
										<td>V | H</td>
									</tr>
									</tbody>
								</table>

							</div>
							{* /fetch_socials *}

							{* SECTION *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="SECTION">{ldelim}$SECTION{rdelim}</h6>
								<p>Метод <code>{ldelim}$SECTION{rdelim}</code> : </p>
								<p>Это текущий раздел, т.е. если посетитель в разделе новостей. <code>{ldelim}$SECTIONS{rdelim}</code> содержит все следующие свойства для раздела "Новости":</p>

								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>sectionId</td><td>section ID</td></tr>
									<tr><td>parentId</td><td>parent section ID</td></tr>
									<tr><td>name</td><td>section name</td></tr>
									<tr><td>alias</td><td>section alias (alt. name)</td></tr>
									<tr><td>fileName</td><td>section fileName</td></tr>
									<tr><td>type</td><td>plain | tree</td></tr>
									<tr><td>keywords</td><td>META keywords</td></tr>
									<tr><td>description</td><td>META description</td></tr>
									<tr><td>content</td><td>section HTML content</td></tr>
									<tr><td>url</td><td>section web-address</td></tr>
									<tr><td>path</td><td>section PATH</td></tr>
									<tr><td>dir</td><td>section directory/URI</td></tr>
									<tr><td>status</td><td>V | H</td></tr>
									<tr><td>level</td><td>level in hierarchy</td></tr>
									<tr><td>parents</td><td>array of parent IDs</td></tr>
									<tr><td>children</td><td>array of child IDs</td></tr>
									<tr><td>allChildren</td><td>child & grandchild IDs</td></tr>
									</tbody>
								</table>

							</div>
							{* /SECTION *}

							{* SECTIONS *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="SECTIONS">{ldelim}$SECTIONS{rdelim}</h6>
								<p>Метод <code>{ldelim}$SECTIONS{rdelim}</code> : </p>
								<p>Доступен из любого шаблона в любое время. Массив всех разделов. Каждый раздел имеет те же свойства, что и <code>{ldelim}$SECTIONS{rdelim}</code> (за исключением свойства content).</p>
							</div>
							{* /SECTIONS *}
							{* TREE *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="TREE">{ldelim}$TREE{rdelim}</h6>
								<p>Метод <code>{ldelim}$TREE{rdelim}</code> : </p>
								<p>Доступен из любого шаблона в любое время. Иерархический массив всех разделов.<br>
									Каждый раздел имеет те же свойства, что и <code>{ldelim}$SECTIONS{rdelim}</code> (за исключением свойства content) и двух дополнительных:</p>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>hasSubsections</td><td>true | false</td></tr>
									<tr><td>subsections</td><td>array of child sections</td></tr>
									</tbody>
								</table>
							</div>
							{* /TREE *}
							{* ARTICLE *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="ARTICLE">{ldelim}$ARTICLE{rdelim}</h6>
								<p>Метод <code>{ldelim}$ARTICLE{rdelim}</code> : </p>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>articleId</td><td>article ID</td></tr>
									<tr><td>sectionId</td><td>section ID</td></tr>
									<tr><td>publishedOn</td><td>publishing date & time</td></tr>
									<tr><td>fileName</td><td>article fileName</td></tr>
									<tr><td>title</td><td>article title</td></tr>
									<tr><td>alias</td><td>article alias (alt. name)</td></tr>
									<tr><td>status</td><td>V | H | P</td></tr>
									<tr><td>summary</td><td>article HTML summary</td></tr>
									<tr><td>content</td><td>article HTML content</td></tr>
									<tr><td>keywords</td><td>META keywords</td></tr>
									<tr><td>description</td><td>META description</td></tr>
									<tr><td>url</td><td>article web-address</td></tr>
									<tr><td>isFeatured</td><td>true | false</td></tr>
									<tr><td>totalComments</td><td># or comments for the article</td></tr>
									<tr><td>addedBy</td><td>added by [user] (see below)</td></tr>
									<tr><td>section</td><td>section of $SECTION format</td></tr>
									</tbody>
								</table>
							</div>
							{* /ARTICLE *}
						</div>

						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction2">Доступные fetch</h6>

							<div class="mb-3">
								<ul class="list-inline mb-0">

									<li class="list-inline-item"><a href="#logo">logo</a></li>
									<li class="list-inline-item"><a href="#breadcrumb">breadcrumb</a></li>
									<li class="list-inline-item"><a href="#break">break</a></li>
									<li class="list-inline-item"><a href="#page_break">page_break</a></li>
									<li class="list-inline-item"><a href="#bracket_regex">bracket_regex</a></li>
									<li class="list-inline-item"><a href="#phones">phones</a></li>
									<li class="list-inline-item"><a href="#assign">assign</a></li>
									<li class="list-inline-item"><a href="#nocache">nocache</a></li>
									<li class="list-inline-item"><a href="#append">append</a></li>
									<li class="list-inline-item"><a href="#year">Текущий год</a></li>
								</ul>
							</div>
						</div>


						<div class="mb-4">
							{* logo *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="logo">logo</h6>
								<p>Метод <code>logo</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}logo link=true classLink="header__logo"{rdelim}
{ldelim}logo link=true classLink="footer__logo" logoUrl="{ldelim}$ASSETS_URL{rdelim}/images/icons/logo/2.png"{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>link</td>
										<td>true | false</td>
									</tr>
									<tr>
										<td>classLink</td>
										<td>css class tag a</td>
									</tr>
									<tr>
										<td>classImg</td>
										<td>css class tag img</td>
									</tr>
									<tr>
										<td>logoUrl</td>
										<td>link to the image</td>
									</tr>
									</tbody>
								</table>

							</div>
							{* /logo *}

							{* breadcrumb *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="breadcrumb">breadcrumb</h6>
								<p>Метод <code>breadcrumb</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}include file="modules/breadcrumb.tpl" class="bradcrumbs" boldLastItem=false noLastLink=true{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>class</td>
										<td>css class</td>
									</tr>
									<tr>
										<td>boldLastItem</td>
										<td>true | false</td>
									</tr>
									<tr>
										<td>noLastLink</td>
										<td>true | false</td>
									</tr>
									</tbody>
								</table>

							</div>
							{* /breadcrumb *}

							{* break *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="break">break</h6>
								<p>Метод <code>break</code> :</p>
								<pre class="language-php">
									<code>
{ldelim}assign var=contents value=$article.content|break{rdelim}
{ldelim}if is_array($contents){rdelim}
	{ldelim}foreach from=$contents item=content{rdelim}
		{ldelim}$content nofilter{rdelim}
	{ldelim}/foreach{rdelim}
{ldelim}else{rdelim}
	{ldelim}$article.content nofilter{rdelim}
{ldelim}/if{rdelim}

									</code>
								</pre>
							</div>
							{* /break *}

							{* page_break *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="page_break">page_break</h6>
								<p>Метод <code>page_break</code> :</p>
								<pre class="language-php">
									<code>
{ldelim}$section.content|page_break:null|default:'' nofilter{rdelim}
// вывод по ключу массива
{ldelim}$section.content|page_break:0 nofilter{rdelim}
									</code>
								</pre>
							</div>
							{* /page_break *}

							{* bracket_regex *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="bracket_regex">bracket_regex</h6>
								<p>Метод <code>bracket_regex</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}bracket_regex from=$section.content strip_tags=true title='code' content='desc'{rdelim}
{ldelim}foreach from=$regex item=item{rdelim}
	{ldelim}$item.code{rdelim}
	{ldelim}$item.desc nofilter{rdelim}
{ldelim}/foreach{rdelim}
									</code>
								</pre>
								<p>Пример</p>
								<pre class="language-markup">
									<code>
&lt;p>[title]&lt;/p>
&lt;p>content&lt;/p>
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>from</td>
										<td></td>
										<td>тест имеющий квадратные скобки []</td>
									</tr>
									<tr>
										<td>strip_tags</td>
										<td></td>
										<td>true | false</td>
									</tr>

									<tr>
										<td>title</td>
										<td>(optional)</td>
										<td>Имя присваиваемой переменной | default: code</td>
									</tr>
									<tr>
										<td>content</td>
										<td>(optional)</td>
										<td>Имя присваиваемой переменной | default: content</td>
									</tr>
									</tbody>
								</table>
							</div>
							{* /bracket_regex *}

							{* phones *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="phones">phones</h6>
								<p>Метод <code>phones</code> : при использование нескольких телефонов</p>
								<pre class="language-php">
									<code>
{ldelim}assign var=phones value=", "|explode:$config.phone{rdelim}
{ldelim}foreach from=$phones item=phone name=phones{rdelim}
	&lt;li>
		&lt;a href="tel:{ldelim}$phone|strip_phone{rdelim}">
			{ldelim}$phone|format_phone{rdelim}
		&lt;/a>
	&lt;/li>
{ldelim}/foreach{rdelim}

									</code>
								</pre>
								<p>Пример</p>
								<pre class="language-markup">
									<code>
+998 (00) 000-00-00, +998 (00) 000-00-01, +998 (00) 000-00-02

									</code>
								</pre>
							</div>
							{* /phones *}

							{* assign *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="assign">assign</h6>
								<p>Метод <code>assign</code> : используется для назначения переменных шаблона во время выполнения шаблона</p>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>var</td><td></td><td>Имя присваиваемой переменной</td></tr>
									<tr><td>value</td><td></td><td>Присваиваемое значение</td></tr>
									<tr><td>scope</td><td>(optional)</td><td>Область действия назначенной переменной:«parent», «root» или «global».</td></tr>
									</tbody>
								</table>
								<pre class="language-php mb-2">
									<code>
{ldelim}assign var="name" value="Bob"{rdelim}
// или
{ldelim}assign "name" "Bob"{rdelim}
// или
{ldelim}$name='Bob'{rdelim}

The value of $name is {ldelim}$name{rdelim}.
									</code>
								</pre>
								<p>В приведенном выше примере будет выведено:</p>
								<pre class="language-markup mb-2">
									<code>The value of $name is Bob.</code>
								</pre>
								<p>Option Flags</p>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>nocache</td><td>Присваивает переменной атрибут «nocache»</td></tr>
									</tbody>
								</table>
								<pre class="language-php mb-2">
									<code>
{ldelim}assign var="name" value="Bob" nocache{rdelim}
// или
{ldelim}assign "name" "Bob" nocache{rdelim}
// или
{ldelim}$name='Bob' nocache{rdelim}

The value of $name is {ldelim}$name{rdelim}.
									</code>
								</pre>
								<p>В приведенном выше примере будет выведено:</p>
								<pre class="language-markup mb-2">
									<code>The value of $name is Bob.</code>
								</pre>
								<p>Атрибуты</p>
								<table class="table table-xs table-striped mb-2">
									<tbody>
									<tr><td>scope</td><td>(optional)</td><td>Область действия назначенной переменной:«parent», «root» или «global».</td></tr>
									</tbody>
								</table>
								<p>Переменные, назначенные во включенном шаблоне, будут видны во включаемом шаблоне.</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}include file="sub_template.tpl"{rdelim}

{ldelim}* отображать переменную, назначенную в sub_template *{rdelim}
{ldelim}$foo{rdelim}<br>
									</code>
								</pre>
								<p>Приведенный выше шаблон включает в себя пример sub_template.tpl ниже:</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}* foo будет известен также в включающем шаблоне *{rdelim}
{ldelim}assign var="foo" value="something" scope=parent{rdelim}
{ldelim}$foo="something" scope=parent{rdelim}

{ldelim}* bar назначается только локально в включающем шаблоне *{rdelim}
{ldelim}assign var="bar" value="value"{rdelim}
// или
{ldelim}$var="value"{rdelim}
									</code>
								</pre>
								<p>Глобальная переменная видна всем шаблонам.</p>
								<pre class="language-php">
									<code>
{ldelim}assign var=foo value="bar" scope="global"{rdelim}
// или
{ldelim}assign "foo" "bar" scope="global"{rdelim}
// или
{ldelim}$foo="bar" scope="global"{rdelim}
									</code>
								</pre>

							</div>
							{* /assign *}

							{* nocache *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="nocache">nocache</h6>
								<p>Метод <code>nocache</code> : используется для отключения кэширования раздела шаблона.</p>
								<pre class="language-php">
									<code>
{ldelim}nocache{rdelim}
	{ldelim}$smarty.now|date_format{rdelim}
{ldelim}/nocache{rdelim}
									</code>
								</pre>
							</div>
							{* /nocache *}

							{* append *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="append">append</h6>
								<p>Метод <code>append</code> : используется для назначения переменных шаблона во время выполнения шаблона</p>
								<pre class="language-php">
									<code>
{ldelim}append var='name' value='Bob' index='first'{rdelim}
{ldelim}append var='name' value='Meyer' index='last'{rdelim}
// or
{ldelim}append 'name' 'Bob' index='first'{rdelim}
{ldelim}append 'name' 'Meyer' index='last'{rdelim}

The first name is {ldelim}$name.first{rdelim}.<br>
The last name is {ldelim}$name.last{rdelim}.
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr>
										<td>var</td>
										<td></td>
										<td>Имя присваиваемой переменной</td>
									</tr>
									<tr>
										<td>value</td>
										<td></td>
										<td>Присваиваемое значение</td>
									</tr>
									<tr>
										<td>index</td>
										<td>(optional)</td>
										<td>Индекс нового элемента массива. Если не указано, значение добавляется в конец массива.</td>
									</tr>
									<tr>
										<td>scope</td>
										<td>(optional)</td>
										<td>Область действия назначенной переменной: «parent», «root» или «global». По умолчанию локальная, если не указана.</td>
									</tr>
									</tbody>
								</table>
							</div>
							{* /append *}

							{* year *}
							<div class="mb-3">
								<h6 class="fw-semibold" id="year">Текущий год</h6>
								<p>Метод <code>Текущий год</code> :</p>
								<pre class="language-php mb-2">
									<code>
{ldelim}$smarty.now|date_format:"%Y"{rdelim}
									</code>
								</pre>
								<table class="table table-xs table-striped">
									<tbody>
									<tr><td>%a</td><td>сокращенное название дня недели, в зависимости от текущей локали</td></tr>
									<tr><td>%A</td><td>полное название дня недели, в зависимости от текущей локали</td></tr>
									<tr><td>%b</td><td>сокращенное название месяца, в зависимости от текущей локали</td></tr>
									<tr><td>%B</td><td>полное название месяца, в зависимости от текущей локали</td></tr>
									<tr><td>%c</td><td>формат даты и времени по умолчанию для текущей локали</td></tr>
									<tr><td>%C</td><td>номер века (год, деленный на 100, представленный в виде целого в промежутке от 00 до 99)</td></tr>
									<tr><td>%d</td><td>день месяца в десятичном формате (от 01 до 31)</td></tr>
									<tr><td>%D</td><td>синоним %m/%d/%y</td></tr>
									<tr><td>%e</td><td>день месяца в десятичном формате без ведущего нуля (от 1 до 31)</td></tr>
									<tr><td>%g</td><td>Week-based year within century [00,99]</td></tr>
									<tr><td>%G</td><td>Week-based year, including the century [0000,9999]</td></tr>
									<tr><td>%h</td><td>синоним %b</td></tr>
									<tr><td>%H</td><td>часы по 24-часовым часам (от 00 до 23)</td></tr>
									<tr><td>%I</td><td>часы по 12-часовым часам (от 01 до 12)</td></tr>
									<tr><td>%j</td><td>день года (от 001 до 366)</td></tr>
									<tr><td>%k</td><td>часы по 24-часовым часам без ведущего нуля (от 0 до 23)</td></tr>
									<tr><td>%l</td><td>часы по 12-часовым часам без ведущего нуля (от 1 до 12)</td></tr>
									<tr><td>%m</td><td>номер месяца (от 01 до 12)</td></tr>
									<tr><td>%M</td><td>минуты</td></tr>
									<tr><td>%n</td><td>символ новой строки</td></tr>
									<tr><td>%p</td><td>`am' или `pm', в зависимости от заданного формата времени и текущей локали.</td></tr>
									<tr><td>%r</td><td>time in a.m. and p.m. notation</td></tr>
									<tr><td>%R</td><td>time in 24 hour notation</td></tr>
									<tr><td>%S</td><td>секунды</td></tr>
									<tr><td>%t</td><td>символ табуляции</td></tr>
									<tr><td>%T</td><td>время в формате %H:%M:%S</td></tr>
									<tr><td>%u</td><td>номер дня недели [1,7], где 1-ый день - понедельник</td></tr>
									<tr><td>%U</td><td>номер недели в году, считая первое воскресенья года первым днем первой недели</td></tr>
									<tr><td>%V</td><td>номер недели в году (по ISO 8601:1988) в диапазоне от 01 до 53, где первая неделя та, у которой хотя бы 4 дня находятся в данном году. Понедельник считается первым днем недели.</td></tr>
									<tr><td>%w</td><td>номер дня недели, где 0 - воскресенье</td></tr>
									<tr><td>%W</td><td>номер недели в году, считаю первый понедельник первым днем первой недели.</td></tr>
									<tr><td>%x</td><td>предпочтительное представление даты для текущих настроек locale без времени</td></tr>
									<tr><td>%X</td><td>предпочтительное представление времени для текущих настроек locale без даты</td></tr>
									<tr><td>%y</td><td>год в виде десятичного числа без века (от 00 до 99)</td></tr>
									<tr><td>%Y</td><td>год в виде десятичного числа включая век</td></tr>
									<tr><td>%Z</td><td>часовой пояс или имя или сокращение</td></tr>
									<tr><td>%%</td><td>буквальный символ `%'</td></tr>

									</tbody>
								</table>
							</div>
							{* /year *}

						</div>

					</div>
				</div>
			</div>

			<div class="sticky-lg-top order-1 order-lg-2 wmin-lg-300 ms-lg-3 mb-3" id="page_nav">
				<h6 class="fw-semibold mt-lg-3 mb-3">Smarty</h6>

				<ul class="nav nav-scrollspy flex-column">
					<li class="nav-item"><a href="#introduction" class="nav-link">Fetch</a></li>
					<li class="nav-item">
						<ul class="nav nav-scrollspy flex-column">
							<li class="nav-item"><a class="nav-link" href="#fetch_sections">fetch_sections</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_section">fetch_section</a></li>
							<li class="nav-item"><a class="nav-link" href="#section_banner">section_banner</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_articles">fetch_articles</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_article">fetch_article</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_comments">fetch_comments</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_banners">fetch_banners</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_banner">fetch_banner</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_faqs">fetch_faqs</a></li>
							<li class="nav-item"><a class="nav-link" href="#fetch_socials">fetch_socials</a></li>
							<li class="nav-item"><a class="nav-link" href="#SECTION">SECTION</a></li>
							<li class="nav-item"><a class="nav-link" href="#SECTIONS">SECTIONS</a></li>
							<li class="nav-item"><a class="nav-link" href="#TREE">TREE</a></li>
							<li class="nav-item"><a class="nav-link" href="#ARTICLE">ARTICLE</a></li>
						</ul>
					</li>
					<li class="nav-item"><a href="#introduction2" class="nav-link">Вызовы</a></li>
					<li class="nav-item">
						<ul class="nav nav-scrollspy flex-column">
							<li class="nav-item"><a class="nav-link" href="#logo">logo</a></li>
							<li class="nav-item"><a class="nav-link" href="#breadcrumb">breadcrumb</a></li>
							<li class="nav-item"><a class="nav-link" href="#break">break</a></li>
							<li class="nav-item"><a class="nav-link" href="#page_break">page_break</a></li>
							<li class="nav-item"><a class="nav-link" href="#bracket_regex">bracket_regex</a></li>
							<li class="nav-item"><a class="nav-link" href="#phones">phones</a></li>
							<li class="nav-item"><a class="nav-link" href="#assign">assign</a></li>
							<li class="nav-item"><a class="nav-link" href="#nocache">nocache</a></li>
							<li class="nav-item"><a class="nav-link" href="#append">append</a></li>
							<li class="nav-item"><a class="nav-link" href="#year">Текущий год</a></li>


						</ul>
					</li>
				</ul>
			</div>

		</div>

	</div>
</div>