{if isset($action) && $action == 'edit'}

	<script type="text/javascript" src="/admin/assets/js/vendor/editors/codemirror/codemirror.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/htmlmixed/htmlmixed.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/xml/xml.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/javascript/javascript.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/css/css.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/clike/clike.js"></script>
	<script type='text/javascript' src="/admin/assets/js/vendor/editors/codemirror/mode/php/php.js"></script>

	<form class="content-inner" action="{$adminUrl}/filemanager" method="post" id="template">
		<input type="hidden" name="path" value="{if isset($path)}{$path}{/if}" />
		<input type="hidden" name="file[name]" value="{if isset($file.name)}{$file.name}{/if}" />

		<!-- Page header -->
        {capture name="buttons"}
	        <button class="btn btn-sm btn-primary me-2" type="submit" name="action" value="save" id="submitButton"><i class="ph-floppy-disk me-2"></i>{general:save}</button>
	        <a class="btn btn-sm btn-light" href="{$adminUrl}/filemanager{if isset($path)}?path={$path|escape}{/if}">{general:cancel}</a>
        {/capture}

        {capture name="breadcrumb"}
			<a href="{$adminUrl}/filemanager" class="breadcrumb-item">{$title}</a>
        {/capture}

        {capture name="showBy"}{/capture}

        {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
		<!-- /page header -->

		<div class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">Редактирование файла <b>{$file.name}</h6>
						</div>
						<div class="collapse show">
							<textarea id="codeEditor" name="file[content]">{if isset($file.content)}{$file.content|escape nofilter}{/if}</textarea>
						</div>
					</div>

					<div class="d-flex justify-content-center p-2">
						{$smarty.capture.buttons nofilter}
					</div>

				</div>
			</div>
		</div>

	</form>

	<script>
        window.onload = function() {
            var editor = CodeMirror.fromTextArea(document.getElementById("codeEditor"), {
                indentUnit: 4,
                lineNumbers: true,
                lineWrapping: true,
                matchBrackets: true,
                mode: "application/x-httpd-php",
                indentWithTabs: true,
                enterMode: "keep",
                tabMode: "shift",
                styleActiveLine: true,
                styleActiveSelected: true,
            });
            editor.setSize('100%','420px');
        };
	</script>


{else}

	<!-- Page header -->
    {capture name="buttons"}
	    <button class="btn btn-sm btn-primary" data-bs-toggle="collapse" data-bs-target="#add_folder">{fileManager:addFolder}</button>&nbsp;&nbsp;
	    <button class="btn btn-sm btn-primary" data-bs-toggle="collapse" data-bs-target="#file_upload">{fileManager:uploadFile}</button>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/filemanager" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
                {* загрузка файла *}
				<div class="collapse" id="file_upload">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{fileManager:uploadFile}</h6>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div id="upload_files" class="dropzone">
									<div class="dz-default dz-message"></div>
									<input type="hidden" name="send_path" value="{if isset($path)}{$path|escape}{else}/{/if}" id="send_path">
								</div>
							</div>
						</div>
					</div>
				</div>
                {* /загрузка файла *}

				{* создание папки *}
				<div class="collapse" id="add_folder">
					<div class="card border shadow-sm bg-light p-2 d-sm-flex align-items-sm-center">
						<div class="mb-0"></div>
						<div class="ms-sm-auto">
							<ul class="list-inline list-inline-condensed mb-0">
								<li class="list-inline-item text-muted">{fileManager:addFolder}</li>
								<li class="list-inline-item">
									<form method="post">
										<div class="input-group">
											<input class="form-control" type="text" name="folder[name]" placeholder="{fileManager:folderName}" data-width="300">
											<button class="btn btn-sm btn-primary" type="submit" name="action" value="add_folder"><i class="icon-folder-plus2 me-2"></i> {fileManager:add}</button>
										</div>
									</form>
								</li>
							</ul>
						</div>
					</div>
				</div>
                {* /создание папки *}

				<div class="card border shadow-sm">
					<div class="table-responsive">
						<table class="table table-xs table-striped table-hover">
							<thead>
							<tr>
								<th class="text-left pl-4">{fileManager:file}</th>
								<th class="text-center" width="80">{fileManager:size}</th>
								<th class="text-center" width="120">{general:modified}</th>
								<th class="text-center" width="100">{general:action}</th>
							</tr>
							</thead>
							<tbody>
		                    {if $upPath ne $path}
								<tr>
									<td colspan="4">
										<a href="{$adminUrl}/filemanager{if isset($upPath)}?path={$upPath}{/if}">
											<i class="icon-undo2 text-primary"></i> {fileManager:back}
										</a>
									</td>
								</tr>
		                    {/if}

		                    {if isset($list)}
		                        {if isset($list.dirs)}
		                            {foreach item=dir from=$list.dirs}
										<tr>
											<td class="text-start">
												<a href="{$adminUrl}/filemanager?path={$path|escape}{$dir.name}">
													<i class="ph-folder-notch text-primary me-2"></i><span class="text-body">{$dir.name}</span>
												</a>
											</td>
											<td class="text-start text-nowrap">{*$dir.size*}</td>
											<td class="text-center text-nowrap">{$dir.mtime|format_time:"d.m.Y H:i"}</td>
											<td class="text-end">
												<button type="button" class="btn btn-sm btn-link text-danger" onclick="deleteFile('{$path|escape}', '{$dir.name|escape}', 'filemanager')" >
													<i class="ph-trash"></i>
												</button>
											</td>
										</tr>
		                            {/foreach}
		                        {/if}

		                        {if isset($list.files)}
		                            {foreach from=$list.files item=file}
										<tr>
											<td><i class="ph-file-code me-2 text-primary"></i> {$file.name}</td>
											<td class="text-start text-nowrap">{$file.size|fsize_format}</td>
											<td class="text-center text-nowrap">{$file.mtime|format_time:"d.m.Y H:i"}</td>
											<td class="text-end">
												<div class="d-inline-flex">
													<a class="btn btn-sm btn-default text-primary" href="{$adminUrl}/filemanager?action=edit&path={$path|escape}&file[name]={$file.name|escape:url}"><i class="ph-note-pencil"></i></a>
													<button type="button" class="btn btn-sm btn-link text-danger" onclick="deleteFile('{$path|escape}', '{$file.name|escape}', 'filemanager')" ><i class="ph-trash"></i></button>
												</div>
											</td>
										</tr>
		                            {/foreach}
		                        {/if}
		                    {/if}
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>

{/if}

<script>
    $(document).ready(function () {
        {if isset($errors.upload)} new Noty({ text: '{fileManager:errors:0}', type: 'error' }).show(); {/if}
        {if isset($errors.folder)} new Noty({ text: '{fileManager:errors:1}', type: 'error' }).show(); {/if}
        {if isset($errors.deleteFile)} new Noty({ text: '{fileManager:errors:2}', type: 'error' }).show(); {/if}
        {if isset($errors.deleteFolder)} new Noty({ text: '{fileManager:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.save)} new Noty({ text: '{fileManager:errors:4}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: '{fileManager:errors:5}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameNoDot)} new Noty({ text: '{fileManager:errors:6}', type: 'error' }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: '{fileManager:errors:7}', type: 'error' }).show(); {/if}
        {if isset($errors.accessDenied)} new Noty({ text: '{fileManager:errors:8}', type: 'error' }).show();{/if}
        {if isset($errors.fileNotFound)} new Noty({ text: '{fileManager:errors:9}', type: 'error' }).show(); {/if}

        {if isset($messages.folder)} new Noty({ text: '{fileManager:messages:0}', type: 'success' }).show(); {/if}
        {if isset($messages.uploaded)} new Noty({ text: '{fileManager:messages:1}', type: 'success' }).show(); {/if}
        {if isset($messages.deletedFile)} new Noty({ text: '{fileManager:messages:2}', type: 'success' }).show(); {/if}
        {if isset($messages.deletedFolder)} new Noty({ text: '{fileManager:messages:3}', type: 'success' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: '{fileManager:messages:4}', type: 'success' }).show(); {/if}
    });
    function uploadMessage(){ new Noty({ text: '{fileManager:messages:5}', layout: 'topRight', type: 'success' }).show(); }

    Dropzone.autoDiscover = false;
    $(document).ready(function () {
        $("#upload_files").dropzone({
            dictDefaultMessage:             lang['dictDefaultMessage'],
            dictFallbackMessage:            lang['dictFallbackMessage'],
            dictFallbackText:               lang['dictFallbackText'],
            dictFileTooBig:                 lang['dictFileTooBig'],
            dictInvalidFileType:            lang['dictInvalidFileType'],
            dictResponseError:              lang['dictResponseError'],
            dictCancelUpload:               lang['dictCancelUpload'],
            dictCancelUploadConfirmation:   lang['dictCancelUploadConfirmation'],
            dictRemoveFile:                 lang['dictRemoveFile'],
            dictRemoveFileConfirmation:     lang['dictRemoveFileConfirmation'],
            dictMaxFilesExceeded:           lang['dictMaxFilesExceeded'],
            paramName: "file",
            url: "{$adminUrl}/filemanager",
            addRemoveLinks: true,
            maxFilesize: 256,
            maxFiles: 100,
            params: { action: 'upload' },
            init: function () {
                this.on('sending', function (file, xhr, formData) {
                    $('.dz-message').css('opacity', 0);
                    formData.append('path', $('#send_path').val());
                });
                this.on("success", function (file, response) {
                    console.log('dropzone success => ', response)
                    if (response.status === 200) {
                        new Noty({ text: response.message, type: 'success' }).show();
                        setTimeout(function(){
                            location.reload();
                        }, 600);
                    } else {
                        $(file.previewElement).find('.dz-error-mark').css('display', 'block').css('opacity', 1);
                        new Noty({ text: response.message, type: 'error' }).show();
                    }
                });
                this.on("queuecomplete", function () {

                });
                this.on('error', function (file, response) {
                    $(file.previewElement).find('.dz-error-message');
                    new Noty({ text: response.error, type: 'error' }).show();
                });
            },
            accept: function(file, done) {
                return done();
            }
        });
    });
</script>




