
<script src="/admin/assets/js/vendor/visualization/echarts/echarts.min.js"></script>

<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<span class="breadcrumb-item active">{$title}</span>
{/capture}

{capture name="showBy"}

{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

{if empty($days)}
	<div class="content d-flex justify-content-center align-items-center">
		<div class="flex-fill">
			<div class="text-center mb-3">
				<h1 class="error-title offline-title">Statistics is empty </h1>
				<div class="row">
					<div class="col-md-6 offset-md-3">
						<div class="alert bg-info text-white alert-styled-left alert-dismissible">
							<span class="font-weight-semibold">Сбор статистики!</span> Нужно включить в настройках.
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
{/if}

<div class="content">
	<div class="row">
        {if !empty($days)}
			<div class="col-xl-12">
				<div class="card border shadow-sm">
					<div class="card-body">
						<div class="chart-container">
							<div class="chart has-fixed-height" id="stats_users"></div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-xl-12">
				<div class="card border shadow-sm">
					<div class="card-body">
						<div class="chart-container">
							<div class="chart has-fixed-height" id="stats_contents"></div>
						</div>
					</div>
				</div>
			</div>
        {/if}

		<div class="col-xl-12">
			<div class="card border shadow-sm">
				<div class="card-body p-0">
					<ul class="nav nav-tabs nav-tabs-solid border-0 mb-0">
						<li class="nav-item"><a href="#info" class="nav-link active" data-bs-toggle="tab"><span class="ph-gear me-2"></span>Автопроверка системы</a></li>
						<li class="nav-item"><a href="#notice" class="nav-link" data-bs-toggle="tab"><span class="ph-note-pencil me-2"></span>Заметки</a></li>

					</ul>

					<div class="tab-content">
						<div class="tab-pane fade show active" id="info">
							<div class="table-responsive">
								<table class="table table-striped table-xs">
									<tbody>
									<tr><td>Операционная система:</td>                      <td>{$os_version}</td></tr>
									<tr><td>Версия PHP:</td>                                <td>{$php_version}</td></tr>
									<tr><td>Версия MySQL:</td>                              <td>{$mysql_version}</td></tr>
									<tr><td>Размер базы данных:</td>                        <td>{$mysql_size}</td></tr>
									<tr><td>Обработчик изображений:</td>                    <td>{$gd_version|replace:"&nbsp;":" "}</td></tr>
									<tr><td>Module mod_rewrite</td>                         <td>{$mod_rewrite}</td></tr>
									<tr><td>Выделено оперативной памяти:</td>               <td>{$max_memory}</td></tr>
									<tr><td>Отключенные функции:</td>                       <td>{$disabled_functions}</td></tr>
									<tr><td>Максимальный размер загружаемого файла:</td>    <td>{$upload_max_filesize}</td></tr>
									<tr><td>Размер свободного места на диске:</td>          <td>{$disk_free_space}</td></tr>
									</tbody>
								</table>
							</div>
						</div>

						<div class="tab-pane fade" id="notice">
							<textarea id="notice_text" name="notice" class="form-control p-2" style="width:100%;height:200px;" placeholder="Здесь вы можете сохранять собственные заметки и памятки.">{$notice}</textarea>
							<button id="send_notice" name="send_notice" class="btn btn-sm btn-success m-2"><i class="ph-floppy-disk me-2"></i> {general:save}</button>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
</div>

<script>

    var EchartsLines = function() {

        var _notice = function () {
            $('#send_notice').on('click', function() {
                $('#send_notice').html('<i class="icon-spinner spinner mr-2"></i>  Сохраняется');
                var notice_text = $('#notice_text').val();
                console.log(notice_text);
                $.post("{$adminUrl}/main?action=notice", { notice: notice_text } , function( response ) {
                    console.log(response);
                    $('#send_notice').html('<i class="ph-floppy-disk me-2"></i>  Сохранить');
                });
                return false;
            });
        }

        var _lineChartExamples = function() {
            if (typeof echarts == 'undefined') {
                console.warn('Warning - echarts.min.js is not loaded.');
                return;
            }

            var stats_users = document.getElementById('stats_users');
            var stats_contents = document.getElementById('stats_contents');

            {if isset($days)}

            if (stats_users) {
                // Initialize chart
                var line_zoom = echarts.init(stats_users, null, { renderer: 'svg', useDirtyRect: false });

                // Options
                line_zoom.setOption({
                    title: { text: '{stats:visitors}' },
                    color: ['#80FFA5', '#00DDFF', '#ff9300'],
                    textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
                    animationDuration: 750,
                    grid: { left: 0, right: 10, top: 35, bottom: 50, containLabel: true },
                    legend: { data: [ '{stats:newVisitors}', '{stats:returningVisitors}', '{stats:totalVisitors}' ], itemHeight: 8, itemGap: 20 },
                    tooltip: { trigger: 'axis', axisPointer: { label: { backgroundColor: '#6a7985' } }, padding: [10, 15], textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif' } },
                    // toolbox: { feature: { saveAsImage: { } } },

                    xAxis: [ { type: 'category', boundaryGap: false, data: [ {foreach item=day from=$days name=days} '{$day.date}'{if !$smarty.foreach.days.last},{/if} {/foreach} ] } ],
                    yAxis: [ { type: 'value',  axisLabel: { color: '#333' },
                        axisLine: { lineStyle: { color: '#999' } },
                        splitLine: { lineStyle: { color: ['#eee'] } },
                        splitArea: { show: true, areaStyle: { color: ['rgba(250,250,250,0.1)', 'rgba(0,0,0,0.01)'] }} } ],

                    dataZoom: [
                        { type: 'inside',  start: 92, end: 100 },
                        { show: true, type: 'slider', start: 92, end: 100, height: 40, bottom: 0, borderColor: '#26a69a', fillerColor: 'rgba(38,166,154,0.29)', handleStyle: { color: '#26a69a' }}
                    ],
                    series: [
                        {
                            name: '{stats:newVisitors}', type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0, color: 'rgb(128, 255, 165)' }, { offset: 1, color: 'rgb(1, 191, 236)' } ]) },
                            emphasis: { focus: 'series' },
                            data: [{foreach item=day from=$days name=days} {$day.newVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}],
                        },
                        {
                            name: '{stats:returningVisitors}', type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0, color: 'rgb(0, 221, 255)' }, { offset: 1, color: 'rgb(77, 119, 255)' } ]) },
                            emphasis: { focus: 'series' },
                            data: [{foreach item=day from=$days name=days} {$day.retVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}],
                        },
                        {
                            name: '{stats:totalVisitors}', type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0, color: 'rgb(255, 191, 0)' }, { offset: 1, color: 'rgb(224, 62, 76)' } ]) },
                            emphasis: { focus: 'series' },

                            data: [{foreach item=day from=$days name=days} {$day.newVisitors+$day.retVisitors}{if !$smarty.foreach.days.last}, {/if}{/foreach}]
                        }
                    ]
                });
            }

            if (stats_contents) {
                var content_element = echarts.init(stats_contents, null, { renderer: 'svg', useDirtyRect: false });
                content_element.setOption({
                    title: { text: '{stats:visits}' },
                    color: [ '#80FFA5', '#37A2FF', '#FFBF00'],
                    textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
                    animationDuration: 750,
                    grid: { left: 0, right: 10, top: 35, bottom: 50, containLabel: true },
                    legend: { data: [ 'Просмотр страниц', 'Просмотр контента', '{stats:totalVisits}' ], itemHeight: 8, itemGap: 10 },
                    tooltip: { trigger: 'axis', axisPointer: { type: 'cross',  label: { backgroundColor: '#6a7985' } }, padding: [10, 15], textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif' } },
                    // toolbox: { feature: { saveAsImage: { } } },

                    xAxis: [{ type: 'category', boundaryGap: false, data: [{foreach item=day from=$days name=days} '{$day.date}'{if !$smarty.foreach.days.last},{/if} {/foreach}] }],
                    yAxis: [{ type: 'value' }],

                    dataZoom: [
                        { type: 'inside', start: 92, end: 100 },
                        { show: true, type: 'slider', start: 92, end: 100, height: 40, bottom: 0, borderColor: '#26a69a', fillerColor: 'rgba(38,166,154,0.29)', handleStyle: { color: '#26a69a' }}
                    ],
                    series: [
                        {
                            name: 'Просмотр страниц',  type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0,  color: 'rgb(128, 255, 165)' }, { offset: 1,  color: 'rgb(1, 191, 236)' } ]) },
                            emphasis: { focus: 'series' },
                            data: [{foreach item=day from=$days name=days} {$day.sectionVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                        },
                        {
                            name: 'Просмотр контента', type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0, color: 'rgb(55, 162, 255)' }, { offset: 1, color: 'rgb(116, 21, 219)' } ])},
                            emphasis: { focus: 'series' },
                            data: [{foreach item=day from=$days name=days} {$day.articleVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                        },
                        {
                            name: '{stats:totalVisits}', type: 'line', stack: 'Total', smooth: true, lineStyle: { width: 0 }, showSymbol: false,
                            areaStyle: { opacity: 0.8, color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [ { offset: 0, color: 'rgb(255, 191, 0)' }, { offset: 1, color: 'rgb(224, 62, 76)' } ]) },
                            emphasis: { focus: 'series' },
                            data: [{foreach item=day from=$days name=days} {$day.articleVisits+$day.sectionVisits+$day.searchVisits}{if !$smarty.foreach.days.last},{/if}{/foreach}],
                        }
                    ]
                });
            }


            // Resize function
            var triggerChartResize = function() {
                stats_users && line_zoom.resize();
                stats_contents && content_element.resize();
            };

            // On sidebar width change
            $(document).on('click', '.sidebar-control', function() {
                setTimeout(function () {
                    triggerChartResize();
                }, 0);
            });

            // On window resize
            var resizeCharts;
            window.onresize = function () {
                clearTimeout(resizeCharts);
                resizeCharts = setTimeout(function () {
                    triggerChartResize();
                }, 200);
            };

            {/if}
        };

        return {
            init: function() {
                _notice();
                _lineChartExamples();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        EchartsLines.init();
    });
</script>
