
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/payment?action=add"><i class="ph-plus""></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/payments" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
        {include file="module/show-by.tpl" url="{$adminUrl}/payments"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
	    <div class="row">
	        <div class="col-md-12">
	            <div class="card border shadow-sm">
		            <div class="">
			            <table class="table table-xs table-togglable table-striped table-hover" id="payments">
		                    <thead>
		                    <tr>
			                    <th data-hide="phone" class="text-center" width="30">#</th>
		                        <th data-toggle="true" width="150">ЛОГОТИП</th>
			                    <th data-toggle="true">{general:product}</th>
		                        <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                    </tr>
		                    </thead>
		                    {if $payments}
		                        <tbody class="sortable">

		                        {foreach item=payment from=$payments name=payments}
		                            <tr id="payment-{$payment.paymentId}" data-id="{$payment.paymentId}" class="{if $payment.status eq 'H'}table-warning{/if}">
			                            <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
		                                <td>{image_file_name_exists filePath="/app/Modules/Payment/{$payment.fileName}/logo.png" style="width: 90px"}</td>
		                                <td width="100%"><b>{$payment.name}</b></td>
		                                <td class="text-center">
		                                    <div class="d-inline-flex">
			                                    <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/payment?action=edit&id={$payment.paymentId}"><i class="ph-note-pencil me-2"></i></a>
		                                        <div class="dropdown">
			                                        <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
		                                            <div class="dropdown-menu dropdown-menu-end">
		                                                <a class="dropdown-item" href="{$adminUrl}/payment?action=edit&id={$payment.paymentId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														{include file="components/actions/dropdown-status.tpl" module="payments" id=$payment.paymentId status=$payment.status scope=parent}
														{include file="components/actions/dropdown-delete.tpl" id=$payment.paymentId title="{$payment.name|escape|default:''}" module="payments" scope=parent}
		                                            </div>
		                                        </div>
		                                    </div>
		                                </td>
		                            </tr>
		                        {/foreach}

		                        </tbody>

		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
		                    {/if}
		                </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/payments" params="{$buildQueryString}"}
	            </div>
	        </div>
	    </div>
	</div>

	<script>
	    $(document).ready(function () {

	        {if isset($errors.access_denied)} new Noty({ text: '{payments:errors:access_denied}', type: 'error', timeout: 3000 }).show(); {/if}
	        {if isset($errors.name)} new Noty({ text: '{payments:errors:name}', type: 'error', timeout: 3000 }).show(); {/if}
	        {if isset($errors.fileNameExists)} new Noty({ text: '{payments:errors:fileNameExists}', type: 'error', timeout: 3000 }).show(); {/if}
	        {if isset($errors.not_saved)} new Noty({ text: '{payments:errors:not_saved}', type: 'error', timeout: 3000 }).show(); {/if}
	        {if isset($errors.payment_not_found)} new Noty({ text: '{payments:errors:payment_not_found}', type: 'error', timeout: 3000 }).show(); {/if}

	        {if isset($messages.saved)} new Noty({ text: '{payments:messages:payment_save}', type: 'success', timeout: 1500 }).show() {/if}

	    });

        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('.sortable tr').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post( "{$adminUrl}/payments?action=reorder", { ids : ids }, function( data ) {
                $('.sortable_footer_navbar').removeClass('show');
            });
        })
        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            location.reload();
        })

	</script>

