<script type="text/javascript" src="/admin/assets/js/codemirror/codemirror.js"></script>
<form action="/admin/robots" method="post">
    <!-- Page header -->
    {capture name="buttons"}
        <button class="btn btn-sm btn-primary" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i>{general:save}</button>
    {/capture}

    {capture name="breadcrumb"}
        <a href="{$adminUrl}/robots" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}
        <div class="collapse d-md-block ms-md-auto" id="bc_color_transparent">
            <div class="dropdown ms-md-3">
                <a href="javascript:void(0);" class="d-flex align-items-center text-body dropdown-toggle py-2" data-bs-toggle="dropdown">
                    <span class="flex-1">Общие правила для поисковых систем</span>
                </a>

                <div class="dropdown-menu dropdown-menu-end w-100 w-md-auto">
                    <button type="button" class="dropdown-item" onclick="starterKitDisallow()"><i class="ph-check-square-offset me-2"></i> Стартовый набор (Disallow)</button>
                    <button type="button" class="dropdown-item" onclick="starterKitAllow()"><i class="ph-check-square-offset me-2"></i> Стартовый набор (Allow)</button>
                    <button type="button" class="dropdown-item" onclick="addMainMirror()"><i class="ph-check-square-offset me-2"></i> Главное зеркало (Host)</button>
                    <button type="button" class="dropdown-item" onclick="addCrawlDelay()"><i class="ph-check-square-offset me-2"></i> Интервал между запросами (Crawl-delay)</button>
                    <button type="button" class="dropdown-item" onclick="addSitemap()"><i class="ph-check-square-offset me-2"></i> Карта сайта (Sitemap)</button>
                </div>
            </div>
        </div>
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
    <!-- /page header -->

    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <textarea id="codeEditor" name="robots" cols="102" rows="25" class="code" wrap="off">{$robots_txt|escape}</textarea>
                </div>
            </div>
            <div class="col-md-12">
                {$smarty.capture.buttons nofilter}
            </div>
        </div>
    </div>
</form>

<script>

	$(document).ready(function () {
        {if isset($message_error)} new Noty({ text: '{$message_error}', type: 'error', timeout: 1500  }).show(); {/if}
        {if isset($message_success)} new Noty({ text: '{$message_success}', type: 'success', timeout: 1500  }).show(); {/if}
	});

	let editor = CodeMirror.fromTextArea(document.getElementById("codeEditor"), {
		lineNumbers: true,
		matchBrackets: true,
		mode: "mixed",
		indentUnit: 4,
		indentWithTabs: true,
		enterMode: "keep",
		tabMode: "shift"
	});
	editor.setSize('100%','420px');

	// Disallow
	function starterKitDisallow() {
		const newText = 'User-Agent: * \nDisallow: /';

		const textarea = document.getElementById('codeEditor');
		textarea.value = newText;

		reloadCodeMirror(textarea.value);
	}

	// Allow
	function starterKitAllow() {
		const newText = 'User-Agent: * \nAllow: /';

		const textarea = document.getElementById('codeEditor');
		textarea.value = newText;

		reloadCodeMirror(textarea.value);
	}

	function addCrawlDelay() {
		const searchPattern = /^Crawl-delay:.*$/gm;
		const newText ='\n\nCrawl-delay: 2'

		const textarea = document.getElementById('codeEditor');
        if (searchPattern.test(textarea.value)) {
            textarea.value = textarea.value.replace(searchPattern, newText);
		} else {
			textarea.value += '\n\n' + newText;
		}

		reloadCodeMirror(textarea.value);
	}

	function addMainMirror() {
		const domain = getDomain(window.location.href);
        const searchPattern = /^Host: https:\/\/.*$/gm; // Шаблон для поиска всей строки
		const newText = 'Host: https://' + domain

        const textarea = document.getElementById('codeEditor');
        // Проверяем, есть ли совпадение для "Host: https://"
        if (searchPattern.test(textarea.value)) {
            // Если есть, заменяем всю строку на новую
            textarea.value = textarea.value.replace(searchPattern, newText);
        } else {
            // Иначе добавляем строку в конец
            textarea.value += '\n\n' + newText;
        }

		reloadCodeMirror(textarea.value);
	}

	function addSitemap() {
		const domain = getDomain(window.location.href);
        const searchPattern = /^Sitemap: https:\/\/.*$/gm; // Шаблон для поиска всей строки
		const newText = 'Sitemap: https://' + domain + '/sitemap.xml'

		const textarea = document.getElementById('codeEditor');
        // Проверяем, есть ли совпадение для "Host: https://"
        if (searchPattern.test(textarea.value)) {
            // Если есть, заменяем всю строку на новую
            textarea.value = textarea.value.replace(searchPattern, newText);
        } else {
            // Иначе добавляем строку в конец
            textarea.value += '\n\n' + newText;
        }

		reloadCodeMirror(textarea.value);
	}

	function reloadCodeMirror(value) {
        editor.getDoc().setValue(value);

	}

	function getDomain(url) {
		try {
			const parsedUrl = new URL(url);
			return parsedUrl.hostname; // Extracts the domain (e.g., "example.com")
		} catch (error) {
			console.error('Invalid URL', error);
			return null;
		}
	}

</script>







