
<!-- Page header -->
{capture name="buttons"}
	<button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modal_setting"><i class="ph-gear me-2"></i> Настройка яндекс метрики</button>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/yandex" class="breadcrumb-item">Яндекс метрика</a>
{/capture}

{capture name="showBy"}
	{if isset($days)}<span class="breadcrumb-item text-muted pt-1">Статистика показана за {$days} {$days|plural:'день':'дней':'дня'}</span>{/if}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


	<div class="content">
		<div class="row">
			<div class="col-md-12">
				{if isset($message.token_counter)}
					<div class="alert bg-warning text-white alert-styled-left alert-dismissible">
						<span class="fw-semibold">Предупреждение!</span>
						Для просмотра статистики необходимо в <a href="{$adminUrl}/yandex?action=setting" data-bs-toggle="modal" data-bs-target="#modal_setting">настройках</a> ввести "<span class="fw-semibold">Идентификатор счетчика</span>" и "<span class="fw-semibold">Токен</span>
					</div>
				{/if}
			</div>
		</div>

		<div class="card border shadow-sm">
			<div class="card-header d-flex justify-content-between m-0 p-0">
				<ul class="nav nav-tabs nav-tabs-overline nav-tabs-highlight fs-base border-top-0">

					<li class="nav-item">
						<a class="nav-link {if empty($view)}active show{/if}" href="https://admin.panel.11.local/admin/yandex">
							<div class="d-flex align-items-center"><span class="fw-semibold">Данные по посещаемости</span></div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'geo'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=geo">
							<div class="d-flex align-items-center"><span class="fw-semibold">Пользователи по странам и регионам</span></div>
						</a>
					</li>

					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'viewed'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=viewed">
							<div class="d-flex align-items-center"><span class="fw-semibold">Самые просматриваемые страницы</span></div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'phrases'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=phrases">
							<div class="d-flex align-items-center"><span class="fw-semibold">Поисковые фразы</span></div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'search'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=search">
							<div class="d-flex align-items-center"><span class="fw-semibold">Пользователи из поисковых систем</span></div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'browsers'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=browsers">
							<div class="d-flex align-items-center"><span class="fw-semibold">Браузеры пользователей</span></div>
						</a>
					</li>
					<li class="nav-item">
						<a class="nav-link {if !empty($view) && $view eq 'ages'}active show{/if}" href="https://admin.panel.11.local/admin/yandex?view=ages">
							<div class="d-flex align-items-center"><span class="fw-semibold">Пол и возраст пользователей</span></div>
						</a>
					</li>
				</ul>
			</div>

			<div class="card-body m-0 p-0">
				<div class="tab-content mb-0 px-0">

					{* Данные по посещаемости *}
					<div class="tab-pane fade {if empty($view)}active show{/if}" id="general">
						<table class="table table-hovers">
							<thead>
							<tr>
								<th class="text-start">Дата</th>
								<th class="text-start">Визиты</th>
								<th class="text-start">Просмотры</th>
								<th class="text-start">Посетители</th>
							</tr>
							</thead>
							{if isset($attendance) && !empty($attendance)}
								<tbody>
								{foreach from=$attendance.data item=dates key=date}
									<tr class="table-light">
										<th colspan="4">{$date|date_format:"%m.%Y"}</th>
									</tr>
									{foreach from=$dates item=item name=items}
										<tr>
											<td class="text-start text-nowrap"><span>{$item.dimensions.date.name|date_format:"%d.%m.%Y"}</span></td>
											<td class="text-start"><span class="fw-semibold">{$item.metrics.visits}</span></td>
											<td class="text-start"><span class="fw-semibold">{$item.metrics.pageviews}</span></td>
											<td class="text-start"><span class="fw-semibold">{$item.metrics.users}</span></td>
										</tr>
									{/foreach}
								{/foreach}

								<tfoot>
								<tr>
									<td class="text-start text-nowrap">Итого и средние</td>
									<td class="text-start"><span class="fw-semibold">{$attendance.totals.visits}</span></td>
									<td class="text-start"><span class="fw-semibold">{$attendance.totals.pageviews}</span></td>
									<td class="text-start"><span class="fw-semibold">{$attendance.totals.users}</span></td>
								</tr>
								</tfoot>
							{else}
								<tbody>
								<tr>
									<td class="text-center" colspan="4">- {general:none} -</td>
								</tr>
								</tbody>
							{/if}
						</table>
					</div>
					{* /Данные по посещаемости *}

					{* Пользователи по странам и регионам *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'geo'}active show{/if}" id="geo">
						<table class="table table-striped table-hover">
							<thead>
							<tr>
								<th class="text-start">Страна</th>
								<th class="text-start">Регион</th>
								<th class="text-start">Просмотры</th>
							</tr>
							</thead>
							<tbody>
							{if isset($periods) && !empty($periods)}
								{foreach item=period from=$periods.data}
									<tr class="">
										<td class="text-start text-nowrap"><img src="{$GLOBAL_URL}/admin/assets/lang/{$period.dimensions.regionCountry.iso_name|lower}.svg" class=" me-2" width="30">{$period.dimensions.regionCountry.name}</td>
										<td class="text-start text-nowrap">{$period.dimensions.regionArea.name}</td>
										<td class="text-start text-nowrap"><span class="fw-semibold">{$period.metrics.visits}</span></td>
									</tr>
								{/foreach}
							{else}
								<tr>
									<td class="text-center" colspan="3">- {general:none} -</td>
								</tr>
							{/if}
							</tbody>

						</table>
					</div>
					{* /Пользователи по странам и регионам *}

					{* Самые просматриваемые страницы *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'viewed'}active show{/if}" id="viewed">
						<table class="table table-striped table-hover">
							<thead>
							<tr>
								<th class="text-left">Адрес страницы</th>
								<th class="text-left">Просмотры</th>
							</tr>
							</thead>
							<tbody>
							{if isset($pages) && !empty($pages)}
								{foreach item=visitor from=$pages.data}
									<tr class="">
										<td class="text-nowrap"><a href="https://{$visitor.dimensions.URLPathFull.favicon}{$visitor.dimensions.URLPathFull.name}" target="_blank">{$visitor.dimensions.title.name}</a></td>
										<td class="text-nowrap"><span>{$visitor.metrics.pageviews}</span></td>
									</tr>
								{/foreach}
							{else}
								<tr>
									<td class="text-center" colspan="2">- {general:none} -</td>
								</tr>
							{/if}
							</tbody>
						</table>
					</div>
					{* /Самые просматриваемые страницы *}

					{* Поисковые фразы *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'phrases'}active show{/if}" id="phrases">
						<table class="table table-striped table-hover">
							<thead>
							<tr>
								<th class="text-start">Последняя поисковая фраза</th>
								<th class="text-start">Визиты</th>
								<th class="text-start">Посетители</th>
							</tr>
							</thead>
							<tbody>
							{if isset($phrases) && !empty($phrases)}
								{foreach item=visitor from=$phrases.data}
									<tr class="">
										<td class="text-start text-nowrap">{$visitor.dimensions.lastSignSearchPhrase.name}</td>
										<td class="text-start"><span class="fw-semibold">{$visitor.metrics.visits}</span></td>
										<td class="text-start"><span class="fw-semibold">{$visitor.metrics.users}</span></td>
									</tr>
								{/foreach}
							{else}
								<tr>
									<td class="text-center" colspan="3">- {general:none} -</td>
								</tr>
							{/if}
							</tbody>
						</table>
					</div>
					{* /Поисковые фразы *}

					{* Пользователи из поисковых систем *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'search'}active show{/if}" id="search">
						<table class="table table-striped table-hover">
							<thead>
							<tr>
								<th class="text-start">Поисковые системы</th>
								<th class="text-start">Просмотры</th>
								<th class="text-start">Посетители</th>
							</tr>
							</thead>
							<tbody>
							{if isset($usersSearchEngine) && !empty($usersSearchEngine)}
								{foreach item=visitor from=$usersSearchEngine.data}
									<tr class="">
										<td class="text-start text-nowrap">{$visitor.dimensions.searchEngine.name}</td>
										<td class="text-start text-nowrap"><span class="fw-semibold">{$visitor.metrics.visits}</span></td>
										<td class="text-start text-nowrap"><span class="fw-semibold">{$visitor.metrics.users}</span></td>
									</tr>
								{/foreach}
							{else}
								<tr>
									<td class="text-center" colspan="3">- {general:none} -</td>
								</tr>
							{/if}
							</tbody>
						</table>
					</div>
					{* /Пользователи из поисковых систем *}

					{* Браузеры пользователей *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'browsers'}active show{/if}" id="browsers">
						{if isset($browsers) && !empty($browsers)}
							<div class="chart-container mx-3">
								<div class="chart has-fixed-height" id="pie_browser"></div>
							</div>
						{/if}
					</div>
					{* /Браузеры пользователей *}

					{* Пол и возраст пользователей *}
					<div class="tab-pane fade  {if !empty($view) && $view eq 'ages'}active show{/if}" id="ages">
						<div class="row">
							{if isset($ages) && !empty($ages)}
								<div class="col-md-6">
									<table class="table table-striped table-hover">
										<thead>
										<tr>
											<th class="text-start">Возраст</th>
											<th class="text-start">Пол</th>
											<th class="text-start">Просмотры</th>
											<th class="text-start">Посетители</th>
										</tr>
										</thead>
										<tbody>
											{foreach item=age from=$ages.data}
												<tr class="">
													<td class="text-start text-nowrap">{$age.dimensions.ageInterval.name}</td>
													<td class="text-start text-nowrap">
														{if $age.dimensions.gender.name eq 'мужской'}
															<span class="badge bg-secondary">{$age.dimensions.gender.name}</span>
														{elseif $age.dimensions.gender.name eq 'женский'}
															<span class="badge bg-info">{$age.dimensions.gender.name}</span>
														{else}
															<span class="badge bg-light text-body">{$age.dimensions.gender.name}</span>
														{/if}
													</td>
													<td class="text-start text-nowrap"><span class="fw-semibold">{$age.metrics.visits}</span></td>
													<td class="text-start text-nowrap"><span class="fw-semibold">{$age.metrics.users}</span></td>
												</tr>
											{/foreach}
										</tbody>
									</table>
								</div>
								<div class="col-md-6">
									<div class="chart-container">
										<div class="chart has-fixed-height" id="pie_age"></div>
									</div>
								</div>
							{else}
								<table class="table table-striped table-hover">
									<thead>
									<tr>
										<th class="text-start">Возраст</th>
										<th class="text-start">Пол</th>
										<th class="text-start">Просмотры</th>
										<th class="text-start">Посетители</th>
									</tr>
									</thead>
									<tbody>
									<tr><td class="text-center" colspan="4">- {general:none} -</td></tr>
									</tbody>
								</table>
							{/if}
						</div>
					</div>
					{* Пол и возраст пользователей *}

				</div>

			</div>
		</div>
	</div>


	{* Настройка yandex метрики *}
	<div id="modal_setting" class="modal fade" tabindex="-1">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Настройка yandex метрики</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				</div>

				<div class="modal-body">
					<div class="row mb-3">
						<label class="col-form-label col-lg-6">Идентификатор счетчика<br />
							<span class="p-0 fs-sm font-italic text-muted">Взять идентификатор счетчика можно <a href="https://metrika.yandex.ru/list" target="_blank">здесь</a></span>
						</label>

						<div class="col-lg-6">
							<input class="form-control" type="text" name="yandex[counterId]" placeholder="xxxxxxxxxx" value="{$yandex.counterId|default:''}">
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-form-label col-lg-6">Токен<br />
							<span class="p-0 fs-sm font-italic text-muted">Токен нужен для получение статистики (метрики)</span><br><br>
							<span class="p-0 fs-sm font-italic">Для получения токена нужно:</span>
							<ol class="list fs-sm font-italic text-muted mt-1">
								<li> Переходим на страницу <a href="https://oauth.yandex.ru/">oauth.yandex.ru</a></li>
								<li> Нажимаем "Зарегистрировать новое приложение"</li>
								<li> Вписываем название и выбираем "Получение статистики, чтение параметров своих и доверенных счетчиков"</li>
								<li> Выбираем "Подставить URL для разработки"</li>
								<li> Копируем ID приложения</li>
								<li> Переходим по ссылке: <code>https://oauth.yandex.ru/authorize?response_type=token&client_id=ВАШ_ID</code></li>
							</ol>
						</label>

						<div class="col-lg-6">
							<input type="text" class="form-control" id="token" name="yandex[token]" placeholder="xxxxxxxxxxxxxxxxxx"  value="{$yandex.token|default:''}" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-form-label col-lg-6">Показывать статистику<br />
							<span class="p-0 fs-sm font-italic text-muted">Показывать статистику за какой кол-во дней.
								<br>Если на сайте посещаемость больше 10 000 в день, <span class="text-danger">рекомендуется выбрать 30 дней</span>
							</span>
						</label>

						<div class="col-lg-6">
{*							<input class="form-control" type="text" name="yandex[days]" placeholder="30" value="{$yandex.days|default:''}">*}
							<select class="form-select select" name="yandex[days]">
								<option value="15" {if !empty($yandex.days) && $yandex.days eq 15}selected{/if}>15 дней</option>
								<option value="30" {if !empty($yandex.days) && $yandex.days eq 30}selected{/if}>30 дней</option>
								<option value="60" {if !empty($yandex.days) && $yandex.days eq 60}selected{/if}>60 дней</option>
								<option value="90" {if !empty($yandex.days) && $yandex.days eq 90}selected{/if}>90 дней</option>
								<option value="120" {if !empty($yandex.days) && $yandex.days eq 120}selected{/if}>120 дней</option>
								<option value="180" {if !empty($yandex.days) && $yandex.days eq 180}selected{/if}>180 дней</option>
								<option value="365" {if !empty($yandex.days) && $yandex.days eq 365}selected{/if}>365 дней</option>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-form-label col-lg-6">Код метрики<br />
							<span class="p-0 fs-sm font-italic text-muted">
								Для установки счетчика метрики на сайт и вывода его через Smarty, рекомендуется следовать следующему подходу:<br />
							</span>
							<ol class="list fs-sm font-italic text-muted mt-1">
								<li>Размещение счетчика: Код счетчика нужно разместить в пределах тегов <code>head</code> или <code>body</code>, как можно ближе к началу страницы для того, чтобы он загружался и активировался в первую очередь..</li>
								<li>Используйте функцию Smarty <code>smarty_function_yandex_statistics</code>,  для вывода кода метрики внутри шаблона.</li>
							</ol>
<pre class="language-php code-toolbar mt-2">
{ldelim}* Код Яндекс.Метрики *{rdelim}
{ldelim}yandex_statistics{rdelim}
</pre>

						</label>

						<div class="col-lg-6">
							<textarea rows="5" cols="3" class="form-control" name="yandex[code]">{$yandex.code|default:''}</textarea>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-sm btn-link" data-bs-dismiss="modal">{general:cancel}</button>
					<button type="button" class="btn btn-sm btn-primary button-save">{general:save}</button>
				</div>
			</div>
		</div>
	</div>
	{* /Настройка yandex метрики *}



	<script src="{$adminUrl}/assets/js/vendor/visualization/echarts/echarts.min.js"></script>
	<script>
		{literal}
		const EchartsPiesDonuts = function() {

			let saveSettings = function() {
				document.querySelector('.button-save').addEventListener('click', function() {
					// Собираем данные из полей
					const data = {
						counterId: document.querySelector('input[name="yandex[counterId]"]').value,
						token: document.querySelector('input[name="yandex[token]"]').value,
						// days: document.querySelector('input[name="yandex[days]"]').value,
						days: document.querySelector('select[name="yandex[days]"]').value,
						code: document.querySelector('textarea[name="yandex[code]"]').value
					};

					// Отправляем данные на сервер с помощью fetch
					fetch('{/literal}{$adminUrl}{literal}/yandex?action=save', { method: 'POST', headers: {
							'Content-Type': 'application/json',
							'X-Requested-With': 'XMLHttpRequest'
						},
						body: JSON.stringify(data) // Преобразуем объект data в JSON
					}).then(response => response.json()).then(result => {
						// Обработка успешного ответа
						if (result.status == 200) {
							new Noty({ text: result.message, type: result.type }).show();
							// Закрываем модальное окно
							let modal = new bootstrap.Modal(document.getElementById('modal_setting'));
							modal.hide();

							setTimeout(function() {
								window.location.reload();
							}, 1500);
						} else {
							alert('Ошибка при сохранении настроек: ' + result.message);
						}
					}).catch(error => {
						// Обработка ошибок
						console.error('Ошибка:', error);
						alert('Произошла ошибка при сохранении настроек.');
					});
				});
			}


			let statisticsPies = function() {
				if (typeof echarts == 'undefined') {
					console.warn('Warning - echarts.min.js is not loaded.');
					return;
				}

				let pieAge = '';
				let pieBrowser = '';
				const pie_browser_element = document.getElementById('pie_browser');
				const pie_age_element = document.getElementById('pie_age');

				// Basic pie chart
				{/literal} {if isset($browsers) && !empty($browsers)}{literal}
				if (pie_browser_element) {
					pieBrowser = echarts.init(pie_browser_element);
					pieBrowser.setOption({
						color: ['#2ec7c9','#b6a2de','#5ab1ef','#ffb980','#d87a80', '#8d98b3','#e5cf0d','#97b552','#95706d','#dc69aa',
							'#07a2a4','#9a7fd1','#588dd5','#f5994e','#c05050', '#59678c','#c9ab00','#7eb00a','#6f5553','#c14089'
						],
						textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
						tooltip: { trigger: 'item', backgroundColor: 'rgba(255,255,255,0.95)', padding: [20, 15], textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif'}, formatter: "{a} <br/>{b}: {c} ({d}%)" },
						legend: {
							orient: 'vertical', top: 'center', left: 0,
							data: [{/literal}{foreach item=visitor from=$browsers.data name=browsers}"{$visitor.dimensions.browser.name|truncate:20}"{if !$smarty.foreach.browsers.last},{/if} {/foreach}{literal}],
							itemHeight: 18, itemWidth: 8
						},

						// Add series
						series: [{ name: 'Браузер', type: 'pie', radius: '70%', itemStyle: { normal: { borderWidth: 1, borderColor: '#fff' } },
							data: [
								{/literal}{foreach item=visitor from=$browsers.data name=browsers}{if !$smarty.foreach.browsers.last},{/if} {literal}
								{ value: {/literal}{$visitor.metrics.visits}{literal}, name: '{/literal}{$visitor.dimensions.browser.name|truncate:20}{literal}' }
								{/literal}{if !$smarty.foreach.browsers.last},{/if} {/foreach}{literal}
							]
						}]
					});

				}
				{/literal}{/if}{literal}

				{/literal} {if isset($ages) && !empty($ages)}{literal}
				if (pie_age_element) {
					pieAge = echarts.init(pie_age_element);
					pieAge.setOption({

						color: [ '#80FFA5', '#37A2FF', '#FF0087', '#FFBF00',
							'#7eb00a', '#dc69aa', '#b6a2de',  '#9a7fd1',
							'#07a2a4', '#2ec7c9', '#5ab1ef', '#588dd5'
						],

						textStyle: { fontFamily: 'Roboto, Arial, Verdana, sans-serif', fontSize: 13 },
						tooltip: {
							trigger: 'item',
							backgroundColor: 'rgba(255,255,255,0.95)',
							padding: [10, 15],
							textStyle: { fontSize: 13, fontFamily: 'Roboto, sans-serif' },
							formatter: "{b} &nbsp; {c} ({d}%)"
						},
						legend: {
							orient: 'vertical', top: 'top', left: 0,
							data: [{/literal}{foreach item=age from=$ages.data name=age}"{$age.dimensions.ageInterval.name}"{if !$smarty.foreach.ages.last},{/if} {/foreach}{literal}],
						},
						series: [{
							type: 'pie', radius: '70%', itemStyle: { normal: { borderWidth: 1, borderColor: '#fff' } },
							data: [
								{/literal}{foreach item=age from=$ages.data name=ages}{if !$smarty.foreach.ages.last},{/if} {literal}
								{ value: {/literal}{$age.metrics.visits}{literal}, name: '{/literal}{$age.dimensions.ageInterval.name}{literal}' }
								{/literal}{if !$smarty.foreach.ages.last},{/if} {/foreach}{literal}
							]
						}]
					});
				}
				{/literal}{/if}{literal}



				// Resize charts
				let triggerChartResize = function() {
					pie_browser_element && pieBrowser.resize();
					pie_age_element && pieAge.resize();
				};

				$(document).on('click', '.sidebar-control', function() {
					setTimeout(function () {
						triggerChartResize();
					}, 0);
				});

				let resizeCharts;
				window.onresize = function () {
					clearTimeout(resizeCharts);
					resizeCharts = setTimeout(function () {
						triggerChartResize();
					}, 200);
				};
			};

			return {
				init: function() {
					saveSettings();
					statisticsPies();
				}
			}
		}();

		document.addEventListener('DOMContentLoaded', function() {
			EchartsPiesDonuts.init();
		});
		{/literal}

	</script>

