<form class="form-validation" method="post" enctype="multipart/form-data" novalidate>
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/managers"}

    {capture name="breadcrumb"}
	    <a href="{$adminUrl}/managers" class="breadcrumb-item">{$title}</a>
        {if isset($action) && $action == 'edit'}
		    <span class="breadcrumb-item active">{managers:editing}</span>
        {else}
		    <span class="breadcrumb-item active">{managers:adding}</span>
        {/if}
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="profile-cover">
		<div class="profile-cover-img" style="background-image: url('/admin/assets/images/wallpaper_3.jpg')"></div>
		<div class="d-flex align-items-center text-center text-lg-start flex-column flex-lg-row position-absolute start-0 end-0 bottom-0 mx-3 mb-3">

			<div class="me-lg-3 mb-2 mb-lg-0">
				<div class="profile-thumb">
					<img src="{if isset($user.image.medium)}{$user.image.medium}{else}/admin/assets/images/no_images.jpg{/if}" class="img-thumbnail rounded-circle shadow" width="100" height="100" alt="">
				</div>
			</div>


			<div class="profile-cover-text text-white">
				<h1 class="mb-0">{$user.fullName|default:''}</h1>
				<span class="d-block">{$user.groupName|default:''}</span>
			</div>

			<div class="ms-lg-auto mt-2 mt-lg-0">
				<ul class="d-inline-flex">
					<button class="btn btn-light btn-upload read-more"
					        data-type="image"
					        data-path="admin"
					        data-action="read_more"><i class="ph-image me-2"></i> {if isset($user.image.medium)}{general:changeFile}{else}{general:uploadFile}{/if}</button>
				</ul>
			</div>
		</div>
	</div>

	<div class="navbar navbar-expand-lg border-bottom py-2">
		<div class="container-fluid">
			<div class="text-center d-lg-none w-100">
				<button type="button" class="navbar-toggler dropdown-toggle" data-toggle="collapse" data-target="#navbar-second">
					<i class="icon-menu7 mr-2"></i>
					Profile navigation
				</button>
			</div>

			<ul class="nav navbar-nav flex-row flex-fill">
                {if $adminManager.userType eq $DEVELOPER}
					<li class="nav-item me-1">
						<a href="javascript:void('');" class="navbar-nav-link navbar-nav-link-icon rounded" data-bs-toggle="collapse" data-bs-target="#collapse-notice"><i class="icon-stack-text me-2"></i>Заметки</a>
					</li>
                {/if}
			</ul>
		</div>
	</div>

    <!-- Content area -->
    <div class="content">
        <div class="row">
	        <div class="col-md-12">
		        <div class="card collapse" id="collapse-notice">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">Заметки</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body">
					        <textarea class="form-control p-2" style="width:100%;height:200px;" readonly>{$user.notice|default:'' nofilter}</textarea>
				        </div>
			        </div>
		        </div>
	        </div>

	        <div class="col-md-8">
		        <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:tabs:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body">
					        <div class="row">
						        <div class="col-md-6">
							        <div class="form-group mb-3">
								        <label class="form-label is-visible {if isset($errors.fullName)}text-danger{/if}">{managers:fullname}</label>
								        <input type="text" class="form-control" autocomplete="off" id="fullName" name="user[fullName]" value="{$user.fullName|default:''}" required/>
							        </div>
							        <div class="form-group mb-3">
								        <label class="form-label is-visible {if isset($errors.login_empty) || isset($errors.login_exists) || isset($errors.loginName)}text-danger{/if}">{managers:loginname}</label>
								        <input type="text" class="form-control" autocomplete="off" id="loginName" name="user[loginName]" value="{$user.loginName|default:''}" required/>
							        </div>
							        <div class="form-group mb-3">
								        <label for="email" class="form-label is-visible {if isset($errors.email)}text-danger{/if}">{general:email}</label>
								        <input type="email" class="form-control" autocomplete="off" id="email" name="user[email]" value="{$user.email|default:''}"/>
							        </div>
						        </div>

						        <div class="col-md-6">
							        <div class="form-group mb-3">
								        <label class="form-label is-visible">{managers:phone}</label>
								        <input type="tel" class="form-control" autocomplete="off" id="phone" data-mask="{$config.phone_mask}" name="user[phone]" value="{$user.phone|default:''}" />
							        </div>
							        <div class="form-group mb-3">
								        <label for="email" class="form-label is-visible">{managers:address}</label>
								        <input type="text" class="form-control maxlength-threshold" maxlength="100" autocomplete="off" id="address" name="user[address]" value="{$user.address|default:''}"/>
							        </div>

                                    {if !empty($user.userId)}
								        <div class="form-group mb-3">
									        <label class="form-label is-visible {if isset($errors.password)}text-danger{/if}">{managers:newPassword}</label>
									        <div class="input-group">
										        <input  type="text" class="form-control group-indicator" id="newPassword" name="user[newPassword]" />
										        <span class="input-group-text password-indicator-group">No password</span>
									        </div>
								        </div>
                                    {else}
								        <div class="form-group mb-3">
									        <label for="password" class="form-label is-visible {if isset($errors.password)}text-danger{/if}">{managers:password}</label>
									        <div class="input-group">
										        <input type="text" class="form-control group-indicator" id="password" name="user[password]"/>
										        <span class="input-group-text password-indicator-group">No password</span>
									        </div>
								        </div>
                                    {/if}

							        <button type="button" class="btn btn-info generate-group">Сгенерировать пароль</button>

						        </div>
					        </div>
				        </div>

			        </div>
		        </div>
	        </div>

	        <div class="col-md-4">
		        <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body border-top-0">
					        <div class="form-group mb-3">
						        <div class="form-check form-switch mb-2">
							        <input type="checkbox" class="form-check-input form-check-input-success" id="receiveEmails" name="user[receiveEmails]" value="1" {if isset($user.receiveEmails) AND $user.receiveEmails eq 1}checked{/if} >
							        <label class="form-check-label" for="receiveEmails">Не получать писем</label>
						        </div>
					        </div>

							<div class="form-group mb-3">
								<label class="form-label {if isset($errors.status_empty)}text-danger{/if}">{general:status}</label>
								{html_options options=$statuses selected=$user.status|default:1 id="status" name="user[status]" class="form-control select"}
							</div>

					        <div class="form-group mb-3">
						        <label class="form-label {if isset($errors.no_more_admins) OR isset($errors.no_more_developers) OR isset($errors.access_level_empty)}text-danger{/if}">Группа</label>
                                {html_options options=$groups selected=$user.groupId|default:2 id="groupId" name="user[groupId]" class="form-control select"}
					        </div>
				        </div>

                        {if isset($user.addedOn) && isset($user.last_login)}
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{managers:registration}</li>
                                    <li>{managers:activity}</li>
						        </ul>
					        </div>
					        <div class="hstack gap-1">
						        <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{$user.addedOn|date_format:"%d.%m.%Y %H:%M"}</li>
                                    <li>{$user.last_login|date_format:"%d.%m.%Y %H:%M"}</li>
						        </ul>
					        </div>
				        </div>
				        {/if}
			        </div>
		        </div>
	        </div>

            {* права доступа *}
	        <div class="col-md-12 text-center">
                {if isset($user.userId)}<input type="hidden" class="form-control" id="id" name="id" value="{$user.userId}">{/if}
		        {$smarty.capture.buttons nofilter}
	        </div>

        </div>

    </div>

</form>

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
$(document).ready(function () {

    {if isset($errors.login_empty)}     new Noty({ text: '{managers:errors:13}', type: 'error' }).show(); {/if}
    {if isset($errors.login_exists)}    new Noty({ text: '{managers:errors:0}', type: 'error' }).show(); {/if}
    {if isset($errors.user_not_found)}  new Noty({ text: '{managers:errors:1}', type: 'error' }).show();  {/if}
    {if isset($errors.loginName)}       new Noty({ text: '{managers:errors:2}', type: 'error' }).show(); {/if}
    {if isset($errors.fullName)}        new Noty({ text: '{managers:errors:3}', type: 'error' }).show(); {/if}
    {if isset($errors.password)}        new Noty({ text: '{managers:errors:4}', type: 'error' }).show(); {/if}
    {if isset($errors.not_saved)}       new Noty({ text: '{managers:errors:5}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_admins)}  new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); {/if}

    {if isset($errors.developer_status)}    new Noty({ text: '{managers:errors:9}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_developers)}  new Noty({ text: '{managers:errors:10}', type: 'error' }).show(); {/if}
    {if isset($errors.access_level_empty)}  new Noty({ text: '{managers:errors:16}', type: 'error' }).show(); {/if}
    {if isset($errors.permission)}          new Noty({ text: '{managers:errors:11}', type: 'error' }).show(); {/if}
    {if isset($errors.invalid_email)}       new Noty({ text: '{managers:errors:12}', type: 'error' }).show(); {/if}
    {if isset($errors.image_not_saved)}     new Noty({ text: '{managers:errors:8}', type: 'error' }).show();{/if}
    {if isset($errors.status_empty)}     new Noty({ text: 'Нужно указать статус', type: 'error' }).show();{/if}

    {if isset($messages.saved)} new Noty({ text: '{managers:messages:0}', type: 'success' }).show(); {/if}
});


</script>
