
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/subscriber?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
	{/capture}
	{capture name="breadcrumb"}
		<a href="{$adminUrl}/subscribers" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/subscribers"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

	    <div class="row">
	        <div class="col-md-12">

	            <div class="card">

		            <div class="table-responsive">
	                    <table class="table table-xs table-togglable table-striped table-hover" id="subscribers">
		                    <thead>
		                        <tr>
		                            <th class="text-start" width="30">{users:table:date}</th>
		                            <th data-toggle="true">{users:table:email}</th>
		                            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($users)}
		                    <tbody>
		                        {foreach item=user from=$users name=users}
		                        <tr id="subscriber-{$user.userId}">
		                            <td class="text-start text-nowrap">{$user.registered nofilter}</td>
		                            <td class="text-start">{$user.email}</td>
		                            <td class="text-center">
										<button class="dropdown-item text-danger" onclick="remove({$user.userId}, '{$user.email}', 'subscribers');"><i class="ph-trash me-2"></i></button>
		                            </td>
		                        </tr>
		                        {/foreach}

		                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="6">- {general:none} -</td></tr></tbody>
		                    {/if}
		                </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/subscribers" params="{$buildQueryString}"}

	            </div>
	        </div>

	    </div>
	</div>




