<?php

namespace Mnv\Core\Database;

interface ConnectionInterface
{
    /**
     * @param null $argument
     *
     * @return mixed
     */
    public function getValue($argument = null);

    /**
     * @param null $type
     * @param null $argument
     *
     * @return mixed
     */
    public function get($type = null, $argument = null);

    /**
     * @param null $type
     * @param null $argument
     *
     * @return mixed
     */
    public function getAll($type = null, $argument = null);

    /**
     * @param array $data
     * @param bool  $type
     *
     * @return mixed
     */
    public function update(array $data, bool $type = false);

    /**
     * @param array $data
     * @param bool  $type
     *
     * @return mixed
     */
    public function insert(array $data, bool $type = false);

    /**
     * @param array $data
     * @param false $type
     *
     * @return mixed
     */
    public function replace(array $data, bool $type = false);

    /**
     * @param string $field
     * @param int $amount
     * @param bool  $type
     *
     * @return mixed
     */
    public function increment(string $field, int $amount, bool $type = false);

    /**
     * @param bool $type
     *
     * @return mixed
     */
    public function delete(bool $type = false);

    /**
     * @param  string  $value
     * @param $key
     *
     * @return mixed
     */
    public function pluck(string $value, $key = null);

    /**
     * @param  callable|null  $callback
     * @param $default
     *
     * @return mixed
     */
    public function first(callable $callback = null, $default = null);
}
