<?php

namespace Mnv\Core;

use Mnv\Core\Singleton\SingletonTrait;

/**
 * Class Maps
 * @package Mnv\Core
 */
class Maps
{
    use SingletonTrait;

    /** @var array|null Stores the map values */
    private ?array $_mapValues = null;

    /**
     * Maps constructor.
     * Initializes the map values by loading them from the database.
     */
    public function __construct()
    {
        $this->loadMapValues();
    }

    /**
     * Loads map values from the database if they haven't been loaded already.
     */
    private function loadMapValues()
    {
        if ($this->_mapValues === null) {
            $this->_mapValues = connect('maps')->select('codename, value')->pluck('value', 'codename');
        }
    }

    /**
     * Retrieves the map values.
     *
     * @return array|null The map values or null if not loaded.
     */
    public function getMapValues(): ?array
    {
        return $this->_mapValues;
    }

}