<?php

namespace Mnv\Core\Security\Csrf;

use Mnv\Core\Security\Csrf\Interfaces\SessionProvider;

/**
 * Class SecurityCsrfSessionProvider
 * @package Mnv\Core\Security\Csrf
 */
class SecurityCsrfSessionProvider implements SessionProvider
{
    /**
     * Get a session value.
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key)
    {
        return $_SESSION[$key] ?? null;
    }

    /**
     * Set a session value.
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, $value)
    {
        $_SESSION[$key] = $value;
    }
}
