<?php

namespace Mnv\Models\Cars;

use Mnv\Core\Model;
use Mnv\Core\Test\Logger;
use Mnv\Core\Uploads\ImageSizes;
use Mnv\Http\Request;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotInsertContentException;
use Mnv\Models\Exceptions\NotUpdateContentException;
use Mnv\Models\Exceptions\NotContentApproveException;


/**
 * Class CarModels
 * @package Mnv\Models\Cars
 */
class CarModels extends Model
{
    /** @var string */
    protected string $table = 'car_models';

    /** @var string  */
    protected string $table_image = 'car_model_images';

    /** @var string  */
    protected string $primaryKey = 'modelId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    /** @var string  */
    protected string $columns = 'modelId, sectionId, title, alias, url, publishedOn, orderBy, isFeatured, status, summary';

    public $field;

    /** @var array $image */
    public $image = [];

    /** @var int $imageId */
    public int $imageId;

    public string $typeContent;

    public $contentIds;
    public $modification;


    public $gear_types = array(
        ''         => 'Выберите привод',
        'forward'   => 'Передний',
        'rear'      => 'Задний',
        '4WD'       => 'Полный'
    );
    public $test_drives = array(
        '0'   => 'Нет',
        '1'   => 'Да'
    );
    public $menus = array(
        'N'   => 'Нет',
        'Y'   => 'Да'
    );
    public $specials = array(
        'D' => 'Выбрать особенность',
        'N' => 'Новинка',
        'S' => 'Акция',
    );

    public $paymentMethods = [
        1 => ['key' => 'installment', 'name' => 'Рассрочка'],
        2 => ['key' => 'credit', 'name' => 'Кредит'],
        3 => ['key' => 'leasing', 'name' => 'Лизинг'],
        4 => ['key' => 'cash', 'name' => 'Наличный / Безналичный расчет'],
    ];

    public $payments;
    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');
        $this->data         = $request->get('model');
        $this->field        = $request->get('field');
        $this->contentIds   = $request->get('articleIds');
        $this->modification = $request->get('modification');
        $this->payments = $request->get('payments');
    }

    /** фильтрация / сортировка */
    protected function sorting(): void
    {
        global $SECTIONS;

        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('title', "%" . $this->filter['query'] . "%")->orLike('content', "%" . $this->filter['query'] . "%")->orLike('keywords',"%" . $this->filter['query'] . "%");
            });
        }

        if (!empty($this->filter['section']) && !empty($SECTIONS[$this->filter['section']])) {
            $sectionIds = array($this->filter['section']);
            if (!empty($SECTIONS[$this->filter['section']]['allChildren'])) {
                $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filter['section']]['allChildren']);
            }
            connect()->in('sectionId', $sectionIds);
        }

        if (!empty($this->filter['dateStart']) && !empty($this->filter['dateEnd'])) {
            connect()->between('publishedOn', $this->filter['dateStart'], $this->filter['dateEnd']);
        }

    }

    /** Получение всех статей */
    public function all($limit, $page)
    {
        /** фильтрация / сортировка */
        $this->sorting();

        return parent::all($limit, $page);
    }

    /** Получение кол-во контента */
    public function total(): void
    {
        /** фильтрация / сортировка */
        $this->sorting();
        parent::total();
    }

    /**
     * Проверка на совпадение и получение fileName
     *
     * @param string|null $fileName
     * @return int|mixed|string|null
     */
    public function checkFileName(?string $fileName)
    {
        if (empty($fileName)) {
            $maxId = $this->getMaxValue($this->primaryKey);
            return $maxId ? $maxId + 1 : 1;
        }

        if (!empty($this->id)) connect()->where($this->primaryKey,'<>', $this->id);
        if ($fileName = connect()->table($this->table)->select('fileName')->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
            return $fileName;
        }

        return null;
    }


    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');
        $data['publishedOn']  = adjustTime(date('Y-m-d H:i:s', strtotime($data['publishedOn'])),  true);

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect()->table($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {

            return $this->update($data);
        }

        return false;
    }

    /**
     * @return bool
     * @throws NoContentException
     * @throws \Mnv\Core\Database\Throwable\DatabaseException
     * @throws \Mnv\Models\Exceptions\NotFoundException
     */
    public function remove(): bool
    {
        if (parent::remove()) {
            connect($this->table_image)->where($this->primaryKey, $this->id)->delete();
            connect('car_model_colors')->where($this->primaryKey, $this->id)->delete();
            connect('car_modifications')->where($this->primaryKey, $this->id)->delete();
            // удаление инфоблоков для страницы модели
            $equipmentIds = connect('car_equipments')->where($this->primaryKey, $this->id)->pluck('equipmentId', 'equipmentId');
            if (!empty($equipmentIds)) {
                connect('car_equipments')->in('equipmentId', $equipmentIds)->delete();
                connect('car_equipment_images')->in('equipmentId', $equipmentIds)->delete();
                connect('car_equipment_colors')->in('equipmentId', $equipmentIds)->delete();
            }

            $blockIds = connect('car_model_blocks')->where($this->primaryKey, $this->id)->pluck('blockId', 'blockId');
            if (!empty($blockIds)) {
                connect('car_model_blocks')->in('blockId', $blockIds)->delete();
                connect('car_model_block_images')->in('blockId', $blockIds)->delete();
            }

            return true;
        }

        return false;
    }


    /**
     * Сортировка контента
     *
     * @param $ids
     * @param $articleIds
     */
    public function reorder($ids, $articleIds): void
    {
        foreach ($articleIds as $i => $articleId) {
            connect()->table($this->table)->where($this->primaryKey, $ids[$i])->update(['orderBy' => $articleId]);
        }
    }

    /**
     * Групповые действия
     * @param $group_action
     */
    public function group($group_action): void
    {
        if ($group_action === 'status') {
            if ($this->data = $this->get()) {
                $contentUpdate['status'] = ($this->data['status'] === 'V') ? 'H' : 'V';
                $this->statusContent($contentUpdate);
            }

        } else if ($group_action === 'remove') {
            if ($this->data = $this->get()) {
                $this->removeContent();
            }
        }
    }

    /**
     * Обновление статуса контента
     *
     * @param $contentUpdate
     * @return bool
     */
    public function statusContent($contentUpdate): bool
    {
        if (connect()->table($this->table)->where($this->primaryKey, $this->id)->update($contentUpdate)) {
            return true;
        }

        return false;
    }

    /** Групповое удаление контента */
    public function removeContent(): bool
    {
        /** удаление контента и удаление записей из базы данных прикрепленных картинок и комментариев к этому контенту */
        if (connect()->table($this->table)->where($this->primaryKey, $this->id)->delete()) {
            connect()->table($this->table_image)->where($this->primaryKey, $this->id)->delete();

            return true;
        }

        return false;
    }


    /** MODEL COLORS  */
    public function addColor($color): void
    {
        if (empty($color['colorId'])) $color['colorId'] = 0;

        $color['orderBy'] = connect('car_model_colors')->max('orderBy')->where('type', $color['type'])->where('modelId', $this->id)->getValue() + 1;
        connect('car_model_colors')->insert($color);
    }

    public function updateColor($imageId, $color): void
    {
        connect('car_model_colors')->select('*')->where('imageId', $imageId)->update($color);
    }

    public function deleteColor($imageId): bool
    {
        if (connect('car_model_colors')->where('imageId', $imageId)->delete()) {
            return true;
        }

        return false;
    }

    /**
     * Сортировать
     *
     * @param $imageId
     * @param $index
     * @return bool
     */
    public function sortByColors($imageId, $index): bool
    {
        if (!empty($imageId) && !empty($index)) {
            connect('car_model_colors')->where('imageId', $imageId)->update(['orderBy' => $index]);

            return true;
        }

        return false;
    }


    public function getModeBColors()
    {
        if (isset($this->id) && $this->id > 0) {
            $images = connect()->table('car_model_colors')->select('*')->where('type', 'bcolors')->where('modelId', $this->id)->orderBy('orderBy ASC')->getAll('array');
            collect($images)->map(function ($item)  {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    $this->data['bcolors'][] = ImageSizes::init()->get($item, $file);
                } else {
                    $this->data['bcolors'][] = $item;
                }
            })->all();

        }

        return $this;
    }

    public function getModeIColors()
    {
        if (isset($this->id) && $this->id > 0) {
            $images = connect()->table('car_model_colors')->select('*')->where('type', 'icolors')->where('modelId', $this->id)->orderBy('orderBy ASC')->getAll('array');
            collect($images)->map(function ($item)  {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    $this->data['icolors'][] = ImageSizes::init()->get($item, $file);
                } else {
                    $this->data['icolors'][] = $item;
                }
            })->all();
        }

        return $this;
    }
    /** /MODEL COLORS  */

    /** MODIFICATION */
    public function getModification(): bool
    {

        if (is_array($this->modification)) {
           $modifications = connect('car_modifications')->where('modelId', $this->id)->where('name', $this->modification['name'])->get();
           if (!empty($modifications)) {
               return false;
           }

           $this->modification['modelId'] = $this->id;
           $this->modification['orderBy'] = connect('car_modifications')->max('orderBy')->where('modelId', $this->id)->getValue() + 1;
           if ($modificationId = connect('car_modifications')->insert($this->modification)) {

               $this->modification = connect('car_modifications')->where('modificationId', $modificationId)->get('array');
               return true;
           }
        }
        return false;
    }

    /**
     * Модификации автомобиля
     * получить модификацию для данной модели `$modelId`
     *
     * @return array
     */
    public function getModifications(): ?array
    {
        return connect('car_modifications')->select('modificationId, name')->where('modelId', $this->id)->where('status', 'V')->orderBy('orderBy ASC')->getAll('array');
    }


    /** STATIC */

    public static function getModels($sectionIds = null): ?array
    {
        if (!empty($sectionIds)) {
            connect()->in('sectionId', $sectionIds);
        }
       return connect()->table('car_models')->where('status', 'V')->pluck('title', 'modelId');
    }

    public static function getModel($modelId): ?string
    {
        return connect()->table('car_models')->select('title')->where('modelId', $modelId)->getValue();
    }

    public static function getSelectModels(): ?array
    {
        $models = array('0' => 'Выберите модель');
        $result = connect()->table('car_models')->where('status', 'V')->pluck('title', 'modelId');
        if (!empty($result)) {
            $models = $models + $result;
        }

        return $models;
    }

}