<?php


namespace Mnv\Models\Cars;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Colors
 * @package Mnv\Models\Cars
 */
class Colors extends Model
{
    /** @var string  */
    protected string $table = 'car_colors';

    /** @var string  */
    protected string $primaryKey = 'colorId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

   /** @var array|mixed  */
    public $modelIds = [];

    /** @var array|mixed  */
    public $colorIds = [];

    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');
        $this->data         = $request->get('color');
        $this->modelIds     = $request->get('modelIds');
        $this->colorIds     = $request->get('ids');
    }

    protected function sortBy()
    {
        if (!empty($this->filter['colorType'])) {
            connect()->where('colorType', $this->filter['colorType']);
        }
    }
    public function all($limit, $page)
    {
        $this->sortBy();

        return parent::all($limit, $page);
    }

    public function total(): void
    {
        $this->sortBy();

        parent::total();
    }

    public function prepare(array $data, $colorType, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect()->table($this->table)->max('orderBy')->where('colorType', $colorType)->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    public function updateColorModels($colorType): void
    {
        connect('car_color_model')->where('colorId', $this->id)->delete();

        if (is_array($this->modelIds)) {
            foreach($this->modelIds as $modelId) {
                connect()->table('car_color_model')->insert(['colorId' => $this->id, 'modelId' => $modelId, 'type' => $colorType]);
            }
        }
    }

    /**
     * @return bool
     */
    public function remove(): bool
    {
       if (parent::remove()) {
           connect()->table('car_color_model')->where('colorId', $this->id)->delete();
           return true;
       }

       return false;
    }


    /**
     * Получить комплектации цвета
     *
     * @param $colorId
     * @return array|null
     */
    public function getColorModels($colorId): ?array
    {
        return connect('car_color_model')->usingJoin('car_models', 'modelId')->select('*')
            ->where('colorId', $colorId)->orderBy('modelId DESC')->pluck('title', 'modelId');
    }

    /**
     * Получить IDS комплектации цвета
     *
     * @param $colorId
     * @return array
     */
    public function getSelectedModels($colorId): ?array
    {
        return connect('car_color_model')->select('modelId')->where('colorId', $colorId)->pluck('modelId', 'modelId');
    }



    public function checkFileName(string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }



    /** STATIC */

    /**
     * Получить комплектации цвета
     *
     * @param $modelId
     * @return array|null
     */
    public static function getModelColors($modelId, $type): ?array
    {
        if (!empty($modelId) && $modelId > 0) {
            connect()->where('modelId', $modelId);
        }
        return connect('car_color_model')->usingJoin('car_colors AS cc', 'colorId')->where('colorType', $type)->orderBy('colorId ASC')->keyBy('colorId');
    }



}