<?php

namespace Mnv\Models\Cars;


use Mnv\Core\Model;
use Mnv\Core\Uploads\ImageSizes;
use Mnv\Http\Request;

/**
 * Class Products
 * @package Mnv\Models\Contents
 */
class Equipments extends Model
{

    /** @var string  */
    protected string $table        = 'car_equipments';

    protected string $table_image  = 'car_equipment_images';

    protected string $primaryKey = 'equipmentId';

    protected string $orderBy = 'publishedOn ASC';

    protected string $columns = 'equipmentId, modelId, modificationId, sectionId, title, publishedOn, orderBy, status, price, oldPrice, monthPay, inStock';

    protected $section;
    protected $SECTIONS;


    public $image;

    public $imageId;

    public $modificationIds;
    public $specifications;
    public $equipmentIds;
    public $modelId;
    public $options;
    /**
     * Articles constructor.
     */
    public function __construct(Request $request)
    {
        $this->id               = $request->get('id');
        $this->data             = $request->get('equipment');
        $this->equipmentIds     = $request->get('equipmentIds');
        $this->specifications   = $request->get('specifications');
        $this->modificationIds  = $request->get('modificationIds');
        $this->modelId          = $request->get('modelId');
        $this->options          = $request->get('options');

    }

    /**
     * фильтрация / сортировка контента
     */
    private function sorting(): void
    {

        global $SECTIONS;

        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['model_id'])) {
            connect()->where('modelId', $this->filter['model_id']);
        }

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('title', "%" . $this->filter['query'] . "%")->orLike('content', "%" . $this->filter['query'] . "%");
            });
        }

        if (!empty($this->filter['section']) && !empty($SECTIONS[$this->filter['section']])) {
            $sectionIds = array($this->filter['section']);
            if (!empty($SECTIONS[$this->filter['section']]['allChildren'])) {
                $sectionIds = array_merge($sectionIds, $SECTIONS[$this->filter['section']]['allChildren']);
            }
            connect()->in('sectionId', $sectionIds);
        }

    }

    public function all(int $limit, int $page)
    {
        /** фильтрация / сортировка */
        $this->sorting();

        return parent::all($limit, $page);
    }

    public function total(): void
    {
        /** фильтрация / сортировка */
        $this->sorting();

        parent::total();
    }

    /**
     * Проверка на совпадение и получение fileName
     *
     * @param string|null $fileName
     * @return int|mixed|string|null
     */
    public function checkFileName(?string $fileName)
    {
        if (empty($fileName)) {
            $maxId = $this->getMaxValue($this->primaryKey);
            return $maxId ? $maxId + 1 : 1;
        }

        if (!empty($this->id)) {
            connect()->where($this->primaryKey, '<>', $this->id);
        }
        if ($fileName = connect()->table($this->table)->select('fileName')->where('LOWER(fileName)', strtolower($fileName))->getValue()) {
            return $fileName;
        }

        return null;
    }

    public function prepare(array $data, int $managerId): bool
    {

        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');
        $data['publishedOn']  = adjustTime(date('Y-m-d H:i:s', strtotime($data['publishedOn'])),  true);

        if (empty($this->id)) {

            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = connect()->table($this->table)->max('orderBy')->getValue() + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }


    /** OPTIONS  */

    public function getEquipmentOptions()
    {
        if (!empty($this->id)) {
            $optionIds = connect('car_options_value')->select('optionId')->where($this->primaryKey, $this->id)->getAll('array');
            $this->data['optionIds'] = array_column($optionIds, 'optionId', 'optionId');
        }
        return $this;
    }


    /**
     * ПОЛУЧИТЬ свойства и опции
     * @return array
     */
    public function getOptions($modelId): ?array
    {
        $options = connect('car_options AS co')->leftJoin('car_option_models AS com', 'com.optionId', '=', 'co.optionId')
            ->select('co.optionId, co.name')->where('com.modelId', $modelId)->whereNull('co.parentId',  false)->orderBy('co.orderBy ASC')->getAll('array');


        return collect($options)->map(function ($option) {
            $option['properties'] = connect('car_options')->select('optionId, name')->where('parentId', $option['optionId'])->whereNull('parentId',  true)->orderBy('orderBy ASC')->getAll('array');

            return $option;
        })->all();
    }

    public function updateOptions()
    {
        connect()->table('car_options_value')->where($this->primaryKey, $this->id)->delete();

        if (is_array($this->options)) {
            foreach($this->options as $option) {
                if (isset($option['optionIds'])) {
                    foreach ($option['optionIds'] as $optionId) {
                      connect()->table('car_options_value')->insert(['optionId' => $optionId, 'parentId' => $option['parentId'], $this->primaryKey => $this->id]);
                    }
                }
            }
        }
    }
    /** OPTIONS  */


    /** EQUIPMENTS COLORS  */
    public function addColor($color): void
    {
        if (empty($color['colorId'])) $color['colorId'] = 0;

        $color['orderBy'] = connect('car_equipment_colors')->max('orderBy')->where('type', $color['type'])->where('equipmentId', $this->id)->getValue() + 1;
        connect('car_equipment_colors')->insert($color);
    }

    public function updateColor($imageId, $color): void
    {
        connect('car_equipment_colors')->select('*')->where('imageId', $imageId)->update($color);
    }

    public function deleteColor($imageId): bool
    {
        if (connect('car_equipment_colors')->where('imageId', $imageId)->delete()) {
            return true;
        }

        return false;
    }

    public function getBColors()
    {
        $colorIds = [];
        if ($equipments = connect('car_equipment_colors')->select('equipmentId, colorId')->orderBy('orderBy', 'ASC')->where('type', 'bcolors')->where('equipmentId', $this->id)->indexKey('colorId')->getAllIndexes('array')) {
            foreach ($equipments as $id => $val) {
                $colorIds[$id] = $id;
            }
            $bColors = connect()->table('car_colors')->where('colorType', 'bcolors')->in('colorId', $colorIds)->orderBy('orderBy', 'ASC')->getAll('array');
            return $bColors;
        }

        return null;
    }

    /**
     * Сортировать
     *
     * @param $imageId
     * @param $index
     * @return bool
     */
    public function sortByColors($imageId, $index): bool
    {
        if (!empty($imageId) && !empty($index)) {
            connect('car_equipment_colors')->where('imageId', $imageId)->update(['orderBy' => $index]);

            return true;
        }

        return false;
    }


    public function getIColors()
    {
        if (($colorIds = connect('car_equipment_colors')->select('colorId')->orderBy('orderBy', 'ASC')->where('type', 'icolors')->where('equipmentId', $this->id)->indexKey('colorId')->valueKey('colorId')->getAllIndexes('array'))
            && $iColors = connect()->table('car_colors')->where('colorType', 'icolors')->in('colorId', $colorIds)->orderBy('orderBy', 'ASC')->getAll()) {
            return $iColors;
        }

        return null;
    }

    public function getModeBColors()
    {
        if (isset($this->id) && $this->id > 0) {
            $images = connect()->table('car_equipment_colors')->select('*')->where('type', 'bcolors')->where('equipmentId', $this->id)->orderBy('orderBy ASC')->getAll('array');
            collect($images)->map(function ($item)  {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    $this->data['bcolors'][] = ImageSizes::init()->get($item, $file);
                } else {
                    $this->data['bcolors'][] = $item;
                }
            })->all();

        }

        return $this;
    }

    public function getModeIColors()
    {
        if (isset($this->id) && $this->id > 0) {
            $images = connect()->table('car_equipment_colors')->select('*')->where('type', 'icolors')->where('equipmentId', $this->id)->orderBy('orderBy ASC')->getAll('array');
            collect($images)->map(function ($item)  {
                if ($file = $this->getFileInfo($item['fileId'])) {
                    $this->data['icolors'][] = ImageSizes::init()->get($item, $file);
                } else {
                    $this->data['icolors'][] = $item;
                }
            })->all();
        }

        return $this;
    }
    /** /EQUIPMENTS COLORS  */



    /**
     * Получение всех комплектации
     */
    public function getEquipments(): ?array
    {
        if ($equipments = connect($this->table)->select('equipmentId, modelId, sectionId, title')->orderBy('orderBy DESC')->where('status', 'V')->keyBy('equipmentId')) {
            foreach ($equipments as $equipmentId => $equipment) {
                $model = connect('car_models')->select('title')->where('modelId', $equipment['modelId'])->getValue();
                $newEquipments[$model][$equipmentId] = $equipment['title'];
            }
        }

        return $newEquipments ?? [];
    }


    public static function getName($equipmentId)
    {
        return connect('car_equipments')->select('title')->where('equipmentId', $equipmentId)->getValue();
    }

    /**
     * Получение ID модели `modelId`
     */
    public function getModelId($modificationId)
    {
        return  connect('car_modifications')->select('modelId')->where('modificationId', $modificationId)->getValue();
    }

    /**
     * Получение ID раздела `sectionId`
     */
    public function getModelSectionId($modelId)
    {
        return connect()->table('car_models')->select('sectionId')->where('modelId', $modelId)->getValue();
    }





}