<?php

namespace Mnv\Models\Cars;

use Mnv\Core\Mnv;
use Mnv\Core\Uploads\ImageCollection;

class GenerationPriceForPdf extends Mnv
{

    private $fields = 'title AS name, alias, modelId, fileName, url';

    public $model;
    public $models;

    public $modificationIds = [];

    public $features;

    public $equipments;
    public $equipmentIds = [];

    public $featureOptions = [];
    public $featureOptionsIds = [];
    public $options = [];
    public $optionIds = [];


    /**
     * ПОЛУЧИТЬ ВСЕ МОДЕЛИ
     */
    public function getModels()
    {
        $models = connect('car_models')->select($this->fields)->where('status', 'V')->orderBy('publishedOn DESC')->getAll();
        foreach ($models as $modelId => $model) {
            /** комплектации */
            $models[$modelId]->modifications = $this->getModifications($model->modelId);
            unset($models[$modelId]->modelId);
        }

        $this->models = $models;
    }

    /**
     * ПОЛУЧИТЬ модель
     * @param int|null $modelId
     */
    public function getModel(?int $modelId)
    {
        if (!empty($modelId)) {
            $this->model = connect('car_models')->select('title AS name, alias, modelId, fileName, url')->where('status', 'V')->where('modelId', $modelId)->get();
//            print_r(connect()->getQuery());
//            print_r($this->model);
            if (!empty($this->model)) {
                /** банер в шапке pdf */
                $this->getBanner($this->model->modelId);
                /** цвета кузова с картинками */
                $this->getBColors($this->model->modelId);
                /** комплектации */
                $this->model->modifications = $this->getModifications($this->model->modelId);
            } else {
                $this->model = null;
            }
        }


    }


    /**
     * @param $modelId
     */
    protected function getModifications($modelId)
    {
        if ($modifications = connect()->table('car_modifications')->select('modificationId, modelId, name')->orderBy('orderBy', 'ASC')->where('modelId', $modelId)->where('status', 'V')->indexKey('modificationId')->getAllIndexes()) {
            foreach ($modifications as $key => $modification) $this->modificationIds[$key] = $key;

            return $modifications;
        }
        return null;

    }

    /**
     * ПОЛУЧИТЬ СВОЙСТВА СПЕЦИФИКАЦИЙ
     */
    public function getFeaturesGroup()
    {
        if (!empty($this->modificationIds)) {
            $this->features = connect()->table('car_modifications_feature')->usingJoin('car_features_sp', 'featureId')->select('featureId, modificationId, name')->in('modificationId', array_keys($this->modificationIds))->where('status', 'V')->orderBy('orderBy', 'ASC')->cache(60)->indexKey('featureId')->getAllIndexes();
            foreach ($this->features as $featureId => $feature) {
                $this->features[$featureId]->params = $this->getFeatures($feature->featureId);
            }
        }
//         print_r($this->features);
        return $this->features;
    }

    /**
     * ПОЛУЧИТЬ СПЕЦИФИКАЦИИ
     */
    private function getFeatures($featureId)
    {
        $specifications = [];
        if (!empty($featureId)) {
            $specifications = connect()->table('car_modifications_specification')->usingJoin('car_specifications AS cs', 'specificationId')->select('specificationId, modificationId, name')->where('cs.featureId', $featureId)->in('modificationId', array_keys($this->modificationIds))->where('status', 'V')->cache(60)->indexKey('name')->getAllIndexes();

            if (!empty($specifications)) {
                foreach ($specifications as $specificationId => $specification) {
                    $specifications[$specificationId]->name = $specification->name;
                    $values = $this->getValues($specification->specificationId);
                    $specifications[$specificationId]->values = $values;
                }
            }
        }

        return $specifications;
    }

    /**
     * ПОЛУЧИТЬ ЗНАЧЕНИЕ СПЕЦИФИКАЦИИ
     */
    private function getValues($specificationId)
    {
        return connect()->table('car_modifications_specification_value')->select('specificationId, modificationId, value')->in('modificationId', array_keys($this->modificationIds))->where('specificationId', $specificationId)->orderBy('modificationId', 'DESC')->cache(60)->getAll();
    }


    /**
     * КОМПЛЕКТАЦИИ
     *
     * @param int $modelId
     * @return mixed
     */
    public function getEquipmentsGroup(int $modelId)
    {
        if (!empty($this->modificationIds)) {
            if ($this->equipments = connect('car_equipments')->select('equipmentId, modificationId, title, price')->orderBy('orderBy', 'ASC')->where('status', 'V')->where('modelId', $modelId)->in('modificationId', array_keys($this->modificationIds))->cache(60)->getAll()) {
                foreach ($this->equipments as $equipmentId => $equipment) {
                    $this->equipmentIds[$equipment->equipmentId] = $equipment->equipmentId;
                    $equipment->modification = connect()->table('car_modifications')->select('name')->where('modificationId', $equipment->modificationId)->getValue();
                }
            }
        }

//        print_r($this->equipmentIds);

        return $this->equipments;
    }

    /**
     * СВОЙСТВА ОПЦИЙ
     */
    public function getFeatureOptionsGroup()
    {
        if (!empty($this->equipmentIds)) {
            if ($this->featureOptions = connect()->table('car_equipments_feature')->usingJoin('car_features_op', 'featureId')->select('featureId, name')->orderBy('orderBy', 'ASC')->in('equipmentId', $this->equipmentIds)->where('status', 'V')->cache(60)->indexKey('featureId')->getAllIndexes()) {
                foreach ($this->featureOptions as $key => $featureOption) {
                    $this->featureOptionsIds[$key] = $key;
                    $this->featureOptions[$key]->options = $this->getFeatureOptions($featureOption->featureId);
                }
            }
        }
    }

    /**
     * ОПЦИИ
     * @param $featureId
     * @return mixed
     */
    public function getFeatureOptions($featureId)
    {
        if ($this->options = connect()->table('car_equipments_option AS ceo')->usingJoin('car_options AS co', 'optionId')->select('co.optionId, co.featureId, name')->orderBy('orderBy', 'ASC')
            ->where('ceo.featureId', $featureId)->in('equipmentId', $this->equipmentIds)->where('status', 'V')
            ->orderBy('co.orderBy')->indexKey('optionId')->getAllIndexes()) {

            foreach ($this->options as $optionId => $option) {
                $this->options[$optionId]->equipments = $this->getFeatureOptionsValue($option->optionId);
            }
        }

        return $this->options;
    }

    private function getFeatureOptionsValue($optionId)
    {
        $newItems = [];
        $equipments = connect('car_equipments_option')->select('optionId, featureId, equipmentId')->where('optionId', $optionId)->in('equipmentId', $this->equipmentIds)->cache(60)->indexKey('equipmentId')->getAllIndexes();
        foreach ($equipments as $itemKey => $equipment) {
            $newItems[$itemKey] = $equipment->equipmentId;
        }

        return $newItems;
    }



    private function getBanner($modelId)
    {
        if ($image = connect('car_model_images')->where('modelId', $modelId)->where('position', 'pdf')->orderBy('orderBy')->get()) {
            if ($file = connect()->table('files')->where('fileId', $image->fileId)->get()) {
                if (isset($file->fileName)) $this->model->banner = SITE_ROOT . $file->path . $file->fileName;
            }
        } else {
            $this->model->banner = null;
        }

    }
    /**
     * ЦВЕТ ЭКСТЕРЬЕРА (кузова)
     *
     * @param int $modelId
     */
    public function getBColors(int $modelId)
    {
        $images = connect('car_model_colors AS cec')
            ->usingJoin('car_colors AS cc', 'colorId')
            ->select('cc.colorId AS color_id, cc.colorName AS name, cc.colorCode AS code, cec.fileId')
            ->where('cec.type', 'bcolors')
            ->where('cec.modelId', $modelId)
            ->orderBy('cec.orderBy ASC')->getAll('array');
        $this->model->colors = $this->getColorImages($images);

    }


    private function getColorImages($images): array
    {
        return collect($images)->map(function ($item) {
            if ($file = connect('files')->where('fileId', $item['fileId'])->get('array')) {
                $image = ImageCollection::init()->get($item, $file);
                unset($image['large'], $image['medium'], $image['small'], $item['fileId']);
                $item['image'] = $image['original'];
            }
            return $item;
        })->all();
    }

    public function updateModelColPdf($modelId, $fileName): bool
    {
        if (connect()->table('sections')->where('sectionId', $modelId)->update(['pricePdf' => $fileName])) {
            return true;
        }

        return false;
    }

}